<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;
use Keskintech\KeskintechMarketplaces\KTMP_Product;
use Keskintech\KeskintechMarketplaces\KTMP_MarketplaceProduct;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_posts_clauses($clauses, $query) {
    global $wpdb;
    $orderby_type = 'DESC';
    if (isset($query->query_vars['ktmp_sort_type']) && strtoupper($query->query_vars['ktmp_sort_type']) == 'ASC') {
        $orderby_type = 'ASC';
    }
    if ($query->get('custom_orderby_meta_key') == 'ktmp_edited_date') {
        $clauses['join'] .= " LEFT JOIN $wpdb->postmeta pm1 ON ($wpdb->posts.ID = pm1.post_id AND pm1.meta_key = 'ktmp_edited_date') ";
        $clauses['orderby'] = " COALESCE(pm1.meta_value, '') $orderby_type, $wpdb->posts.post_date $orderby_type ";
    }
	return $clauses;
}
function ktmp_price_by_product_table(){
	$cached_base_to_price = [];
	$marketplace_price_rules = [];
	$ktmp_marketplace = KTMP_Marketplace::get_instance();
	$MarketplaceProduct = new KTMP_MarketplaceProduct();
	$marketplaces = $ktmp_marketplace->getAllMarketplaces(true);
	$paged = ( isset( $_GET['paged'] ) && is_numeric( $_GET['paged'] ) ) ? absint( $_GET['paged'] ) : 1;
	$posts_per_page = isset($_GET['posts_per_page']) ? absint($_GET['posts_per_page']) : 20;
    $args = array(
            'post_type'              => 'product',
            'posts_per_page'         => $posts_per_page,
            'paged'                  => $paged,
            'custom_orderby_meta_key'=> 'ktmp_edited_date',
		    'post_status'            => 'publish' 
          );
    if (isset($_GET['search'])) {
        $args['s'] = sanitize_text_field($_GET['search']);
    }
    if(isset($_GET['order'])){
        add_filter('posts_clauses', 'ktmp_posts_clauses', 10, 2);
        $sort_type = sanitize_text_field($_GET['order']);
        $args['ktmp_sort_type'] = $sort_type;
	    $order = sanitize_text_field($_GET['order']);
    }
    else {
        $order = 0;
    }
	$products_query = new WP_Query( $args ); ?>
	<div class="wrap ktmp-product-list ktmp-product-table">
	<h1 class="wp-heading-inline ktmp_full_width"><?php esc_html_e( 'Products', 'keskintech-marketplaces' ); ?></h1>
	<p class="search-box">
	<form class="ktmp-product-filter" action="<?php echo esc_url(admin_url('admin.php')); ?>" method="get">
    <input type="hidden" name="page" value="ktmp-pricing">
<?php  if(isset($_GET['order'])): ?>
         <input type="hidden" name="order" value="<?php echo esc_attr(sanitize_text_field($_GET['order'])); ?>">
<?php   endif; ?>
    <label for="posts_per_page_select"><?php esc_html_e('Display:', 'keskintech-marketplaces'); ?></label>
    <select id="posts_per_page_select" name="posts_per_page" onchange="this.form.submit()">
        <option value="20" <?php selected(isset($_GET['posts_per_page']) && $_GET['posts_per_page'] == 20); ?>>20</option>
        <option value="50" <?php selected(isset($_GET['posts_per_page']) && $_GET['posts_per_page'] == 50); ?>>50</option>
        <option value="100" <?php selected(isset($_GET['posts_per_page']) && $_GET['posts_per_page'] == 100); ?>>100</option>
        <option value="250" <?php selected(isset($_GET['posts_per_page']) && $_GET['posts_per_page'] == 250); ?>>250</option>
        <option value="500" <?php selected(isset($_GET['posts_per_page']) && $_GET['posts_per_page'] == 500); ?>>500</option>
    </select>
    <input type="text" name="search" value="<?php echo isset($_GET['search']) ? esc_attr(sanitize_text_field($_GET['search'])) : ''; ?>">
    <button class="button" type="submit"><?php esc_html_e('Search Products', 'keskintech-marketplaces'); ?></button>
</form>

    </p>
	<form action="" method="post" id="ktmp-price-type">
	  <button type="submit" id="keskintech-mother-buton" class="page-title-action" name="editButton"><?php esc_html_e( 'Edit Product Prices', 'keskintech-marketplaces' ); ?></button>
	  <button type="submit" id="ktmp-fixed-button" class="ktmp-fixed-button" name="editButton"><?php esc_html_e( 'Edit Product Prices', 'keskintech-marketplaces' ); ?></button>
	  <table id="ktmp-expand-table">
        <thead style="background-color:yellow">
		  <tr id="ana-satir">
		  <th>ID</th>
		  <th><?php esc_html_e( 'SKU', 'keskintech-marketplaces' ); ?></th>
          <th><?php esc_html_e( 'Select', 'keskintech-marketplaces' ); ?></th>
          <th><?php esc_html_e( 'Expand', 'keskintech-marketplaces' ); ?></th>
		  <th>
		      <a href="?page=ktmp-pricing<?php echo isset($_GET['search']) ? '&search=' . esc_attr(sanitize_text_field($_GET['search'])) : ''; ?><?php echo isset($_GET['posts_per_page']) ? '&posts_per_page=' . esc_attr(sanitize_text_field($_GET['posts_per_page'])) : ''; ?>&order=<?php echo ($order == 'ASC') ? 'DESC' : 'ASC'; ?>">
			    <?php esc_html_e('Last Edited Date', 'keskintech-marketplaces'); ?>
			    <span class="ktmp-sort-icon"><?php echo ($order == 'ASC') ? '&#9650;' : '&#9660;'; ?></span>
			  </a>
		  </th>
		  <th><?php esc_html_e( 'Product', 'keskintech-marketplaces' ); ?></th>
          <th><?php esc_html_e( 'Current Site Price', 'keskintech-marketplaces' ); ?></th>
<?php     foreach ($marketplaces as $marketplace) {
			    $KeskintechMarketplacePricingRules = $ktmp_marketplace->GetPricingRules($marketplace->marketplace_id);
				if(!empty($KeskintechMarketplacePricingRules)) {
                    $marketplace_price_rules[$marketplace->marketplace_id] = $KeskintechMarketplacePricingRules;
                }
				if($marketplace->marketplace_id != 1){
				  echo "<th>" . esc_html($marketplace->market_name) . "</th>";
				}
			    else{
				    echo '<th>' . esc_html__( 'Product Constant', 'keskintech-marketplaces' ) . '</th>';
			    }
          }
		  ?>
		  </tr>
		</thead>
        <tbody>
<?php   while ($products_query->have_posts()) {
				$products_query->the_post();
				global $product;
				$product_type = $product->get_type();
                $product_id = $product->get_id();			
                if ($product_type === 'simple') {
					$last_edited_date = ktmp_ProductGetLastEditedDate($product_id); ?>
					<tr id="ana-satir">
					    <td><?php echo esc_html($product_id);?></td>
						<td><?php echo esc_html($product->get_sku()); ?></td>
                        <td> <input type="checkbox" name="product_id[]" value="<?php echo esc_html($product_id); ?>"> </td>
                        <td></td>
						<td><?php echo esc_html($last_edited_date); ?> </td>
						<td><?php echo esc_html($product->get_title()); ?> </td>
                        <td><?php echo esc_html($product->get_price()); ?> </td>
<?php					foreach ($marketplaces as $marketplace) {
	                       $pricing_primary = $MarketplaceProduct->ProductPrimaryPrice($marketplace->marketplace_id, $product_id);
                           if ($marketplace->marketplace_id == 1 || $pricing_primary !== null) {
                              $price = [$pricing_primary, 'pricing-primary']; 
                           }
						   else{
							   $ProductBaseValue = $MarketplaceProduct->ProductBaseValue($product_id, $marketplace->marketplace_id);
                               if ($ProductBaseValue && isset($marketplace_price_rules[$marketplace->marketplace_id])) {
								   if (isset($cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id])) {
                                        $price = [$cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id], 'pricing-rule'];
                                   }
								   else {
                                        $PriceRuleTransactionResult = $MarketplaceProduct->PriceRuleTransactionResult($product_id, $marketplace->marketplace_id, $ProductBaseValue, $marketplace_price_rules[$marketplace->marketplace_id]);
                                        if ($PriceRuleTransactionResult !== false) {
                                           $cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id] = $PriceRuleTransactionResult;
                                           $price = [$PriceRuleTransactionResult, 'pricing-rule'];
                                        } else {
                                           $price = [get_post_meta($product_id, '_price', true), 'pricing-current-site'];
                                        }
                                   }
							  }
							  else {
                                   $price = [get_post_meta($product_id, '_price', true), 'pricing-current-site'];
                              }
						   }
						   if($marketplace->marketplace_id == 1){
							   echo '<td>' . esc_html($price[0]) . '</td>';
						   }
						   else{
							   echo '<td>' . esc_html($price[0]) . ' <span class="'. esc_html($price[1]) .'"></span></td>';
						   }
                        }
					echo '</tr>'; 
				} elseif ($product_type === 'variable') {
?>                  <tr>
					    <td><?php echo esc_html($product_id); ?></td>
						<td><?php echo esc_html($product->get_sku()); ?></td>
                        <td> <input type="checkbox" data-toggle="<?php echo esc_attr($product_id); ?>"> </td>
                        <td> <button class="ktmp-expand-button" data-toggle="<?php echo esc_attr($product_id); ?>"><?php esc_html_e( 'Expand', 'keskintech-marketplaces' ); ?></button></td>
						<td><?php echo esc_html(ktmp_ProductGetLastEditedDate($product_id)); ?></td>
                        <td> <?php echo esc_html($product->get_title()); ?></td>
                    </tr>               
<?php		        
					$variations = get_children(array(
                                                       'post_parent' => $product_id,
                                                       'post_type' => 'product_variation',
                                                       'posts_per_page' => -1,
                    ));
                    $last_edited_dates = [];
                    $marketplace_prices = [];
					foreach ($variations as $variation) {
						$variation_id = $variation->ID;
                        if (!isset($last_edited_dates[$variation_id])) {
                           $last_edited_dates[$variation_id] = ktmp_ProductGetLastEditedDate($variation_id);
                        }
                        foreach ($marketplaces as $marketplace) {
                           if (!isset($marketplace_prices[$variation_id][$marketplace->marketplace_id])) {
                              $pricing_primary = $MarketplaceProduct->ProductPrimaryPrice($marketplace->marketplace_id, $variation_id);
                              if ($marketplace->marketplace_id == 1 || $pricing_primary !== null) {
                                 $marketplace_prices[$variation_id][$marketplace->marketplace_id] = [$pricing_primary, 'pricing-primary']; 
                              } else {
                                 $ProductBaseValue = $MarketplaceProduct->ProductBaseValue($variation_id, $marketplace->marketplace_id);
                                 if ($ProductBaseValue && isset($marketplace_price_rules[$marketplace->marketplace_id])) {
                                     if (isset($cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id])) {
                                        $marketplace_prices[$variation_id][$marketplace->marketplace_id] = [$cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id], 'pricing-rule'];
                                     } else {
                                        $PriceRuleTransactionResult = $MarketplaceProduct->PriceRuleTransactionResult($variation_id, $marketplace->marketplace_id, $ProductBaseValue, $marketplace_price_rules[$marketplace->marketplace_id]);
                                        if ($PriceRuleTransactionResult !== false) {
                                           $cached_base_to_price[$ProductBaseValue][$marketplace->marketplace_id] = $PriceRuleTransactionResult;
                                           $marketplace_prices[$variation_id][$marketplace->marketplace_id] = [$PriceRuleTransactionResult, 'pricing-rule'];
                                        } else {
                                           $marketplace_prices[$variation_id][$marketplace->marketplace_id] = [get_post_meta($variation_id, '_price', true), 'pricing-current-site'];
                                        }
                                     }
                                } else {
                                     $marketplace_prices[$variation_id][$marketplace->marketplace_id] = [get_post_meta($variation_id, '_price', true), 'pricing-current-site'];
                                }
                             }                           
                          }
                       }
                    } 
					foreach ($variations as $variation) {
						$variation_id = $variation->ID;
						$variation_obj = new WC_Product_Variation($variation_id);
                        $display_price = $variation_obj->get_price();
                        $last_edited_date = isset($last_edited_dates[$variation_id]) ? $last_edited_dates[$variation_id] : '';
                        echo '<tr class="ktmp-sub-row" data-parent="' . esc_attr($product_id) . '">';
						echo '<td>' . esc_html($variation_id) . '</td>';
						echo '<td>' . esc_html(get_post_meta($variation_id, '_sku', true)) . '</td>';
                        echo '<td></td>';
						echo '<td><input type="checkbox" name="product_id[]" value="' . esc_attr($variation_id) . '" data-parent="' . esc_attr($product_id) . '"></td>';
						echo '<td>'. esc_html($last_edited_date).'</td>';
						echo '<td>';
                        $variation_attributes = $variation_obj->get_attributes();
						$values = array_filter($variation_attributes, function($value, $key) {
                            return $value !== '' && $value !== null && $key !== '' && $key !== null;
                        }, ARRAY_FILTER_USE_BOTH);
						echo implode(', ', array_map('esc_html', array_values($values)));
                        echo '</td>';
                        echo '<td>' . esc_html($display_price) . '</td>';
						foreach ($marketplaces as $marketplace) {
                               $price = $marketplace_prices[$variation_id][$marketplace->marketplace_id];
                               if($marketplace->marketplace_id == 1){
									echo '<td>' . esc_html($price[0]) . '</td>';
								}
								else{
									echo '<td>' . esc_html($price[0]) . ' <span class="'.esc_attr($price[1]).'"></span></td>';
								}
                        }
						echo '</tr>';
					}
				}
        }
		wp_reset_postdata(); ?>
         </tbody>
       </table>
     </form>
	 <div class="ktmp-pagination">
<?php  $base_url = add_query_arg( array(
         'page'          => 'ktmp-pricing',
         'order'         => isset($_GET['order']) ? sanitize_text_field($_GET['order']) : null,
         'posts_per_page'=> isset($_GET['posts_per_page']) ? intval($_GET['posts_per_page']) : null,
         'search'        => isset($_GET['search']) ? sanitize_text_field($_GET['search']) : null,
       ), admin_url( 'admin.php' ) );
       $pagination_links = paginate_links( array(
         'base'    => $base_url . '%_%',
         'format'  => '&paged=%#%',
         'total'   => intval( $products_query->max_num_pages ),
         'current' => intval( $paged ),
       ) );
       echo wp_kses_post( $pagination_links ); ?>	 		
      </div>
   </div>
<?php 
  wp_localize_script('ktmp-admin-script', 'ktmpCSSData', array(
        'pricing_primary' => esc_html__('You have set this price for this product yourself.', 'keskintech-marketplaces'),
        'pricing_rule' => esc_html__('Marketplace price rules applied.', 'keskintech-marketplaces'),
        'current_site' => esc_html__('Current site price applied.', 'keskintech-marketplaces'),
    ));
}
$KeskintechMarketplace = KTMP_Marketplace::get_instance();
$marketplaces = $KeskintechMarketplace->getAllMarketplaces(true);
$KeskintechProduct = new KTMP_Product();
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_price'])) {
	$success = false;
    $sanitizedProducts = array_map('absint', $_POST['selectedProducts']);
	if(is_array($sanitizedProducts)){
	  $marketplace_common_price = $KeskintechMarketplace->marketplace_common_price($sanitizedProducts);
      foreach ($sanitizedProducts as $product_id) {
        foreach ($marketplaces as $marketplace) {		
            $marketplace_id = $marketplace->marketplace_id;
            $marketplace_value = isset($_POST[$marketplace_id]) && $_POST[$marketplace_id] !== '' ? floatval($_POST[$marketplace_id]) : '';
            if(($marketplace_common_price[$marketplace_id] !== $marketplace_value && $marketplace_value > 0) || ($marketplace_value == '' && $marketplace_common_price[$marketplace_id] !=='')){
				$existing_data = $KeskintechProduct->IsThereaPrice($marketplace_id, $product_id);
				if (!$existing_data && $marketplace_value != '') {
				    $result = $KeskintechProduct->Product_Price_Transactions('add', $product_id, $marketplace_id, $marketplace_value);			
                } 
			    elseif ($existing_data) {
                    if ($marketplace_value != '') {
                        $result = $KeskintechProduct->Product_Price_Transactions('update', $product_id, $marketplace_id, $marketplace_value);
                     } else {
                        $result = $KeskintechProduct->Product_Price_Transactions('delete', $product_id, $marketplace_id, $marketplace_value);
                     }
                }
		        if(isset($result) && $result){
			      $success = true;
   		        }
			}
		}
      }
      if($success){
		$sanitized_products = array_map('absint', $_POST['ProductstoDate']);
		$current_date = current_time('Y-m-d H:i:s');
        foreach ($sanitized_products as $product_id_to_date){
			 ktmp_ProductAddLastEditedDate($product_id_to_date,$current_date);
		}		
		echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Prices successfully updated!', 'keskintech-marketplaces' ) . '</p></div>';
	  }
	  else{
		echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'An error occurred while updating product prices.', 'keskintech-marketplaces' ) . '</p></div>';
      }
	}
}
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['editButton'])) {
	if (isset($_POST['product_id']) && is_array($_POST['product_id'])) {
		$sanitized_products = array_map('absint', $_POST['product_id']);
		$marketplace_common_price = $KeskintechMarketplace->marketplace_common_price($sanitized_products);
		echo '<h2 class="ktmp-sub-heading">' . esc_html__( 'Currently Edited Products:', 'keskintech-marketplaces' ) . '</h2><div class="ktmp-max-height">';
		$products_to_date = [];
		foreach ($sanitized_products as $product_id) {
			 $product = wc_get_product($product_id );
			 $products_to_date[]= $product_id;
			 $product_name = $product->get_name(); 
			 if($product->get_type() == 'variation'){
				 $parent_id = $product->get_parent_id();
				 if(!in_array($parent_id, $products_to_date)){
					$products_to_date[]= $parent_id;
				 }
			 }
			 echo 'SKU:' . esc_html($product->get_sku()) . ' Name: ' . esc_html($product_name) . '<br>';
 		}
		echo '</div><div class="ktmp-edit-column"><h2>' . esc_html__( 'Edit Product Prices', 'keskintech-marketplaces' ) . '</h2> <form action="" class="ktmp-column-form" id="urun-form" method="post">';
		foreach ($sanitized_products as $product_id) {
            echo '<input type="hidden" name="selectedProducts[]" value="' . esc_attr($product_id) . '">';
		}
		foreach($products_to_date as $p){
			echo '<input type="hidden" name="ProductstoDate[]" value="' . esc_attr($p) . '">';
		}
		echo '<table><tr>';
		foreach($marketplaces as $marketplace){
			if($marketplace->marketplace_id == 1){
			   echo '<th>' . esc_html__( 'Product Constant', 'keskintech-marketplaces' ) . '</th>';
			}
			else {
			   echo '<th>' . esc_html($marketplace->market_name) . '</th>';
			}
		}
		echo '</tr><tr>';
		foreach ($marketplaces as $marketplace) {
            echo '<td>';
            if ($marketplace->marketplace_id == 1) {
                echo '<label for="' . esc_attr($marketplace->marketplace_id) . '">' . esc_html__('Product Constant', 'keskintech-marketplaces') . '</label><br>';
            } else {
                echo '<label for="' . esc_attr($marketplace->marketplace_id) . '">' . esc_html($marketplace->market_name) . '</label><br>';
            }
            echo '<input type="number" step="0.01" name="' . esc_attr($marketplace->marketplace_id) . '" value="' . esc_attr($marketplace_common_price[$marketplace->marketplace_id]) . '" min="0.01">';
            echo '</td>';
        }
        echo '</tr></table><input type="submit" name="update_price" value="' . esc_html__( 'Update', 'keskintech-marketplaces' ) . '" class="ktmp-column-button ktmp-green-button"></form></div>';
    }
	else {echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'No product selected!', 'keskintech-marketplaces' ) . '</p></div>';}
}
ktmp_price_by_product_table();
?>