<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;

if ( ! defined( 'ABSPATH' ) ) exit;
$KeskintechMarketplace = KTMP_Marketplace::get_instance();
if (isset($_POST['ktmp-save-pricing-rules'])) {
  $marketplace_id = intval($_POST['marketplace_id']);
  $base = intval($_POST['base']);
  $KeskintechMarketplace->DeleteMarketplacePricingRules($marketplace_id);
  $KeskintechMarketplace->AddBaseFrom($marketplace_id, $base);
  if($_POST['ktmp-rounding'] == 1){
	$round_type = isset( $_POST['round-type'] ) ? sanitize_text_field($_POST['round-type']) : 'decimal';
    $round_value = isset( $_POST['round-value'] ) ? sanitize_text_field($_POST['round-value']) : '90';  
	$KeskintechMarketplace->RoundingRule($marketplace_id, $round_type, $round_value);
  }
  else {
	$KeskintechMarketplace->DeleteRoundingRule($marketplace_id);
  }
  $inputCount = intval($_POST['inputCount']);
  for ($i = 1; $i <= $inputCount; $i++) {
    $operation_type = sanitize_text_field($_POST['operation_' . $i]);
    $value = sanitize_text_field($_POST['value_' . $i]);
    $KeskintechMarketplace->AddMarketplacePricingRule($marketplace_id, $i, $operation_type, $value);
  }
}
$marketplaces = $KeskintechMarketplace->getAllMarketplaces();
if (empty($marketplaces)){
  ktmp_no_marketplace_warning();
}
else{
  echo '<div class="ktmp-container"><aside class="ktmp-sidebar">';
  $marketplaces = $KeskintechMarketplace->getAllMarketplaces();
  foreach ($marketplaces as $index => $marketplace) {
    $marketplace_ids[] = $marketplace->marketplace_id;
	if($index === 0){
	  $current_section = isset($_GET['marketplace_id']) ? intval($_GET['marketplace_id']) : $marketplace->marketplace_id;
	}
	echo '<a href="?page=ktmp-pricing&tab=marketplace-price-rules&marketplace_id=' . intval($marketplace->marketplace_id) . '" class="' . ($current_section == $marketplace->marketplace_id ? 'active' : '') . '">' . esc_html($marketplace->market_name) . '</a>';
  }
  echo '</aside><div class="ktmp-content">';
  if (in_array($current_section, $marketplace_ids)) {
    echo '<div class="tab-content">';
	$base_value = $KeskintechMarketplace->BaseFrom($current_section);
	$pricing_rules = $KeskintechMarketplace->GetPricingRules($current_section);
	$get_rounding_rule = $KeskintechMarketplace->GetRoundingRule($current_section); ?>
	<form action="" id="ktmp-pricing-rules-form" method="post">
      <input type="hidden" name="marketplace_id" value="<?php echo intval($current_section); ?>">
      <label for="base"><?php esc_html_e( 'Base Value:', 'keskintech-marketplaces' ); ?></label>
      <select name="base" id="base">
        <option value="0" <?php echo ($base_value == 0) ? 'selected' : ''; ?>><?php esc_html_e( 'Site Price', 'keskintech-marketplaces' ); ?></option>
        <option value="1" <?php echo ($base_value == 1) ? 'selected' : ''; ?>><?php esc_html_e( 'Product Constant', 'keskintech-marketplaces' ); ?></option>
      </select>
	  <div id="ktmp-input-container">
<?php    foreach ($pricing_rules as $index => $rule): ?>
            <div class="ktmp-input-pair">
			 <label>
<?php          /* translators: %d: The rule number */ 
			   printf( esc_html__( 'Rule %d:', 'keskintech-marketplaces' ), esc_html(intval($index) + 1) ); ?>
			 </label>
              <select name="operation_<?php echo esc_html(intval($index) + 1); ?>">
                <option value="addition" <?php echo ($rule['operation_type'] == 'addition') ? 'selected' : ''; ?>><?php esc_html_e( 'Addition', 'keskintech-marketplaces' ); ?></option>
                <option value="subtraction" <?php echo ($rule['operation_type'] == 'subtraction') ? 'selected' : ''; ?>><?php esc_html_e( 'Subtraction', 'keskintech-marketplaces' ); ?></option>
                <option value="multiplication" <?php echo ($rule['operation_type'] == 'multiplication') ? 'selected' : ''; ?>><?php esc_html_e( 'Multiplication', 'keskintech-marketplaces' ); ?></option>
                <option value="division" <?php echo ($rule['operation_type'] == 'division') ? 'selected' : ''; ?>><?php esc_html_e( 'Division', 'keskintech-marketplaces' ); ?></option>
              </select>
			  <input type="number" step="0.01" min="0.01" name="value_<?php echo esc_html(intval($index + 1)); ?>" value="<?php echo esc_attr($rule['value']); ?>" placeholder="<?php esc_attr_e( 'Enter Value', 'keskintech-marketplaces' ); ?>" required>
              <span class="ktmp-remove-btn" onclick="ktmRemoveInput(this)"><?php esc_html_e( 'Remove', 'keskintech-marketplaces' ); ?></span>
            </div>
<?php     endforeach; ?>
     </div>
     <label for="ktmp-rounding"><?php esc_html_e( 'Round?', 'keskintech-marketplaces' ); ?></label>
     <input type="radio" name="ktmp-rounding" id="ktmp-round-it" value="1" <?php echo ($get_rounding_rule !== false) ? 'checked' : ''; ?>> <?php esc_html_e( 'Yes', 'keskintech-marketplaces' ); ?>
     <input type="radio" name="ktmp-rounding" id="ktmp-not-round" value="0" <?php echo ($get_rounding_rule === false) ? 'checked' : ''; ?>> <?php esc_html_e( 'No', 'keskintech-marketplaces' ); ?>
     <div id="ktmp-rounding-rules" style="display: <?php echo (($get_rounding_rule !== false && $get_rounding_rule['round-type'] == 1) ? 'block' : 'none'); ?>;">
       <label for="round-type"><?php esc_html_e( 'Rounding Type:', 'keskintech-marketplaces' ); ?></label>
       <select name="round-type" id="round-type">
         <option value="decimal" <?php echo ($get_rounding_rule !== false && $get_rounding_rule['round-type'] == 'decimal') ? 'selected' : ''; ?>><?php esc_html_e( 'Decimal Places', 'keskintech-marketplaces' ); ?></option>
         <option value="ones" <?php echo ($get_rounding_rule !== false && $get_rounding_rule['round-type'] == 'ones') ? 'selected' : ''; ?>><?php esc_html_e( 'Ones Place', 'keskintech-marketplaces' ); ?></option>
         <option value="tens" <?php echo ($get_rounding_rule !== false && $get_rounding_rule['round-type'] == 'tens') ? 'selected' : ''; ?>><?php esc_html_e( 'Tens Place', 'keskintech-marketplaces' ); ?></option>
         <option value="hundreds" <?php echo ($get_rounding_rule !== false && $get_rounding_rule['round-type'] == 'hundreds') ? 'selected' : ''; ?>><?php esc_html_e( 'Hundreds Place', 'keskintech-marketplaces' ); ?></option>
       </select>
       <label for="round-value"><?php esc_html_e( 'Rounding Value:', 'keskintech-marketplaces' ); ?></label>
       <input type="text" name="round-value" id="round-value" value="<?php echo ($get_rounding_rule !== false) ? esc_attr($get_rounding_rule['round-value']) : ''; ?>" placeholder="<?php esc_attr_e( 'Enter Value', 'keskintech-marketplaces' ); ?>">
     </div>
     <button type="button" onclick="ktmAddInput()" class="ktmp-green-button"><?php esc_html_e( 'Add New Rule', 'keskintech-marketplaces' ); ?></button>
     <input type="hidden" name="inputCount" id="inputCount" value="<?php echo count($pricing_rules); ?>">
     <button type="submit" name="ktmp-save-pricing-rules" class="ktmp-save"><?php esc_html_e( 'Save', 'keskintech-marketplaces' ); ?></button>
   </form>
 
</div></div></div>
<?php 
      wp_enqueue_script('ktmp_price_rules_script', KTMP_PLUGIN_URL . 'js/ktmp-price-rules.min.js', array('jquery'), '1.0', true);
	  wp_localize_script('ktmp_price_rules_script', 'ktmpData', array(
        'initialInputCount' => count($pricing_rules),
        'addition' => esc_html__( 'Addition', 'keskintech-marketplaces' ),
        'subtraction' => esc_html__( 'Subtraction', 'keskintech-marketplaces' ),
		'multiplication' => esc_html__( 'Multiplication', 'keskintech-marketplaces' ),
		'division' => esc_html__( 'Division', 'keskintech-marketplaces' ),
		'enterValue' =>esc_html__( 'Enter Value', 'keskintech-marketplaces' ),
		'removeText' => esc_html__( 'Remove', 'keskintech-marketplaces' ),
		'ruleLabel' => esc_html__( 'Rule ', 'keskintech-marketplaces' ),
      ));

    } 
}
