<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_get_editing_name($id, $type){
	if($type == 'term'){
		$term = get_term($id);
		if(!is_wp_error($term) && $term){
		   $taxonomy = get_taxonomy($term->taxonomy);
	 	   if ( strpos( $taxonomy->name, 'pa_' ) === 0 ) {
			  return $term->name;
		   }
		   else{
              return false;
		   }			
	    }
	}	
	elseif($type == 'att_taxonomy'){
		$taxonomy = get_taxonomy($id);
		if ($taxonomy &&  strpos( $taxonomy->name, 'pa_' ) === 0 ) {
			return $taxonomy->labels->singular_name;
		}
	}
	elseif($type == 'brand'){
		if($id == 0 ){
			$name = get_option('ktmp_fixed_brand');
			return $name ? $name : false;
		}
		else{
	        $term = get_term($id);
			$brand_term = get_option('ktmp_brand_term');
			if(!is_wp_error($term) && $term && $brand_term && ($term->taxonomy == $brand_term)){
				return $term->name;
			}
		}
	}
	return false;
}
function ktmp_match_process($type){
	if (isset($_GET['type']) && $_GET['type'] === 'att-taxonomy') {
		$type = 'att_taxonomy';
	}
	$KeskintechMarketplace = KTMP_Marketplace::get_instance();
	if (isset($_POST['update_matches']) && isset($_POST['ktmp_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['ktmp_nonce'])), 'ktmp_match_process_nonce')) {
	  $key_1 = sanitize_text_field($_POST['term_id']);
	  $MatchTerm = true;
	  $DeleteMatchedTerm = true;
	  $defaultValues = $KeskintechMarketplace->GetMatchedTerms($key_1,$type);
	  if (isset($_POST['marketplace_id']) && isset($_POST['matched_value'])) {
		$marketplace_ids = array_map('intval', $_POST['marketplace_id']);
		$matched_values = array_map('sanitize_text_field', array_combine(array_map('intval', array_keys($_POST['matched_value'])), array_values($_POST['matched_value'])));
	    foreach ($marketplace_ids as $marketplace_id) {
          if (is_numeric($marketplace_id)) {
			$new_value = sanitize_text_field($matched_values[$marketplace_id]);
			if (array_key_exists($marketplace_id, $defaultValues)) {
		      if($new_value !== $defaultValues[$marketplace_id]){
			    if($new_value !== ''){
				  $MatchTerm = $KeskintechMarketplace->MatchTerm($key_1, $new_value, $marketplace_id, $type);
				}
				else{
				  $DeleteMatchedTerm = $KeskintechMarketplace->DeleteMatchedTerm($key_1,$marketplace_id,$type);
				}
			  }
			}
			else{
                if($new_value !==''){
				  $MatchTerm = $KeskintechMarketplace->MatchTerm($key_1, $new_value, $marketplace_id, $type);
				}
            }
		  }
        }
	  }
	  if(!$MatchTerm || !$DeleteMatchedTerm){
	    echo '<div class="notice notice-error is-dismissible"><p>';
		esc_html__('An error occurred. Terms were not matched.', 'keskintech-marketplaces');
		echo '</p></div>';
	  }
	  else{
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Terms matched successfully!', 'keskintech-marketplaces') . '</p></div>';
	  }
    } 
    if (isset($_GET['edit']) && !isset($_POST['update_matches']) ){
	  $editTermId = sanitize_text_field( $_GET['edit'] );
	  $term_name = ktmp_get_editing_name($editTermId, $type);
	  if($term_name){
	    $defaultValues = $KeskintechMarketplace->GetMatchedTerms($editTermId,$type);
        echo '<div class="ktmp-edit-column"><form action ="" class="ktmp-column-form" method="post">';
        echo '<input type="hidden" name="term_id" value="' . esc_attr($editTermId) . '">';
        $marketplaces = $KeskintechMarketplace->getAllMarketplaces();
		wp_nonce_field('ktmp_match_process_nonce', 'ktmp_nonce');
		if ($marketplaces) {
		   /* translators: %s: The term name being edited */
		   echo '<h2 class="ktmp-sub-heading">' . sprintf(esc_html__('Currently Editing: %s', 'keskintech-marketplaces'), esc_html($term_name)) . '</h2>';
           echo '<table><tr>';
           foreach ($marketplaces as $marketplace) {
               echo '<th>' . esc_html($marketplace->market_name) . '</th>';
           }
           echo '</tr><tr>';
		   foreach ($marketplaces as $marketplace) {
			   $inputName = $marketplace->marketplace_id;
			   $defaultValue = isset($defaultValues[$inputName]) ? $defaultValues[$inputName] : '';
			   echo '<input type="hidden" name="marketplace_id[]" value="' . esc_attr($inputName) . '">'; 
               echo '<td><br><input type="text" name="matched_value[' . esc_attr($marketplace->marketplace_id) . ']" value="'. esc_attr($defaultValue) .'"></td>';
		   }
           echo '</tr></table><input type="submit" name="update_matches" value="' . esc_attr__('Update.', 'keskintech-marketplaces') . '" class="ktmp-column-button ktmp-green-button"></form></div>';
       } 
	   else {
		   ktmp_no_marketplace_warning();
       }
     }
	 else{
		 echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'No such term was found.', 'keskintech-marketplaces' ) . '</p></div>';
	 }
   }
}
