<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_brand_issue() { ?>
    <div class="ktmp-warning-box">
        <?php
        $message = sprintf(
            esc_html__(
                'Warning: Please make brand settings first. Click %1$shere%2$s for brand settings.', 
                'keskintech-marketplaces'
            ),
            '<a href="' . esc_url(get_site_url() . '/wp-admin/admin.php?page=ktmp-settings') . '" class="ktmp-warning-a">',
            '</a>'
        );
        echo wp_kses_post($message);
        ?>
    </div>
<?php }
echo '<h1>' . esc_html__('Brand Matching', 'keskintech-marketplaces') . '</h1><div class="wrap">';
ktmp_match_process('brand');
$brand_options = get_option('ktmp_brand_options');
if (!$brand_options || $brand_options =='passive') {
   ktmp_brand_issue();
}
else{
   $term_table = array();
   $brand_from = get_option('ktmp_brand_from');
   if($brand_from =='term'){
	 $taxonomy = get_option('ktmp_brand_term');
     if($taxonomy) {
        $terms = get_terms(array(
          'taxonomy' => $taxonomy,
          'hide_empty' => false,
        ));
        if(!empty($terms) && !is_wp_error( $terms )){
		     $brands = $terms;
        }
     }
   }
   elseif($brand_from=='fixed-brand'){
	   $brand = get_option('ktmp_fixed_brand');
	   if($brand){
		 $brands = array(
           0 => (object) array(
            'term_id' => 0,
            'name' => $brand,
           )
         ); 
	   }
   }
   if(isset($brands) && !empty($brands)){
	   $KeskintechMarketplace = KTMP_Marketplace::get_instance();
	   $marketplaces = $KeskintechMarketplace->getAllMarketplaces(); ?>
	   <table class="wp-list-table widefat fixed striped ktmp-term-table">
		     <thead>
               <tr>
                 <th><?php esc_html_e('Brand Name', 'keskintech-marketplaces'); ?></th>
                  <?php
				  foreach ($marketplaces as $marketplace){
					  $percent_value = $KeskintechMarketplace->MarketplacesGetPercent($marketplace->marketplace_id,'brand', count($brands));
					  echo '<th>' . esc_html($marketplace->market_name) . ' (%' . esc_attr($percent_value) . ')';
					  if($percent_value != NULL){
                      echo ' <div class="ktmp-progress-container"><div class="ktmp-progress-bar" style="width: ' . esc_attr($percent_value) . '%;"></div>';
					  }
					  echo '</th>';
				  } ?>
				  <th><?php esc_html_e('Match', 'keskintech-marketplaces'); ?></th>
               </tr>
             </thead>
             <tbody> 
<?php          foreach($brands as $brand){
	              $defaultValues = $KeskintechMarketplace->GetMatchedTerms($brand->term_id, 'brand');
	              echo '<tr><td>'. esc_html($brand->name) . '</td>';
				  foreach ($marketplaces as $marketplace){
					  $defaultValue = isset($defaultValues[$marketplace->marketplace_id]) ? $defaultValues[$marketplace->marketplace_id] : '';
					  echo '<td>'. esc_attr($defaultValue) .'</td>';
				  }
				  echo '<td><a href="?page=ktmp-matching-fields&tab=brands&edit=' . esc_attr($brand->term_id) . '">' . esc_html__('Match the brand', 'keskintech-marketplaces') . '</a></td></tr>';
               } 
               echo '</tbody></table>';		   
   }
   else{
	   ktmp_brand_issue();
   }
}
echo '</div>';