<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;

if ( ! defined( 'ABSPATH' ) ) exit;
$KeskintechMarketplace = KTMP_Marketplace::get_instance();
$marketplaces = $KeskintechMarketplace->getAllMarketplaces();
ktmp_match_process('term');
$attribute_taxonomies = wc_get_attribute_taxonomies();
$taxonomy_count = count($attribute_taxonomies);
?>
<div class="wrap ktmp-product-list ktmp-product-table">
  <h1><?php esc_html_e('Attribute Matching', 'keskintech-marketplaces'); ?></h1>
  <table id="ktmp-expand-table">
    <thead>
	   <tr>
          <th><?php esc_html_e( 'Taxonomy Name', 'keskintech-marketplaces' ); ?></th>
		  <th><?php esc_html_e( 'Expand', 'keskintech-marketplaces' ); ?></th>
		  <th><?php esc_html_e( 'Attribute Name', 'keskintech-marketplaces' ); ?></th>
<?php     foreach ($marketplaces as $marketplace) {
	        $percent_value = $KeskintechMarketplace->MarketplacesGetPercent($marketplace->marketplace_id,'term', false, $taxonomy_count);
            echo '<th>' . esc_html($marketplace->market_name) . ' (%' . esc_attr($percent_value) . ')';
            if($percent_value != NULL){
				echo ' <div class="ktmp-progress-container"><div class="ktmp-progress-bar" style="width: ' . esc_attr($percent_value) . '%;"></div>';	 
			}
			echo '</th>';        
		  } ?>
		  <th><?php esc_html_e('Match', 'keskintech-marketplaces'); ?></th>
       </tr>
	</thead>
	<tbody>
<?php  
       foreach ($attribute_taxonomies as $attribute) {
		  $taxonomy_slug = 'pa_' . $attribute->attribute_name;
		  $attribute_name = $attribute->attribute_name;
	      echo '<tr>';
		     echo '<td>'  . esc_html($attribute->attribute_label) . '</td>';
		     echo '<td><button class="ktmp-expand-button" data-toggle="' . esc_attr($attribute->attribute_id) . '">' . esc_html__('Expand', 'keskintech-marketplaces') . '</button></td><td></td>'; 
			 $defaultValues = $KeskintechMarketplace->GetMatchedTerms($taxonomy_slug, 'att_taxonomy');
			 foreach ($marketplaces as $marketplace){
				 $defaultValue = isset($defaultValues[$marketplace->marketplace_id]) ? $defaultValues[$marketplace->marketplace_id] : '';
				 echo '<td>'. esc_attr($defaultValue) .'</td>';
			 }
			 echo '<td><a href="?page=ktmp-matching-fields&edit=pa_' . esc_attr($attribute->attribute_name) . '&type=att-taxonomy">' . esc_html__('Match Taxonomy', 'keskintech-marketplaces') . '</a></td></tr>';
	      $terms = get_terms(array('taxonomy' => 'pa_' . $attribute_name, 'hide_empty' => false));
		  foreach ($terms as $term){
			  echo '<tr class="ktmp-sub-row" data-parent="' . intval($attribute->attribute_id) . '">';
			  echo '<td></td><td></td>';
			  echo '<td>' . esc_html($term->name) . '</td>';
			  $defaultValues = $KeskintechMarketplace->GetMatchedTerms($term->term_id, 'term');
			  foreach ($marketplaces as $marketplace){
			      $defaultValue = isset($defaultValues[$marketplace->marketplace_id]) ? $defaultValues[$marketplace->marketplace_id] : '';
                  echo '<td>'. esc_attr($defaultValue) .'</td>';
			  }
			  echo '<td><a href="?page=ktmp-matching-fields&edit=' . intval($term->term_id) . '">' . esc_html__('Match the term', 'keskintech-marketplaces') . '</a></td></tr>';
		  }
	   } ?>  	
	</tbody>
  </table>
</div>