<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Read template and update products.
 *
 * @param array $rows The JSON file data.
 * @param string $sku_columnname The name of the column selected as SKU.
 * @param integer $marketplace_id The id of the marketplace.
 * @param string $MatchedHeaderJSONName The name of matched header json.
 * @return array [string Updated file JSON path, array $NotInWebSite, array $NotInMarketplace, array $updated_array]
 */
function ktmp_update_products($rows, $sku_columnname, $marketplace_id, $MatchedHeaderJSONName, $templateForm) {
	$file_path = $templateForm ? 'matched-header/' : 'saved-templates/';
	$file_path = KTMP_UPLOADS_DIR . '/tmp/' . $file_path . $MatchedHeaderJSONName;
    $jsonData = file_get_contents($file_path );
    $MatchedHeader = json_decode($jsonData, true);
    $NotInMarketplace = [];
    $NotInWebSite = [];
    $MatchedSku = [];
    $updated_array = array();
    foreach ($rows as $index => $row) {
        $UpdatedRow = [];
        $sku = trim($sku_columnname);
        if ($row[$sku] == '') {
            continue;
        }
        $ProductID = wc_get_product_id_by_sku($row[$sku]);
        if ($ProductID) {
            $MatchedSku[] = $row[$sku];
            $product = wc_get_product($ProductID);
            foreach ($MatchedHeader as $key => $value) {
                if ($value !== '' && $value != 'sku') {
                    if ($product->is_type('simple') || $product->is_type('variable')) {
                        $UpdatedRow[$key] = ktmp_function_matching($product, $value, $marketplace_id);
                    } elseif ($product->is_type('variation')) {
                        $parent = wc_get_product($product->get_parent_id());
                        $UpdatedRow[$key] = ktmp_function_matching($parent, $value, $marketplace_id, $product);
                    }
					if($UpdatedRow[$key] === false){
						continue 2;
					}
                } else {
                    $UpdatedRow[$key] = $row[$key];
                }
            }
            $updated_array[] = $UpdatedRow;
        } else {
            $NotInWebSite[$index] = $row[$sku];
        }
    }
    if (empty($updated_array)) {
	  return false;
	} 
	else {
      $NotInMarketplace = ktmp_check_not_in_marketplace($MatchedSku);
    }
    return [ktmp_array_to_json('updated-file', $updated_array), $NotInWebSite, $NotInMarketplace, $updated_array];
}
function ktmp_check_not_in_marketplace($matchedSku) {
    $notInMarketplace = [];
	$args = array(
           'post_type'      => 'product',
           'posts_per_page' => -1,
		   'post_status'    => 'publish' 
         );
	$products_query = new WP_Query( $args );
	while ($products_query->have_posts()) {
      $products_query->the_post();
	  global $product;
      $product_type = $product->get_type();
      $product_id = $product->get_id();
	  if ($product_type === 'simple') {
	    if (!in_array($product->get_sku(), $matchedSku)) {
          $notInMarketplace[] = $product->get_name();
        }
	  }
	  elseif ($product_type === 'variable') { 
	    $variations = get_children(array(
          'post_parent' => $product_id,
          'post_type' => 'product_variation',
          'posts_per_page' => -1,
        ));
	    foreach ($variations as $variation) { 
	      $variation_id = $variation->ID;
		  $variation_sku = get_post_meta($variation_id, '_sku', true);
		  if (!in_array($variation_sku, $matchedSku)) {
            $notInMarketplace[] = get_the_title($variation_id);
          }
		}
	  }
	}
    return $notInMarketplace;
}