<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;
use Keskintech\KeskintechMarketplaces\KTMP_Send_Update_Handler;
use Keskintech\KeskintechMarketplaces\KTMP_Templates;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_start_process($process_type){
    $KeskintechPazaryeri = KTMP_Marketplace::get_instance();
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        if ($process_type === 'update') {
            $process_input = 'update';
            echo '<div class="ktmp-title"><h1>' . esc_html__( 'Update Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Update Your Products by Uploading.', 'keskintech-marketplaces' ) . '</span></h1></div>';
        } else {
            $process_input = 'send';
            echo '<div class="ktmp-title"><h1>' . esc_html__( 'Upload Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Send Products by Uploading Marketplace Template.', 'keskintech-marketplaces' ) . '</span></h1></div>';
        }

        $marketplaces = $KeskintechPazaryeri->getAllMarketplaces();

        if (!empty($marketplaces)) {
            ?>
            <div class="ktmp-centered">
                <form method="post" enctype="multipart/form-data" class="ktmp-main-form" action="">
				    <?php wp_nonce_field('ktmp_process_nonce'); ?>
                    <div class="ktmp-form-inner">
                        <label for="marketplace"><?php esc_html_e( 'Marketplace', 'keskintech-marketplaces' ); ?></label>
                        <select name="marketplace_id" id="marketplace">
                            <?php 
                            foreach ($marketplaces as $marketplace) {
                                echo '<option value="' . esc_attr($marketplace->marketplace_id) . '"> ' . esc_html($marketplace->market_name) . ' </option>'; 
                            }
                            ?>
                        </select>
                    </div>
                    <div class="ktmp-form-inner">
                        <label for="file"><?php esc_html_e( 'File', 'keskintech-marketplaces' ); ?></label>
                        <input type="file" name="file" id="file" accept=".xlsx, .csv, .xlsm" required>
                    </div>
                    <input type="hidden" name="process_type" value="<?php echo esc_attr($process_input); ?>">
                    <input type="submit" name="ktmp_start_process" value="<?php esc_html_e( 'Upload Data', 'keskintech-marketplaces' ); ?>">
                </form>
            
            <?php
        } else {
            ktmp_no_marketplace_warning();
        }

        if ($process_type === 'update' && !empty($marketplaces)) {
            $Template = new KTMP_Templates();
            $Template->ListTemplates();
			$Template->ktmp_template_enqueue_scripts();
        }
		echo '</div>';
    }
	else{
		$ktmp_send_update_handler = KTMP_Send_Update_Handler::get_instance();
		$ktmp_send_update_handler->handle_request();
	}
}
