<?php
use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;
use Keskintech\KeskintechMarketplaces\KTMP_MarketplaceProduct;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_send_products_table($marketplace_id, $MatchedHeaderJSONName,$SelectedSheetName = false){
	$cached_base_to_price = [];
	$ktmp_marketplace = KTMP_Marketplace::get_instance();
	$KeskintechMarketplacePricingRules = $ktmp_marketplace->GetPricingRules($marketplace_id);
	$MarketplaceProduct = new KTMP_MarketplaceProduct();
	$args = array(
             'post_type'      => 'product',
             'posts_per_page' => -1,
			 'post_status'    => 'publish' 
            );
	$products_query = new WP_Query( $args ); ?>
    <div class="wrap ktmp-product-list ktmp-product-table">
	  <h1 class="wp-heading-inline"><?php esc_html_e( 'Products', 'keskintech-marketplaces' ); ?></h1>
      <form action="" method="post" id="ktmp-price-type">
<?php   echo '<input type="hidden" name="marketplace_id" value="'. esc_attr($marketplace_id) .'">';
	    echo '<input type="hidden" name="process_type" value="yukleme">';
	    echo '<input type="hidden" name="MatchedHeaderJSONPath" value="'. esc_attr($MatchedHeaderJSONName) . '">';
        if($SelectedSheetName){
		  echo '<input type="hidden" name="SelectedSheetName" value="'. esc_attr($SelectedSheetName) . '">';
	    }
        wp_nonce_field('ktmp_process_nonce');
 		?>	  
        <button type="submit" id="keskintech-mother-buton" class="page-title-action" name="send_products"><?php esc_html_e('Send Selected Products', 'keskintech-marketplaces'); ?></button>
	    <button type="submit" id="ktmp-fixed-button" class="ktmp-fixed-button" name="send_products"><?php esc_html_e('Send Selected Products', 'keskintech-marketplaces'); ?></button>
        <table id="ktmp-expand-table">
          <thead>
            <tr id="ana-satir">
			    <th>ID</th>
				<th><?php esc_html_e( 'SKU', 'keskintech-marketplaces' ); ?></th>
                <th><?php esc_html_e( 'Select', 'keskintech-marketplaces' ); ?></th>
                <th><?php esc_html_e( 'Expand', 'keskintech-marketplaces' ); ?></th>
                <th><?php esc_html_e( 'Product', 'keskintech-marketplaces' ); ?></th>
                <th><?php esc_html_e( 'Current Site Price', 'keskintech-marketplaces' ); ?></th>
                <th><?php echo esc_html($ktmp_marketplace->getMarketplaceName($marketplace_id)); ?></th>
            </tr>				
	      </thead>
		  <tbody>
<?php 	     while ($products_query->have_posts()) {
				$products_query->the_post();
				global $product;
                $product_type = $product->get_type();
                $product_id = $product->get_id();			
                if ($product_type === 'simple') { ?>
				   <tr id="ana-satir">
					    <td><?php echo esc_attr($product_id); ?></td>
						<td><?php echo esc_attr($product->get_sku()); ?></td>
                        <td> <input type="checkbox" name="product_id[]" value="<?php echo esc_attr($product_id); ?>"> </td>
                        <td></td>
						<td><?php echo esc_html($product->get_title()); ?> </td>
                        <td><?php echo esc_html($product->get_price()); ?> </td>
<?php                   $pricing_primary = $MarketplaceProduct->ProductPrimaryPrice($marketplace_id, $product_id);
                        if ($pricing_primary !== null) {
                              $price = [$pricing_primary, 'pricing-primary']; 
                        }
						else{
							 $ProductBaseValue = $MarketplaceProduct->ProductBaseValue($product_id, $marketplace_id);
							 if ($ProductBaseValue && !empty($KeskintechMarketplacePricingRules)) {
								 if (isset($cached_base_to_price[$ProductBaseValue])) {
                                        $price = [$cached_base_to_price[$ProductBaseValue], 'pricing-rule'];
                                 }
								 else {
                                        $PriceRuleTransactionResult = $MarketplaceProduct->PriceRuleTransactionResult($product_id, $marketplace_id, $ProductBaseValue, $KeskintechMarketplacePricingRules);
                                        if ($PriceRuleTransactionResult !== false) {
                                           $cached_base_to_price[$ProductBaseValue] = $PriceRuleTransactionResult;
                                           $price = [$PriceRuleTransactionResult, 'pricing-rule'];
                                        } else {
                                           $price = [get_post_meta($product_id, '_price', true), 'pricing-current-site'];
                                        }
                                 }
							 }
							 else{
								$price = [get_post_meta($product_id, '_price', true), 'pricing-current-site']; 
							 }
						}                       
					    echo '<td>' . esc_attr($price[0]) . ' <span class="'.esc_html($price[1]).'"></span></td></tr>';						
               } 
			   elseif ($product_type === 'variable') {	?>
                   <tr>
					    <td><?php echo intval($product_id); ?></td>
						<td><?php echo esc_html($product->get_sku()); ?></td>
                        <td> <input type="checkbox" data-toggle="<?php echo intval($product_id); ?>"> </td>
                        <td> <button class="ktmp-expand-button" data-toggle="<?php echo intval($product_id); ?>"><?php esc_html_e( 'Expand', 'keskintech-marketplaces' ); ?></button></td>
                        <td> <?php echo esc_html($product->get_title()); ?></td>
                   </tr>
<?php              $variations = get_children(array(
                                                       'post_parent' => $product_id,
                                                       'post_type' => 'product_variation',
                                                       'posts_per_page' => -1,
                    ));
                    $marketplace_prices = [];
                    foreach ($variations as $variation) {
						$variation_id = $variation->ID;
                        if (!isset($marketplace_prices[$variation_id])) {
                              $pricing_primary = $MarketplaceProduct->ProductPrimaryPrice($marketplace_id, $variation_id);
                              if ($pricing_primary !== null) {
                                 $marketplace_prices[$variation_id] = [$pricing_primary, 'pricing-primary']; 
                              } else {
                                 $ProductBaseValue = $MarketplaceProduct->ProductBaseValue($variation_id, $marketplace_id);
                                 if ($ProductBaseValue && !empty($KeskintechMarketplacePricingRules)) {
                                     if (isset($cached_base_to_price[$ProductBaseValue])) {
                                        $marketplace_prices[$variation_id] = [$cached_base_to_price[$ProductBaseValue], 'pricing-rule'];
                                     } else {
                                        $PriceRuleTransactionResult = $MarketplaceProduct->PriceRuleTransactionResult($variation_id, $marketplace_id, $ProductBaseValue, $KeskintechMarketplacePricingRules);
                                        if ($PriceRuleTransactionResult !== false) {
                                           $cached_base_to_price[$ProductBaseValue] = $PriceRuleTransactionResult;
                                           $marketplace_prices[$variation_id] = [$PriceRuleTransactionResult, 'pricing-rule'];
                                        } else {
                                           $marketplace_prices[$variation_id] = [get_post_meta($variation_id, '_price', true), 'pricing-current-site'];
                                        }
                                     }
                                  } else {
                                     $marketplace_prices[$variation_id] = [get_post_meta($variation_id, '_price', true), 'pricing-current-site'];
                                    }
                              }                           
                        }
                    } 
					foreach ($variations as $variation) {
						$variation_id = $variation->ID;
						$variation_obj = new WC_Product_Variation($variation_id);
                        $display_price = $variation_obj->get_price();
                        echo '<tr class="ktmp-sub-row" data-parent="' . esc_attr($product_id) . '">';
						echo '<td>' . esc_html($variation_id) . '</td>';
						echo '<td>' . esc_html(get_post_meta($variation_id, '_sku', true)) . '</td>';
                        echo '<td></td>';
						echo '<td><input type="checkbox" name="product_id[]" value="' . esc_attr($variation_id) . '" data-parent="' . esc_attr($product_id) . '"></td>';
                        echo '<td>';
                        $variation_attributes = $variation_obj->get_attributes();
						$values = array_filter($variation_attributes, function($value, $key) {
                            return $value !== '' && $value !== null && $key !== '' && $key !== null;
                        }, ARRAY_FILTER_USE_BOTH);
                        echo implode(', ', array_map('esc_html', array_values($values)));
                        echo '</td>';
                        echo '<td>' . esc_html($display_price) . '</td>';
                        $price = $marketplace_prices[$variation_id];
					    echo '<td>' . esc_html($price[0]) . ' <span class="'. esc_attr($price[1]) .'"></span></td>';
                        echo '</tr>';	
					}
			   }
			 }
			 wp_reset_postdata(); ?>
	      </tbody>
        </table>
      </form>
	</div>
<?php 
    wp_localize_script('ktmp-admin-script', 'ktmpCSSData', array(
        'pricing_primary' => esc_html__('You have set this price for this product yourself.', 'keskintech-marketplaces'),
        'pricing_rule' => esc_html__('Marketplace price rules applied.', 'keskintech-marketplaces'),
        'current_site' => esc_html__('Current site price applied.', 'keskintech-marketplaces'),
    ));
}	
function ktmp_send_selected_products($marketplace_id, $product_ids,$MatchedHeaderJSONName){
	$file_path = KTMP_UPLOADS_DIR . '/tmp/matched-header/' . $MatchedHeaderJSONName;
	$jsonData = file_get_contents($file_path);
    $matched_header_array = json_decode($jsonData, true);
	$array_to_write = array();
	foreach($product_ids as $product_id){
		$product = wc_get_product($product_id);
        $line = array();
		if ($product->is_type('simple')) {
            foreach ($matched_header_array as $key => $value) {
			  $input = ktmp_function_matching($product, $value, $marketplace_id);
			  if($input === false){
			      continue 2;
			  }
			  $line[$key] = $input;
			}
			$array_to_write[] = $line;
		
	    } elseif ($product->is_type('variation')) {
		    $parent = wc_get_product($product->get_parent_id());
            foreach ($matched_header_array as $key => $value) {
			  $input = ktmp_function_matching($parent, $value, $marketplace_id, $product);
			  if($input === false){
				 continue 2;	  
			  }
			  $line[$key] = $input;
			}
            $array_to_write[] = $line;
		}
	 }
	 $ReadyToWriteName = ktmp_array_to_json('ready-to-write', $array_to_write);
	 return [$ReadyToWriteName,$array_to_write];
}
function ktmp_send_by_category($marketplace_id, $category_id, $MatchedHeaderJSONName, $FilterAttribute){
	$file_path = KTMP_UPLOADS_DIR . '/tmp/matched-header/' . $MatchedHeaderJSONName;
	$jsonData = file_get_contents($file_path);
    $matched_header_array = json_decode($jsonData, true);
	$args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
		'post_status' => 'publish',
      );
     if ($category_id != 0) {
        $args['tax_query'] = array(
        array(
            'taxonomy' => 'product_cat',
            'field'    => 'id',
            'terms'    => $category_id,
        ),
        );
     }
	 if($FilterAttribute !== NULL && $FilterAttribute !== ''){
		 $term = ":term:";
		 $splitText = explode($term, $FilterAttribute);
		 $attribute_name = $splitText[0];
         $attribute_value = $splitText[1];
		 $args['tax_query'][] = array(
           'taxonomy' => 'pa_' .$attribute_name,
           'field'    => 'slug',
           'terms'    => $attribute_value,
         );
	 }
	 $query = new WP_Query($args);
	 $array_to_write = array();
	 while ($query->have_posts()) {
		 $query->the_post();
		 $product = wc_get_product(get_the_ID());
		 $line = array();
		 if ($product->is_type('simple')) {
	       foreach ($matched_header_array as $key => $value) {
			  $input = ktmp_function_matching($product, $value, $marketplace_id);
			  if($input === false){
			      continue 2;
			  }
			  $line[$key] = $input;
		   }
	       $array_to_write[] = $line;
	    }
		elseif ($product->is_type('variable')) {
	    $variations = $product->get_available_variations('object');
	         foreach ($variations as $variation) {
		        foreach ($matched_header_array as $key => $value) {
			         $input = ktmp_function_matching($product, $value, $marketplace_id, $variation);
			         if($input === false){
			           continue 2;
			         }
					 $line[$key] = $input;
		        }
		     $array_to_write[] = $line;
		     }
        }
	 }
	 wp_reset_postdata();
	 $ReadyToWriteName = ktmp_array_to_json('ready-to-write', $array_to_write);
	 return [$ReadyToWriteName,$array_to_write];
}
function ktmp_display_product_attributes_selectbox() {
    $attributes = wc_get_attribute_taxonomies();
    echo '<select id="product_attributes_select" name="product_attributes_select">';
    echo '<option value="">' . esc_html__( 'All Attributes', 'keskintech-marketplaces' ) . '</option>';
    foreach ($attributes as $attribute) {
        $attribute_name = $attribute->attribute_name;
        $attribute_label = wc_attribute_label($attribute_name);
        echo '<optgroup label="' . esc_attr($attribute_label) . '">';
        $terms = get_terms(array(
            'taxonomy' => 'pa_' . $attribute_name,
            'hide_empty' => true,
        ));
        foreach ($terms as $term) {
            echo '<option value="' . esc_attr($attribute_label) . ':term:' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';
        }
        echo '</optgroup>';
    }
    echo '</select>';
}