<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;

if ( ! defined( 'ABSPATH' ) ) exit;
$KeskintechMarketplace = KTMP_Marketplace::get_instance();
if (isset($_GET['action']) && $_GET['action'] == 'edit') {
    $edit = true;
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'edit_marketplace' ) ) {
			if($_POST['market_name'] !== ''){
				$marketplace_id = intval($_POST['marketplace_id']);
                $market_name = sanitize_text_field($_POST['market_name']);
                $edit_marketplace = $KeskintechMarketplace->MarketplaceEdit($market_name, $marketplace_id);
			    if($edit_marketplace){
					echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'The marketplace has been successfully updated', 'keskintech-marketplaces' ) . '</p></div>';
                    $edit = false;
				}
			    else{
				   echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'The marketplace could not be modified. Data could not be added to the database table.', 'keskintech-marketplaces' ) . '</p></div>';
			    }
			}
			else{
				   echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'Please enter a marketplace name.', 'keskintech-marketplaces' ) . '</p></div>';
			}
        }
    }
    if (isset($_GET['id']) && $edit) {
        $marketplace_id = intval($_GET['id']);
        $market = $KeskintechMarketplace->getSelectedMarketplace($marketplace_id);
		if($market !== NULL) {
        ?>
        <div class="wrap">
            <h2><?php echo esc_html_e( 'Edit Marketplace', 'keskintech-marketplaces' ) ?></h2>
            <form method="post" action="">
                <?php wp_nonce_field('edit_marketplace'); ?>
                <input type="hidden" name="marketplace_id" value="<?php echo esc_attr($market['marketplace_id']); ?>">
                <label for="market_name"><?php esc_html_e( 'Marketplace Name:', 'keskintech-marketplaces' ) ?></label>
                <input type="text" name="market_name" value="<?php echo esc_attr($market['market_name']); ?>" required>
                <input type="submit" class="button button-primary" value="<?php esc_html_e( 'Update', 'keskintech-marketplaces' ) ?>">
            </form>
        </div>
        <?php
		}
		else {echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'No marketplace found.', 'keskintech-marketplaces' ) . '</p></div>';}
    }
} elseif (isset($_GET['action']) && $_GET['action'] == 'delete') {
    if ( isset( $_GET['id'] ) && isset( $_GET['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'delete_marketplace' ) ) {
        $marketplace_id = intval($_GET['id']);
        $delete_marketplace = $KeskintechMarketplace->MarketplaceDelete($marketplace_id);
		if($delete_marketplace){
			echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Marketplace successfully deleted!', 'keskintech-marketplaces' ) . '</p></div>';
		}
		else{
			echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'Marketplace could not be deleted.', 'keskintech-marketplaces' ) . '</p></div>';
		}
        
    }
} elseif (isset($_GET['action']) && $_GET['action'] == 'add') {
	$added = false;
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_marketplace'])) {
        if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'add_marketplace' ) ) {
		  if($_POST['market_name'] !== ''){
            $market_name = sanitize_text_field($_POST['market_name']);
			$add_marketplace = $KeskintechMarketplace->MarketplaceAdd($market_name);
		    if($add_marketplace){
				echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Marketplace successfully added!', 'keskintech-marketplaces' ) . '</p></div>';
			    $added = true;	
			}
			else{
				echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'An error occurred. Marketplace could not be added to the database.', 'keskintech-marketplaces' ) . '</p></div>';
			}
		  }
		  else {
		     echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'Please enter a marketplace name.', 'keskintech-marketplaces' ) . '</p></div>';
	      }
      }
    }
	if(!$added){
	   ?>
       <div class="wrap">
          <?php echo '<h2>' . esc_html__( 'Add Marketplace', 'keskintech-marketplaces' ) . '</h2>'; ?>
          <form method="post" action="">
            <?php wp_nonce_field('add_marketplace'); ?>
			<label for="market_name"><?php esc_html_e( 'Marketplace Name:', 'keskintech-marketplaces' ); ?></label>
            <input type="text" name="market_name" required>
            <input type="submit" name ="add_marketplace" class="button button-primary" value="<?php esc_html_e( 'Add', 'keskintech-marketplaces' ); ?>">
           </form>
        </div>
    <?php
	}
}
$marketplaces = $KeskintechMarketplace->getAllMarketplaces();
?>
<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e( 'Marketplace Operations', 'keskintech-marketplaces' ); ?></h1>
    <a href="?page=ktmp-marketplaces&action=add" class="page-title-action"><?php esc_html_e( 'Add Marketplace', 'keskintech-marketplaces' ); ?></a>
    <table class="wp-list-table widefat fixed striped marketplace-table">
        <thead>
            <tr>
                <th>ID</th>
                <th><?php esc_html_e( 'Name', 'keskintech-marketplaces' ); ?></th>
                <th><?php esc_html_e( 'Edit / Delete', 'keskintech-marketplaces' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($marketplaces as $marketplace) : ?>
                <tr>
                    <td><?php echo esc_html($marketplace->marketplace_id); ?></td>
                    <td><?php echo esc_html($marketplace->market_name); ?></td>
                    <td>
                        <a href="?page=ktmp-marketplaces&action=edit&id=<?php echo esc_attr($marketplace->marketplace_id); ?>"><?php esc_html_e( 'Edit', 'keskintech-marketplaces' ); ?></a> |
                        <a href="?page=ktmp-marketplaces&action=delete&id=<?php echo esc_attr($marketplace->marketplace_id); ?>&_wpnonce=<?php echo esc_attr(wp_create_nonce('delete_marketplace')); ?>" onclick="return confirm('<?php esc_html_e( 'All matching and prices associated with the marketplace will be deleted. Are you sure you want to delete this marketplace?', 'keskintech-marketplaces' ); ?>');"><?php esc_html_e( 'Delete', 'keskintech-marketplaces' ); ?></a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>