<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;
use Keskintech\KeskintechMarketplaces\KTMP_MarketplaceProduct;
use Keskintech\KeskintechMarketplaces\Lib\KTMP_XLSXWriter;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_CSVFindSeperator($first_row) {
    $comma_values = explode(',', $first_row);
    $semicolon_values = explode(';', $first_row);
    $tab_values = explode("\t", $first_row);
    if (count($comma_values) > count($semicolon_values) && count($comma_values) > count($tab_values)) {
        $separator = ',';
    } elseif (count($semicolon_values) > count($comma_values) && count($semicolon_values) > count($tab_values)) {
        $separator = ';';
    } elseif (count($tab_values) > count($comma_values) && count($tab_values) > count($semicolon_values)) {
        $separator = "\t";
    }
    return $separator;
}
function ktmp_CSVtoTable($file_path){
    $csv_data = file($file_path);
    echo '<table border="1">';
    echo '<tr>';
	$comma = ktmp_CSVFindSeperator($csv_data[0]);
	$header = explode($comma, mb_convert_encoding($csv_data[0], 'UTF-8', 'ISO-8859-9, ISO-8859-1, ASCII, UTF-8'));
    foreach ($header as $index=> $cell) {
        echo '<th>' . esc_html($cell) . '</th>';
    }
    echo '</tr>';
    for ($i = 1; $i < count($csv_data); $i++) {
        $columns = explode($comma, mb_convert_encoding($csv_data[$i], 'UTF-8', 'ISO-8859-9, ISO-8859-1, ASCII, UTF-8'));
        echo '<tr>';
        foreach ($columns as $cell) {
            if (is_numeric($cell) && strpos($cell, 'E') !== false) {
                $cell = number_format((float)$cell, 0, '.', '');
            }
            echo '<td>' . esc_html($cell) . '</td>';
        }
        echo '</tr>';
    }
    echo '</table>';
}
function ktmp_XlsxGetSheet($filename, $tablo=false) {
	$sheet_names = ktmp_xlsx_to_array($filename,-1);
	if(empty($sheet_names)){
		$error_message = __( 'The sheet was not found in the file.', 'keskintech-marketplaces' );
		ktmp_log($error_message, 607);
		wp_die( esc_html( $error_message ) );
	}
	$selectedSheet = isset($_POST['selectedSheet']) ? intval($_POST['selectedSheet']) : 0;
	if($tablo){
		$array = ktmp_xlsx_to_array($filename,$selectedSheet);
		$headervaluesjsonpath = ktmp_array_to_header_values_path($array);
	}	?>
	<h2 class="ktmp-sub-heading"><?php esc_html_e( 'Select the Page Where the Product List Is', 'keskintech-marketplaces' ); ?></h2>
        <form action="" method="post" style="margin-bottom:15px" class="ktmp-mini-form">
		    <?php wp_nonce_field('ktmp_process_nonce'); ?>
            <label for="sheetSelect"><?php esc_html_e( 'Select Sheet:', 'keskintech-marketplaces' ); ?></label>
            <select id="sheetSelect" name="selectedSheet">
               <?php foreach ($sheet_names as $index => $sheet_name) : ?>
                    <option value="<?php echo esc_attr($index); ?>" <?php selected($index, $selectedSheet); ?>>
                       <?php echo esc_html($sheet_name); ?>
                    </option>
        <?php endforeach; ?>
            </select>
			<?php if($tablo){echo '<input type="hidden" name="headervaluesjsonpath" value="'. esc_attr($headervaluesjsonpath) .'">';}?>
			<input type="hidden" name="filename" value="<?php echo esc_attr($filename); ?>">
			<input type="hidden" name="marketplace_id" value="<?php echo intval($_POST['marketplace_id']); ?>">
            <input type="hidden" name="process_type" value="<?php echo esc_attr(sanitize_text_field($_POST['process_type'])); ?>">
			<?php 
			  foreach ($sheet_names as $index=>$sheet_name){
				  echo '<input type="hidden" name="SheetName'. esc_attr($index) .'" value="' . esc_html($sheet_name) . '">';
			  }
			
			?>
           <input type="submit" name="ktmp_XlsxGetSheet" value="<?php esc_html_e( 'Submit', 'keskintech-marketplaces' ); ?>" class="ktmp-save">
        </form>
    <?php
	if($tablo){
	 ktmp_array_to_table($array);
	}
}
function ktmp_download_file_form($SelectedSheetName, $marketplace_id, $ReadyToWritePath){ ?>
  <form action="" method="post">
        <label for="filetype"><?php esc_html_e( 'Select a file type:', 'keskintech-marketplaces' ); ?></label>
        <select name="filetype" id="filetype">
            <option value="xlsx"><?php esc_html_e( 'Excel File (XLSX)', 'keskintech-marketplaces' ); ?></option>
            <option value="csv"><?php esc_html_e( 'CSV File', 'keskintech-marketplaces' ); ?></option>
        </select>
		<?php
		$folder = isset($_POST['send-column-update']) ? 'updated-file/' : 'ready-to-write/';		
		wp_nonce_field('ktmp_process_nonce');
		echo '<input type="hidden" name="SelectedSheetName" value="' . esc_html($SelectedSheetName) . '">'; ?>
		<input type="hidden" name="folder" value ="<?php echo esc_attr($folder) ;?>">
        <input type="hidden" name="marketplace_id" value ="<?php echo esc_attr($marketplace_id) ;?>">
		<input type="submit" name="start_download" value="<?php esc_html_e( 'Download File', 'keskintech-marketplaces' ); ?>" class="ktmp-green-button">
	   <input type="hidden" name='ReadyToWritePath' value = "<?php echo esc_attr($ReadyToWritePath);?>">
	</form> 
<?php	
}
function ktmp_matched_column_array($headervaluesjsonname, $GetSKUColumnName = NULL){
	$file_path = KTMP_UPLOADS_DIR . '/tmp/header-values/' . $headervaluesjsonname;
	$jsonData = file_get_contents($file_path);
    $header_values = json_decode($jsonData, true);
	$inputValues = array();
    foreach ($header_values as $index => $columnName) {
        $columnID = 'Column' . ($index + 1);
        if (isset($_POST[$columnID])) {
            $inputValues[$columnName] = sanitize_text_field($_POST[$columnID]);
			if($GetSKUColumnName){
				if($_POST[$columnID] == 'sku'){
				  $SKUColumnName = $columnName;
			    }
			}
        }
    }
	$MatchedHeaderJSONName = ktmp_array_to_json('matched-header', $inputValues);
	if($GetSKUColumnName){
		return array($MatchedHeaderJSONName,$SKUColumnName);
	}
	else{
	   return $MatchedHeaderJSONName;
	}
}
function ktmp_column_matching_process($process_type, $headervaluesjsonname, $uploadedfilejson, $SelectedSheetName = NULL) {
	if ($process_type == 'update') {
		echo '<div class="ktmp-title"><h1>' . esc_html__( 'Update Products', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Match the relevant columns by dragging them.', 'keskintech-marketplaces' ) . '</span></h1></div>';
        echo '<div class="ktmp-warning-box ktmp-orange-alert">' .
        '<span>' . esc_html__( 'Leave empty the columns you do not want to change.', 'keskintech-marketplaces' ) . '<br>' . esc_html__( 'Manually fill in if you want to enter fixed content.', 'keskintech-marketplaces' ) . '</span>' .
     '</div>';
    }
	else{
		echo '<div class="ktmp-title"><h1>' . esc_html__( 'Submit Products', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Match the relevant columns by dragging them.', 'keskintech-marketplaces' ) . '</span></h1></div>';
		echo '<div class="ktmp-warning-box ktmp-orange-alert"> <span>' . esc_html__( 'If you want to enter a constant value, type it manually', 'keskintech-marketplaces' ) . '</span>' . '</div>';
    }
	$file_path = KTMP_UPLOADS_DIR . '/tmp/header-values/' . $headervaluesjsonname;
	$jsonData = file_get_contents($file_path);
    $header_values = json_decode($jsonData, true);
    echo '<div class="ktmp-edit-column"><form id="sutunForm" action="" method="post" onsubmit="return validateAndSubmit()" style="margin-bottom:35px">';
	echo '<table><tr>';
	foreach ($header_values as $header_value){
		echo '<th>' . esc_html($header_value) . '</th>';
	}
	echo '</tr><tr>';
	foreach ($header_values as $index => $columnName) {
        $columnID = 'Column' . ($index + 1);
        $labelID = 'label' . $columnID;
        $inputID = $columnID . '-value';
        echo '<td class="ktmp-input-container" id="' . esc_attr($columnID) . '" ondrop="ktmDrop(event)" ondragover="ktmDragOver(event)">
             <label for="' . esc_attr($inputID) . '" id="' . esc_attr($labelID) . '" data-default="'.esc_attr($columnName).'">' . esc_html($columnName) . '</label><br>
             <input type="text" class="input" id="' . esc_attr($inputID) . '" name="' . esc_attr($columnID) . '" placeholder="' . esc_html($columnName) . '">
             <span class="ktmp-clear-icon" style="display:none" onclick="ktmClearInput(\'' . esc_attr($columnID) . '\')">✖</span>
             </td>';
    }
	echo '</tr></table>';
	wp_nonce_field('ktmp_process_nonce');
	echo '<input type="hidden" name="headervaluesjsonpath" value="' . esc_attr($headervaluesjsonname) . '">';
    echo '<input type="hidden" name="marketplace_id" value="' . intval($_POST['marketplace_id']) . '">';
	echo '<input type="hidden" name="SelectedSheetName" value="' . ($SelectedSheetName !== NULL && $SelectedSheetName !== '' ? esc_html($SelectedSheetName) : 'Your Products') . '">';
	if($process_type == 'update'){
		echo '<input type="hidden" name="filepath" value="' . esc_attr($uploadedfilejson) . '">';
        echo '<div><button type="submit" style="clear:both;" name="send-column-update" value="default" class="ktmp-column-button ktmp-green-button">' . esc_html__( 'Submit', 'keskintech-marketplaces' ) . '</button></div>';
	}
	if($process_type == 'send'){echo '<div><button type="submit" style="clear:both;" name="send_column_upload" class="ktmp-column-button ktmp-green-button">' . esc_html__( 'Submit', 'keskintech-marketplaces' ) . '</button></div>';}
    echo '</form></div>';
    $woocommerce_attributes = wc_get_attribute_taxonomies();
    ?>
	<div class="ktmp-draggable-items">
    <div class="container">
        <div class="ktmp-item-container">
		    <div class="item" id="sku" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'SKU', 'keskintech-marketplaces' ); ?></div>
			<div class="item" id="model-code" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Main Product SKU(For Variations)', 'keskintech-marketplaces' ); ?></div>
			<div class="item" id="group-code" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Variation Group Code', 'keskintech-marketplaces' ); ?></div>
		    <div class="item" id="product-name" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Name', 'keskintech-marketplaces' ); ?></div>
			<div class="item" id="description" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Description', 'keskintech-marketplaces' ); ?></div>
			<div class="item" id="short-description" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Short Description', 'keskintech-marketplaces' ); ?></div>
            <div class="item" id="attributes" draggable="true" ondragstart="ktmDragStart(event)">
                <label for="select-item"><?php esc_html_e( 'Attributes', 'keskintech-marketplaces' ); ?></label>
                <select id="select-item" class="item-select" onchange="selectChange('attributes')">
                    <?php foreach ($woocommerce_attributes as $attribute) {
                        echo '<option value="' . esc_attr($attribute->attribute_id) . '">' . esc_html($attribute->attribute_label) . '</option>';
                    } ?>
                </select>
            </div>
			<div class="item" id="price" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Price', 'keskintech-marketplaces' ); ?></div>
            <div class="item" id="stock-quantity" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Stock Quantity', 'keskintech-marketplaces' ); ?></div>
            <div class="item" id="brand" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Brand', 'keskintech-marketplaces' ); ?></div>
			<div class="item" id="featured-product-image" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>1</div>
            <div class="item" id="product-image1" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>2</div>
            <div class="item" id="product-image2" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>3</div>
            <div class="item" id="product-image3" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>4</div>
            <div class="item" id="product-image4" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>5</div>
            <div class="item" id="product-image5" draggable="true" ondragstart="ktmDragStart(event)"><?php esc_html_e( 'Product Image ', 'keskintech-marketplaces' ); ?>6</div>
        </div>
    </div>
	</div>	
<?php 
   wp_localize_script('ktmp-admin-script', 'ktmp_validateandsubmit', array(
        'process_type' => $process_type,
        'warning_message' => esc_html__("At least one input value must be sku!", "keskintech-marketplaces"),
        'one_sku_warning' => esc_html__('When updating products, you may only enter one SKU value to match the SKUs.', 'keskintech-marketplaces')
    ));
}
function ktmp_array_to_table($array){
	if (empty($array)) {
        echo '<div class="ktmp-warning-box">' . esc_html__('No data available to display. Please check the error log under Marketplaces -> Settings -> Logs.', 'keskintech-marketplaces') . '</div>';
        return;
	}
	echo '<table border="1">';
    echo '<tr>';
	foreach ($array[0] as $key => $value) {
          echo '<th>' . esc_attr($key) . '</th>';
    }
	echo '</tr>';
	foreach ($array as $row) {
       echo '<tr>';
       foreach ($row as $cell) {
          echo '<td>' . esc_attr($cell) . '</td>';
    }
    echo '</tr>';
   }
   echo '</table>';
}
function ktmp_function_matching($product, $slug, $marketplace_id, $variation = NULL){
	$bos_deger = '';
	$bos_int = 0;
	$parent_product_id = $product->get_id();
	if($variation == NULL){
		$product_id = $parent_product_id;
	}
	else{
		$product_id = $variation->get_id();
	}
	$product_title = get_the_title($product_id);
	if (strpos($slug, "product-image") === 0) {
			$number = substr($slug, strlen("product-image"));
			if($variation !== NULL){
				$marketplace_image = ktmp_marketplace_images(0, $product_id, $number, false);				
			    return $marketplace_image;
			}
			else{
				$marketplace_image = ktmp_marketplace_images($product, $product_id, $number);
				return $marketplace_image;
			}
	}
	elseif (strpos($slug, "attributes") === 0) {
		$KeskintechMarketplace = KTMP_Marketplace::get_instance();
		$attribute_id = substr($slug, strlen("attributes"));
		$attribute_taxonomies = wc_get_attribute_taxonomies();
		$taxonomy_key = 'id:' . $attribute_id;
		if(!isset($attribute_taxonomies[$taxonomy_key])){
			$error_message = __( 'The selected taxonomy is not available in WooCommerce.', 'keskintech-marketplaces' );
			ktmp_log($error_message, 607);
			wp_die( esc_html( $error_message ) );
		}
		$taxonomy = $attribute_taxonomies[$taxonomy_key]->attribute_name;
		$attribute_key = 'pa_' . $taxonomy;
        $parent_product_att = $product->get_attributes();
        if($variation == NULL){
			return isset($parent_product_att[$attribute_key]['options'][0]) ? $KeskintechMarketplace->MatchedOrDefaultTermName($parent_product_att[$attribute_key]['options'][0], $marketplace_id, 'term') : '';
		}
		else {
			$variation_attributes = $variation->get_attributes();
			if (isset($variation_attributes[$attribute_key])) {
				$term = get_term_by('slug', $variation_attributes[$attribute_key], $attribute_key);
				return ($term && !is_wp_error($term)) ? $KeskintechMarketplace->MatchedOrDefaultTermName($term->term_id, $marketplace_id, 'term') : '';
            }
			else {
                $non_variation_att = array_map(function($attribute) {
                if (empty($attribute->get_variation())) {
                   return $attribute->get_options()[0];
                }
                }, array_filter($parent_product_att, function($attribute) {
                return empty($attribute->get_variation());
                }));
				return array_key_exists($attribute_key, $non_variation_att) ? $KeskintechMarketplace->MatchedOrDefaultTermName($non_variation_att[$attribute_key], $marketplace_id, 'term') : '';
            }
		}
	}
	elseif ($slug == 'sku') {
			$sku = get_post_meta($product_id, '_sku', true);
			if(!$sku){
				$error_message = sprintf(
                     __( 'SKU not found for the product "%s", so it could not be sent.', 'keskintech-marketplaces' ), $product_title
                );
				ktmp_log($error_message, 601);
                return false;	
			}
			return $sku;
    }
	elseif ($slug == 'group-code') {
		    return is_null($variation) ? '' : get_post_meta($product_id, 'ktmp_variation_group_code', true);
    }
	elseif ($slug == 'model-code') {
            $sku = get_post_meta($parent_product_id, '_sku', true);
            return $sku;
    }
	elseif ($slug == 'price') {
		    $MarketplaceProduct = new KTMP_MarketplaceProduct();
			$price = $MarketplaceProduct->ProductMarketplacePrice($marketplace_id, $product_id);
			if($price[0] == ''){
				$error_message = sprintf(
                     __( 'Price not found for the product "%s", so it could not be sent.', 'keskintech-marketplaces' ), $product_title
                );
				ktmp_log($error_message, 608);
                return false;
			}
			return $price[0];
    }
    elseif ($slug == 'product-name') {
			return $product->get_name();
    }
	elseif ($slug == 'description') {
			$product_description = get_post_field('post_content', $parent_product_id);
			$clean_product_description = strip_tags($product_description);
            $clean_product_description = str_replace(array("&#13;", "\r\n", "\r", "\n"), " ", $clean_product_description);
            return $clean_product_description;
    }
	elseif ($slug == 'short-description') {
            $product_excerpt = get_post_field('post_excerpt', $parent_product_id);
            $clean_product_excerpt = strip_tags($product_excerpt);
            $clean_product_excerpt = str_replace(array("&#13;", "\r\n", "\r", "\n"), " ", $clean_product_excerpt);
            return $clean_product_excerpt;
    }
    elseif ($slug == 'brand') {
			return ktmp_product_brand($parent_product_id, $marketplace_id);
    }
	elseif ($slug == 'stock-quantity') {
			if($variation == NULL){
				$stock_quantity = $product->get_stock_quantity();
				$stock_status = $product->get_stock_status();
			}
			else{
			    $stock_quantity = $variation->get_stock_quantity();
				$stock_status = $variation->get_stock_status();
			}
			if($stock_quantity){
			   return $stock_quantity;
			}
			else{
			   if($stock_status == 'instock'){
				 $in_stock_value = get_option('ktmp_in_stock_value');
                 if (!empty($in_stock_value)){
					return $in_stock_value;
				 }
                 else {
					$error_message = sprintf(
                        __( 'Please set a default value for "instock" in WP Admin -> Marketplaces -> Settings. "%s" could not be sent.', 'keskintech-marketplaces' ), $product_title
                    );
				    ktmp_log($error_message, 609);
                    return false;
				 } 				 
			   }
			   return 0;
			}
	}
	elseif ($slug == 'featured-product-image') {
		    if($variation == NULL){
     		   $one_cikan = ktmp_marketplace_images($product, $product_id, 0); 
			}
			else{
				$one_cikan = ktmp_marketplace_images(0, $product_id, 0, false);
			}
			return $one_cikan;
		}
	elseif (!isset($slug)) {
			return '';
    }
	else{
		return $slug;
	}
}
function ktmp_export_as_csv($marketplace_id, $ReadyToWriteName) {
	$file_path = KTMP_UPLOADS_DIR . '/tmp/' . $ReadyToWriteName;
    ob_clean();
    $jsonData = file_get_contents($file_path);
    $array_to_write = json_decode($jsonData, true);
    $KeskintechMarketplace = KTMP_Marketplace::get_instance();
    $marketplace_name = $KeskintechMarketplace->getMarketplaceName($marketplace_id);
    $current_time = current_time('Y-m-d-H-i');
    $fileLocation = $marketplace_name . '-' . $current_time . '.csv';
    $fp = fopen('php://output', 'w');
    fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
    $is_first_row = true;
    foreach ($array_to_write as $row) {
        if ($is_first_row) {
            $headersArray = array_keys($row);
            fputcsv($fp, $headersArray, ';');
            $is_first_row = false;
        }
        fputcsv($fp, $row, ';');
    }
    fclose($fp);
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=' . $fileLocation);
    ob_end_flush();
    exit();
}
function ktmp_export_as_xlsx($marketplace_id,$folder_file, $SelectedSheetName) {
	$file_path = KTMP_UPLOADS_DIR . '/tmp/' . $folder_file;
	$jsonData = file_get_contents($file_path);
    $json_array = json_decode($jsonData, true);
	ob_clean(); 
    ob_start();
	$KeskintechPazaryeri = KTMP_Marketplace::get_instance();
	$marketplace_name = $KeskintechPazaryeri->getMarketplaceName($marketplace_id);
	$current_time = current_time('Y-m-d-H-i');
    $fileLocation = $marketplace_name . '-' . $current_time . '.xlsx';
	
	$writer = new KTMP_XLSXWriter();
	$is_first_row = true;
    foreach ($json_array as $row) {
        if ($is_first_row) {
			$headersArray = array();
			foreach ($row as $key => $value) {
               if (!in_array($key, $headersArray)) {
                  $headersArray[] = $key;
			   }
			}
			$writer->writeSheetRow($SelectedSheetName, $headersArray);
            $is_first_row = false;
        }
        $writer->writeSheetRow($SelectedSheetName, $row);
    }
    $writer->writeToFile($fileLocation);
        header('Content-Description: File Transfer');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        header("Content-Disposition: attachment; filename=" . basename($fileLocation));
        header("Content-Transfer-Encoding: binary");
        header("Expires: 0");
        header("Pragma: public");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header('Content-Length: ' . filesize($fileLocation));
        ob_clean();
        flush();
        readfile($fileLocation);
        unlink($fileLocation);
        exit(); 
}
function ktmp_array_to_json($name, $data){
	$targetFolder = KTMP_UPLOADS_DIR . '/tmp/' . $name . '/';
	$randomName = uniqid($name, true);
	$jsonData = wp_json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
	$Fullfilepath = $targetFolder . $randomName . '.json';
	file_put_contents($Fullfilepath, $jsonData);
	$file_name = $randomName .'.json';
	return $file_name;
}
function ktmp_xlsx_to_array($file_name, $selectedSheet) {
	$file_path = KTMP_UPLOADS_DIR . '/tmp/' . $file_name;
    $xlsx = \Keskintech\KeskintechMarketplaces\Lib\KTMP_SimpleXLSX::parse($file_path);
    $array = array();
	if ($xlsx) {
		if($selectedSheet == -1){
		  $sheet_names = $xlsx->sheetNames();
		  return $sheet_names;
	    }
	    else{
		  $rows = $xlsx->rows($selectedSheet);
          $header_values = array_shift($rows);
          foreach ($rows as $row) {
            $combined_row = array_combine($header_values, $row);
            $array[] = $combined_row;
          }
		  if (empty($array)) {
                $empty_data = array_fill_keys($header_values, '');
                $array[] = $empty_data;
          }
		  return $array;
		}
	} else {
        esc_html_e( 'XLSX file could not be parsed.', 'keskintech-marketplaces' );
    }
}
function ktmp_csv_to_array($file_path) {
    if (($handle = fopen($file_path, "r")) !== false) {
        $first_row = fgets($handle);
        $separator = ktmp_CSVFindSeperator($first_row);
		fclose($handle);
        $array = array();
        if (($handle = fopen($file_path, "r")) !== false) {
            $header_values = fgetcsv($handle, 1000, $separator);
			$header_values = array_map(function($header) {
                return mb_convert_encoding($header, 'UTF-8', 'ISO-8859-9, ISO-8859-1, ASCII, UTF-8');
            }, $header_values);
            $header_values = array_map(function($header, $index) {
                static $counts = [];
                if (isset($counts[$header])) {
                    $counts[$header]++;
                    return $header . '_' . $counts[$header];
                } else {
                    $counts[$header] = 0;
                    return $header;
                }
            }, $header_values, array_keys($header_values));
            while (($data = fgetcsv($handle, 1000, $separator)) !== false) {
				$data = array_map(function($item) {
                    return mb_convert_encoding($item, 'UTF-8', 'ISO-8859-9, ISO-8859-1, ASCII, UTF-8');
                }, $data);
                $combined_row = array_combine($header_values, $data);
                $array[] = $combined_row;
            }
            fclose($handle);
            if (empty($array)) {
                $empty_data = array_fill_keys($header_values, '');
                $array[] = $empty_data;
            }
            return $array;
        } else {
            esc_html_e( 'CSV file could not be opened.', 'keskintech-marketplaces' );
            return false;
        }
    } else {
        echo esc_html_e( 'CSV file could not be opened.', 'keskintech-marketplaces' );
        return false;
    }
}
function ktmp_array_to_header_values_path($array){
	$HeaderValues = array_keys($array[0]);
	$HeaderValuesName = ktmp_array_to_json('header-values', $HeaderValues);
	return $HeaderValuesName;
}
function ktmp_HandleUpdateProducts($rows, $matchedColumnArray, $marketplaceId, $selectedSheetName = null, $templateForm = false) {
    $ktmp_update_products = ktmp_update_products($rows, $matchedColumnArray[1], $marketplaceId, $matchedColumnArray[0], $templateForm);
    if ($ktmp_update_products !== false) {
        $ReadyToWritePath = $ktmp_update_products[0];
        if ($templateForm) {
            ktmp_require_once_path('parts/marketplaces/update-product/saveastemplate.php');
            ktmp_save_as_template(sanitize_text_field($_POST['filepath']), $matchedColumnArray[1], $marketplaceId, $matchedColumnArray[0], sanitize_text_field($_POST['SelectedSheetName']));
        }
		ktmp_not_in_table($ktmp_update_products[1], $ktmp_update_products[2]);
        ktmp_download_file_form($selectedSheetName, $marketplaceId, $ReadyToWritePath);
        ktmp_array_to_table($ktmp_update_products[3]);
    } else {
        echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'No SKUs matched, please check the SKU column.', 'keskintech-marketplaces' ) . '</p></div>';
    }
}
function ktmp_not_in_table($NotInWebSite, $NotInMarketplace){
	echo '<div style="display: flex; justify-content: space-between; margin-bottom:20px;">';
    echo '<div style="text-align: center; flex-basis: 45%;">';
    echo '<h2>' . esc_html__( 'Products that do not exist on your site', 'keskintech-marketplaces' ) . '</h2>';
    echo '<div class="ktmp-max-height ktmp-not-in">';
	foreach ($NotInWebSite as $key => $value) {
        echo esc_html($value) . '<br>';
    }
	echo '</div></div>';
	echo '<div style="text-align: center;  flex-basis: 45%;">';
    echo '<h2>' . esc_html__( 'Products not available on Marketplace', 'keskintech-marketplaces' ) . '</h2>';
    echo '<div class="ktmp-max-height ktmp-not-in">';
	foreach ($NotInMarketplace as $key => $value) {
        echo esc_html($value) . '<br>';
    }
	echo '</div></div></div>';
}
