<?php
/*
Plugin Name: Keskintech Marketplaces
Description: Keskintech Marketplaces provides seamless integration with all online marketplaces. It supports reading and importing from xlsx, xlsm, and csv templates, as well as exporting product data, ensuring efficient synchronization with WooCommerce.
Version: 1.0
Author: Furkan Keskintaş
Author URI: https://keskintech.net
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: keskintech-marketplaces
Domain Path: /languages/
*/


/* Feratlar ve Rubutlar Giremez ! */
if ( ! defined( 'ABSPATH' ) ) exit;

require __DIR__ . '/vendor/autoload.php';

$scheduler = new \Keskintech\KeskintechMarketplaces\KTMP_Scheduler();

function ktmp_marketplaces_check_dependencies() {
    $required_wc_version = '6.3.1';
    if ( ! class_exists( 'WooCommerce' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        echo '<div class="notice notice-error"><p>' . esc_html__('For the Keskintech Marketplace Integration plugin to function, the WooCommerce plugin must be active. Please activate the WooCommerce plugin and try again.', 'keskintech-marketplaces') . '</p></div>';
        return;
    }
    if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, $required_wc_version, '<' ) ) {		
        deactivate_plugins( plugin_basename( __FILE__ ) );
        echo '<div class="notice notice-error"><p>' . esc_html__('The Keskintech Marketplace Integration plugin requires WooCommerce version %s or newer. Please update WooCommerce and try again.', 'keskintech-marketplaces') . '</p></div>';
        return;
    }
}
add_action( 'admin_init', 'ktmp_marketplaces_check_dependencies' );

if (!defined( 'KTMP_PLUGIN_DIR' ) ) {
    define( 'KTMP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if (!defined( 'KTMP_PLUGIN_URL' ) ) {
    define( 'KTMP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if (!defined('KTMP_UPLOADS_DIR')) {
    $uploadDir = wp_upload_dir();
    define('KTMP_UPLOADS_DIR', $uploadDir['basedir'] . '/keskintech-marketplaces');
}

if (!defined('KTMP_PLUGIN_VERSION')) {
    define('KTMP_PLUGIN_VERSION', '1.0');
}

require_once KTMP_PLUGIN_DIR . 'admin/active-plugin.php';

register_activation_hook( __FILE__, 'ktmp_active_plugin' );

require_once KTMP_PLUGIN_DIR . 'functions.php';
require_once KTMP_PLUGIN_DIR . 'admin/admin-menu.php';

load_plugin_textdomain( 'keskintech-marketplaces', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

function ktmp_enqueue_scripts() {
    if ( is_admin() ) {
        wp_enqueue_style( 'kmtp-admin-style', KTMP_PLUGIN_URL . 'admin-style.min.css' );
        wp_enqueue_script( 'ktmp-admin-script', KTMP_PLUGIN_URL . 'js/keskintech-marketplaces.min.js', array( 'jquery' ), '1.0', true );
    }
}
add_action( 'admin_enqueue_scripts', 'ktmp_enqueue_scripts' );

register_deactivation_hook(__FILE__, function() {
    \Keskintech\KeskintechMarketplaces\KTMP_Scheduler::deactivate_scheduler();
});