jQuery(document).ready(function($) {
	/* Template List */
	if ($('#ktmp-template-list').length > 0) {
	   var templateLinks = document.querySelectorAll(".templateLink");
       var deleteLinks = document.querySelectorAll(".deleteTemplateLink");
       var nonce = ktmp.nonce; 

       templateLinks.forEach(function(link) {
          link.addEventListener("click", function(event) {
            event.preventDefault();
            var form = document.createElement('form');
            form.method = 'post';
            form.action = ''; 
            var hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'send-column-update';
            hiddenInput.value = 'template';
            form.appendChild(hiddenInput);
            var additionalInputs = ['filepath', 'columnname', 'marketplace_id', 'matchedheaderjsonpath', 'SelectedSheetName'];
            for (var i = 0; i < additionalInputs.length; i++) {
                var input = document.createElement('input');
                input.type = 'hidden';
                input.name = additionalInputs[i];
                input.value = link.dataset[additionalInputs[i]];
                form.appendChild(input);
            }
			var nonceInput = document.createElement('input');
            nonceInput.type = 'hidden';
            nonceInput.name = '_wpnonce';  
            nonceInput.value = ktmp.ktmp_process_nonce;  
            form.appendChild(nonceInput);
            document.body.appendChild(form);
            form.submit();
          });
      });

      deleteLinks.forEach(function(deleteLink) {
        deleteLink.addEventListener("click", function(event) {
            event.preventDefault();
            var templateId = deleteLink.dataset.templateId;
            if (confirm(ktmp.confirmDelete)) { 
                var ajaxUrl = ktmp.ajaxUrl; 
                var data = {
                    action: 'ktmp_delete_template_action',
                    template_id: templateId,
                    security: nonce
                };
                jQuery.post(ajaxUrl, data, function(response) {
                    if (response === 'success') {
                        location.reload();
                    } else {
                        alert(ktmp.errorMessage);
                    }
                });
            }
        });
      });
	}
    
	/* Save template */
	if ($('#save-as-template').length > 0) {
		var myForm = $('#save-as-template');
        var successMessage = $('.notice-success');
        var errorMessage = $('.notice-error');

        myForm.on('submit', function(e) {
           e.preventDefault();
           var formData = myForm.find('[name=data]').val();
           var nonce = ktmp_saveastemplate.nonce;  

           $.ajax({
               type: 'POST',
               url: ktmp_saveastemplate.ajaxUrl, 
               data: {
                   action: 'ktmp_saveastemplateajax',
                   data: formData,
                   nonce: nonce,
                   FilePathName: ktmp_saveastemplate.FilePathName,
                   MatchedHeaderJSONPathName: ktmp_saveastemplate.MatchedHeaderJSONPathName,
                   marketplace_id: ktmp_saveastemplate.marketplace_id,
                   SKUColumnName: ktmp_saveastemplate.SKUColumnName,
                   SelectedSheetName: ktmp_saveastemplate.SelectedSheetName
               },
               success: function(response) {
                   console.log(response);
                   var parsedResponse = JSON.parse(response);
                   var message = parsedResponse.message || 'An error occurred';

                   if (parsedResponse.response === 'success') {
                       successMessage.html('<p class="success-message">' + message + '</p>').show();
                       errorMessage.hide();
                       myForm.hide();
                   } else {
                       errorMessage.html('<p class="error-message">' + message + '</p>').show();
                       successMessage.hide();
                   }
               },
               error: function(error) {
                  console.log(error);
                  var errorMessageText = error.statusText || 'An error occurred';
                  errorMessage.html('<p class="error-message">' + errorMessageText + '</p>').show();
                  successMessage.hide();
               }
           });
       });
	}
});
