var inputCount = ktmpData.initialInputCount || 0; 
function ktmAddInput() {
    inputCount++;
    var inputContainer = document.getElementById('ktmp-input-container');
    var inputPair = document.createElement('div');
    inputPair.classList.add('ktmp-input-pair');

    // Select dropdown (operation)
    var operationSelect = document.createElement('select');
    operationSelect.name = 'operation_' + inputCount;
    operationSelect.innerHTML = '<option value="addition">' + ktmpData.addition + '</option>' +
        '<option value="subtraction">' + ktmpData.subtraction + '</option>' +
        '<option value="multiplication">' + ktmpData.multiplication + '</option>' +
        '<option value="division">' + ktmpData.division + '</option>';

    // Input field (value)
    var valueInput = document.createElement('input');
    valueInput.name = 'value_' + inputCount;
    valueInput.type = 'number';
    valueInput.step = '0.01';
    valueInput.min = '0.01';
    valueInput.placeholder = ktmpData.enterValue;
    valueInput.required = true;

    // Remove button
    var removeBtn = document.createElement('span');
    removeBtn.classList.add('ktmp-remove-btn');
    removeBtn.innerHTML = ktmpData.removeText;
    removeBtn.onclick = function () {
        inputContainer.removeChild(inputPair);
        ktmUpdateLabels();
        ktmUpdateInputCount();
        ktmUpdateRemainingInputNames();
    };

    // Label
    var label = document.createElement('label');
    label.textContent = ktmpData.ruleLabel + (inputContainer.children.length + 1) + ':*';

    // Append all elements to the inputPair div
    inputPair.appendChild(label);
    inputPair.appendChild(operationSelect);
    inputPair.appendChild(valueInput);
    inputPair.appendChild(removeBtn);

    // Add inputPair to the container
    inputContainer.appendChild(inputPair);

    // Update the inputCount
    document.getElementById('inputCount').value = inputCount;

    // Update other input names
    ktmUpdateRemainingInputNames();
}
function ktmUpdateLabels() {
   var inputPairs = document.querySelectorAll('.ktmp-input-pair');
   inputPairs.forEach(function (pair, index) {
      var label = pair.querySelector('label');
      label.textContent = ktmpData.ruleLabel + (index + 1) + ':';
   });
}
function ktmUpdateInputCount() {
   inputCount = document.querySelectorAll('.ktmp-input-pair').length;
   document.getElementById('inputCount').value = inputCount;
}
function ktmRemoveInput(btn) {
   var inputContainer = document.getElementById('ktmp-input-container');
   var inputPair = btn.parentElement;
   inputContainer.removeChild(inputPair);
   ktmUpdateLabels();
   ktmUpdateInputCount();
   ktmUpdateRemainingInputNames();
}
function ktmUpdateRemainingInputNames() {
   var inputPairs = document.querySelectorAll('.ktmp-input-pair');
   inputPairs.forEach(function (pair, index) {
     var operationSelect = pair.querySelector('select[name^="operation_"]');
     var valueInput = pair.querySelector('input[name^="value_"]');
     var newOperationName = 'operation_' + (index + 1);
     var newValueName = 'value_' + (index + 1);
       operationSelect.name = newOperationName;
       valueInput.name = newValueName;
   });
}