jQuery(document).ready(function($) {
  if ($('#ktmp-settings').length > 0) {
    function KTMPUpdateBrandOptions() {
      const brandOptionElement = document.querySelector('input[name="ktmp_brand_options"]:checked');
      const brandOption = brandOptionElement ? brandOptionElement.value : 'passive';
      const brandFromInput = document.querySelector('.ktmp_brand_from_input');
      const fixedBrandInput = document.querySelector('.ktmp_fixed_brand');
      const termInput = document.querySelector('.urun_term_bilgisi_input');
      if (brandOption === 'active') {
        brandFromInput.style.display = 'table-row';
      } else {
        brandFromInput.style.display = 'none';
        fixedBrandInput.style.display = 'none';
        termInput.style.display = 'none';
      }
      ktmUpdateBrandFromOptions();
    }	  
    const brandOptionElement = document.querySelector('input[name="ktmp_brand_options"]:checked');
        if (!brandOptionElement) {
           document.querySelector('input[name="ktmp_brand_options"][value="passive"]').checked = true;
        }
        KTMPUpdateBrandOptions();
        document.querySelectorAll('input[name="ktmp_brand_options"]').forEach(input => {
           input.addEventListener('change', KTMPUpdateBrandOptions);
        });
        document.querySelectorAll('input[name="ktmp_brand_from"]').forEach(input => {
           input.addEventListener('change', ktmUpdateBrandFromOptions);
        });
  }	
  if ($('#ktmp-pricing-rules-form').length > 0) { 
    function ktmToggleRoundingOptions() {
      var ktmRoundingOptions = document.getElementById('ktmp-rounding-rules');
      ktmRoundingOptions.style.display = document.getElementById('ktmp-round-it').checked ? 'block' : 'none';
    }
	document.getElementById('ktmp-round-it').addEventListener('change', ktmToggleRoundingOptions);
    document.getElementById('ktmp-not-round').addEventListener('change', ktmToggleRoundingOptions);
    ktmToggleRoundingOptions();
  }	
  const table = document.getElementById('ktmp-expand-table');
  if (table) {	
	const expandButtons = document.querySelectorAll(".ktmp-expand-button");
    expandButtons.forEach(function (button) {
            button.addEventListener("click", function (event) {
                event.preventDefault();
                const toggleValue = button.getAttribute("data-toggle");
                const subRows = document.querySelectorAll(`.ktmp-sub-row[data-parent="${toggleValue}"]`);
                subRows.forEach(function (subRow) {
                    if (subRow.classList.contains("visible")) {
                        subRow.classList.remove("visible");
                    } else {
                        subRow.classList.add("visible");
                    }
                });
            });
    });
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
       checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function (event) {
                event.preventDefault();
                const toggleValue = this.getAttribute('data-toggle');
                if (toggleValue) {
                    const relatedCheckboxes = document.querySelectorAll(`input[data-parent="${toggleValue}"]`);

                    relatedCheckboxes.forEach(relatedCheckbox => {
                        relatedCheckbox.checked = this.checked;
                    });
                }
            });
        });
  }
  if ($('#keskintech-mother-buton').length > 0) { 
    var button1 = document.getElementById("keskintech-mother-buton");
    var button2 = document.getElementById("ktmp-fixed-button");
    function kontrolEt() {
     if (isElementVisible(button1)) {
         button2.style.display = "none";
        } else {
            button2.style.display = "block";
        }
    }
    window.addEventListener('scroll', kontrolEt);
	function isElementVisible(el) {
        var rect = el.getBoundingClientRect();
        var windowHeight = (window.innerHeight || document.documentElement.clientHeight);
        return (
            rect.top >= 0 &&
            rect.bottom <= windowHeight
        );
    } 
  } 
  if ($('#ktmp-price-type').length > 0) { 
     const style = document.createElement('style');
     style.type = 'text/css';
     style.innerHTML = `
        .pricing-primary:hover::before {
            content: "${ktmpCSSData.pricing_primary}";
            z-index: 5;
        }
        .pricing-rule:hover::before {
            content: "${ktmpCSSData.pricing_rule}";
            z-index: 5;
        }
        .pricing-current-site:hover::before {
            content: "${ktmpCSSData.current_site}";
            z-index: 5;
        }
    `;
     document.head.appendChild(style);
  }
  
});
function ktmDragStart(event) {
    const draggedItem = event.target;
    const selectElement = draggedItem.querySelector('.item-select');
    if (selectElement) {
        const selectedIndex = selectElement.selectedIndex;
        const selectedValue = selectElement.options[selectedIndex].value;
		const draggedItemId = draggedItem.id;
		const combinedData = `${draggedItemId}${selectedValue}`;
		const draggedItemText = selectElement.options[selectedIndex].text;
        event.dataTransfer.setData("text/plain", combinedData);
        event.dataTransfer.setData("text/custom", draggedItemText);
    } else {
		event.dataTransfer.setData("text/plain", draggedItem.id);
        const draggedItemText = draggedItem.textContent;
        event.dataTransfer.setData("text/custom", draggedItemText);
    }
}
function ktmDragOver(event) {
     event.preventDefault();
}
function ktmDrop(event) {
    event.preventDefault();
    const draggedItemId = event.dataTransfer.getData("text/plain");
    const draggedItemText = event.dataTransfer.getData("text/custom");
    const inputContainer = event.target.closest('.ktmp-input-container');
    if (inputContainer && !inputContainer.querySelector('.item')) {
        const inputElement = inputContainer.querySelector('.input');
        const labelElement = inputContainer.querySelector('label');
        if (labelElement && draggedItemText) {
            labelElement.textContent = draggedItemText;
            inputElement.value = draggedItemId;
        }
        inputContainer.querySelector('.ktmp-clear-icon').style.display = 'block';
        inputElement.setAttribute('type', 'hidden');
    }
    inputContainer.classList.remove('hovered');
}
function validateAndSubmit() {
	var warning = ktmp_validateandsubmit.warning_message
    const inputValues = document.querySelectorAll("input[name^=Column]");
    let skuCount = 0;
    inputValues.forEach((input) => {
        if (input.value.trim().toLowerCase() === 'sku') {
             skuCount++;
        }
    });
    if (skuCount === 0) {
        alert(warning);
        return false;
    }
    if (ktmp_validateandsubmit.process_type === 'update' && skuCount > 1) {
         alert(ktmp_validateandsubmit.one_sku_warning);
         return false;
    }
    return true;
}
function ktmClearInput(inputId) {
    const inputContainer = document.getElementById(inputId);
    const inputElement = inputContainer.querySelector('.input');
    const labelElement = inputContainer.querySelector('label');
    inputElement.value = '';
	inputElement.setAttribute('type', 'text');
    if (labelElement) {
        const defaultLabelText = labelElement.getAttribute('data-default');
        labelElement.textContent = defaultLabelText;
    }
    inputContainer.querySelector('.ktmp-clear-icon').style.display = 'none';
}
function initializeMarketplaceImageUploader() {
    var a = {
        variable_image_frames: {},
        placeholder_img_src: woocommerce_admin_meta_boxes_variations.woocommerce_placeholder_img_src,
        i18n_choose_image: woocommerce_admin_meta_boxes_variations.i18n_choose_image,
        i18n_set_image: woocommerce_admin_meta_boxes_variations.i18n_set_image
    };
    var $document = jQuery(document);
    $document.off("click", ".upload_marketplace_image_button");
    $document.on("click", ".upload_marketplace_image_button", function(event) {
        event.preventDefault();
        var $button = jQuery(this),
            post_id = $button.attr("rel"),
            $container = $button.closest(".upload_marketplace_image"),
            input_name = $button.attr("data-input");
        a.variable_image_frames[input_name] = a.variable_image_frames[input_name] || null;
        if ($button.hasClass("remove")) {
            jQuery(".ktmp_upload_marketplace_image_field", $container).val("").trigger("change");
            $container.find("img").eq(0).attr("src", a.placeholder_img_src);
            $button.removeClass("remove");
        } else {
            if (a.variable_image_frames[input_name]) {
                a.variable_image_frames[input_name].uploader.uploader.param("post_id", post_id);
                a.variable_image_frames[input_name].open();
                return;
            }
            wp.media.model.settings.post.id = post_id;
            a.variable_image_frames[input_name] = wp.media.frames.variable_image = wp.media({
                title: a.i18n_choose_image,
                button: { text: a.i18n_set_image },
                states: [new wp.media.controller.Library({ title: a.i18n_choose_image, filterable: "all" })]
            });
            a.variable_image_frames[input_name].on("select", function() {
                var selection = a.variable_image_frames[input_name].state().get("selection").first().toJSON(),
                    thumbnail_url = selection.sizes && selection.sizes.thumbnail ? selection.sizes.thumbnail.url : selection.url;
                jQuery(".ktmp_upload_marketplace_image_field", $container).val(selection.id).trigger("change");
                $container.find(".upload_marketplace_image_button").addClass("remove");
                $container.find("img").eq(0).attr("src", thumbnail_url);
                wp.media.model.settings.post.id = post_id;
            });
            a.variable_image_frames[input_name].open();
        }
    });
}
function ktmUpdateBrandFromOptions() {
    const brandOptionElement = document.querySelector('input[name="ktmp_brand_options"]:checked');
    const brandOption = brandOptionElement ? brandOptionElement.value : 'passive';
    const brandFrom = document.querySelector('input[name="ktmp_brand_from"]:checked')?.value;
    const fixedBrandInput = document.querySelector('.ktmp_fixed_brand');
    const termInput = document.querySelector('.urun_term_bilgisi_input');
    if (brandOption === 'active') {
        if (brandFrom === 'term') {
            termInput.style.display = 'table-row';
            fixedBrandInput.style.display = 'none';
        } else if (brandFrom === 'fixed-brand') {
            fixedBrandInput.style.display = 'table-row';
            termInput.style.display = 'none';
        }
    }
}







