<?php

use Keskintech\KeskintechMarketplaces\KTMP_Marketplace;
use Keskintech\KeskintechMarketplaces\KTMP_Product;
use Keskintech\KeskintechMarketplaces\KTMP_Templates;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_ProductAddLastEditedDate($product_id,$current_date){
    update_post_meta($product_id, 'ktmp_edited_date', $current_date);
}
function ktmp_ProductGetLastEditedDate($product_id) {
    $last_edited_date = get_post_meta($product_id, 'ktmp_edited_date', true);
	if($last_edited_date){
       $timestamp = strtotime($last_edited_date);
       $formatted_date = date_i18n('j F Y H:i', $timestamp);
       return $formatted_date ?: '';
    }
	return '';
}
add_action('wp_ajax_ktmp_delete_template_action', 'ktmp_delete_template_callback');
function ktmp_delete_template_callback() {
    check_ajax_referer('ktmp_deletetemplate_nonce', 'security');
    if ( isset($_POST['template_id']) ) {
        $templateId = sanitize_text_field($_POST['template_id']);
        $KeskintechTemplates = new KTMP_Templates();
        $result = $KeskintechTemplates->DeleteTemplate($templateId);
        echo $result ? 'success' : 'error';
    } else {
        echo 'error';
    }
    wp_die();
}
function ktmp_saveastemplateajax() {
	check_ajax_referer('ktmp_saveastemplate_nonce', 'nonce');
    $KeskintechTemplates = new KTMP_Templates();
	if(!isset($_POST['data']) || $_POST['data'] == ''){
		echo wp_json_encode(array('response' => 'error', 'message' => __('Please enter a template name.', 'keskintech-marketplaces')));
        wp_die();
	}
	$data = sanitize_text_field( wp_unslash( $_POST['data'] ) );
    $FilePathName = isset($_POST['FilePathName']) ? sanitize_text_field($_POST['FilePathName']) : '';
    $MatchedHeaderJSONPathName = isset($_POST['MatchedHeaderJSONPathName']) ? sanitize_text_field($_POST['MatchedHeaderJSONPathName']) : '';
    $marketplace_id = isset($_POST['marketplace_id']) ? sanitize_text_field($_POST['marketplace_id']) : '';
    $SKUColumnName = isset($_POST['SKUColumnName']) ? sanitize_textarea_field($_POST['SKUColumnName']) : '';
	if (empty($FilePathName) || empty($MatchedHeaderJSONPathName) || empty($marketplace_id) || empty($SKUColumnName)) {
        echo wp_json_encode(array(
            'response' => 'error', 
            'message' => __('Please fill in all required fields.', 'keskintech-marketplaces')
        ));
        wp_die();
    }
	$SelectedSheetName = isset($_POST['SelectedSheetName']) ? sanitize_text_field($_POST['SelectedSheetName']) : __('Your Products', 'keskintech-marketplaces');
    $SaveasTemplateAjax = $KeskintechTemplates->SaveTemplate($FilePathName, $data, $SKUColumnName, $marketplace_id, $MatchedHeaderJSONPathName, $SelectedSheetName);
    if ($SaveasTemplateAjax) {
        $headerJSONSourcePath = KTMP_UPLOADS_DIR . '/tmp/matched-header/' . $MatchedHeaderJSONPathName . '.json';
        $headerJSONDestinationPath = KTMP_UPLOADS_DIR . '/tmp/saved-templates/' . $MatchedHeaderJSONPathName . '.json';
        $fileJSONSourcePath = KTMP_UPLOADS_DIR . '/tmp/uploaded-file/' . $FilePathName . '.json';
        $fileJSONDestinationPath = KTMP_UPLOADS_DIR . '/tmp/saved-templates/' . $FilePathName . '.json';
        $headerCopySuccess = copy($headerJSONSourcePath, $headerJSONDestinationPath);
        $fileCopySuccess = copy($fileJSONSourcePath, $fileJSONDestinationPath);
        if ($headerCopySuccess && $fileCopySuccess) {
			echo wp_json_encode(array(
                'response' => 'success', 
                'message' => __('Congratulations, the template has been successfully saved.', 'keskintech-marketplaces')
             ));
        } else {
            echo wp_json_encode(array(
                'response' => 'error', 
                'message' => __('An error occurred while copying the template.', 'keskintech-marketplaces')
            ));
        }
    } else {
        echo wp_json_encode(array(
            'response' => 'error', 
            'message' => __('An error occurred while saving. Please do not create a template with the same name.', 'keskintech-marketplaces')
        ));
    }
    wp_die();
}
add_action('wp_ajax_ktmp_saveastemplateajax', 'ktmp_saveastemplateajax');
add_action('before_delete_post', 'ktmp_when_product_deleted');
function ktmp_when_product_deleted($post_id) {
    if (get_post_type($post_id) === 'product') {
		$product = new KTMP_Product();
		$product->DeleteProductData($post_id);
    }
}
add_action('woocommerce_delete_product_variation', 'ktmp_when_variation_deleted');
function ktmp_when_variation_deleted($variation_id) {
	$ktmp_product = new KTMP_Product();
	$ktmp_product->DeleteProductData($variation_id, false);
}
function ktmp_on_before_attribute_deleted($attribute_id) {
	$KeskintechMarketplace = KTMP_Marketplace::get_instance();
    $taxonomy = wc_attribute_taxonomy_name_by_id($attribute_id);
    $DeleteMatchedAtt = $KeskintechMarketplace->DeleteMatchedTerm($taxonomy,false,'att_taxonomy',true);
	$terms = get_terms(array(
            'taxonomy' => $taxonomy,
            'hide_empty' => false,
        ));
	if (!is_wp_error($terms) && !empty($terms)) {
            foreach ($terms as $term) {
				$DeleteMatchedTerm = $KeskintechMarketplace->DeleteMatchedTerm($term->term_id,false,'term',true);
            }
    }
}
add_action('woocommerce_before_attribute_delete', 'ktmp_on_before_attribute_deleted');
function ktmp_on_before_term_deleted($term_id, $taxonomy) {
	$ktmp = [];
	$brand_term = get_option('ktmp_brand_term');
	if(!empty($brand_term)){
		if(strpos($taxonomy,$brand_term) === 0){
			$ktmp[] = 'brand';
		}
	}
	if(strpos($taxonomy, 'pa_') === 0){
		$ktmp[] = 'term';
	}
	if(strpos($taxonomy, 'product_cat') === 0){
		$ktmp[] = 'category';
	}
	if (!empty($ktmp)) {
		$KeskintechMarketplace = KTMP_Marketplace::get_instance();
		foreach ($ktmp as $meta_key) {
			$KeskintechMarketplace->DeleteMatchedTerm($term_id, false, $meta_key, true);
		}
	}
}
add_action('pre_delete_term', 'ktmp_on_before_term_deleted', 10, 2);
function ktmp_clear_match_on_brand_update($old_value, $new_value) {
    if ($old_value !== $new_value) {
        $KeskintechMarketplace = KTMP_Marketplace::get_instance();       
        $DeleteMatchedTerm = $KeskintechMarketplace->WhenBrandTermUpdated();
    }
}
add_action('update_option_ktmp_brand_term', 'ktmp_clear_match_on_brand_update', 10, 2);
function ktmp_clear_match_fixed_brand_update($old_value, $new_value) {
    if ($old_value !== $new_value) {
        $KeskintechMarketplace = KTMP_Marketplace::get_instance();      
        $DeleteMatchedTerm = $KeskintechMarketplace->DeleteMatchedTerm(0,false,'brand',true);
    }
}
add_action('update_option_ktmp_fixed_brand', 'ktmp_clear_match_fixed_brand_update', 10, 2);
function ktmp_product_brand($product_id, $marketplace_id = NULL) {
    $brand_options = get_option('ktmp_brand_options');
    if (!$brand_options || $brand_options == 'passive') {
        return;
    }
	$KeskintechMarketplace = KTMP_Marketplace::get_instance();
	$brand_from = get_option('ktmp_brand_from');
	if($brand_from =='term'){
		$taxonomy = get_option('ktmp_brand_term');
        $terms = wp_get_post_terms($product_id, $taxonomy);
		if (empty($terms) || is_wp_error($terms) || $marketplace_id === null) {
            return;
        }
		$MatchedOrDefaultTermName = $KeskintechMarketplace->MatchedOrDefaultTermName($terms[0]->term_id, $marketplace_id, 'brand');
		return $MatchedOrDefaultTermName;
	}
	elseif($brand_from=='fixed-brand'){
		if ($marketplace_id === null) {
            return;
        }
		$brand = get_option('ktmp_fixed_brand');
		if(!$brand){
			return;
		}
		$MatchedOrDefaultTermName = $KeskintechMarketplace->MatchedOrDefaultTermName(0, $marketplace_id, 'brand');
		return $MatchedOrDefaultTermName ?? $brand;
	}
	return;
}
function ktmp_marketplace_images($product, $product_id, $image_number, $simple = true){
	if ($image_number == 0){
		$image_id = get_post_thumbnail_id($product_id);
		return $image_id ? wp_get_attachment_url($image_id) : '';
	}
	else{
		if ($simple == false){
			$marketplace_image_id = get_post_meta($product_id, 'ktmp_marketplace_image_field_' . $image_number, true);
			return $marketplace_image_id ? wp_get_attachment_url($marketplace_image_id) : '';
		}
		else{
			$product_gallery_ids = $product->get_gallery_image_ids();
			if (!empty($product_gallery_ids)) {
				 $gallery_image_id = isset($product_gallery_ids[$image_number - 1]) ? $product_gallery_ids[$image_number - 1] : null;
				 return $gallery_image_id ? wp_get_attachment_url($gallery_image_id) : '';
			}
		}
	}
	return '';
}			
add_action( 'woocommerce_variation_options', 'ktmp_variation_group_code_field', 10, 3 );
function ktmp_variation_group_code_field( $loop, $variation_data, $variation ) {
    woocommerce_wp_text_input( array(
        'id'          => 'ktmp_variation_group_code[' . $loop . ']',
        'label'       => __( 'Variation Group Code', 'keskintech-marketplaces' ),
        'placeholder' => '',
        'desc_tip'    => 'true',
        'description' => __( 'Enter the group code for this variation.', 'keskintech-marketplaces' ),
        'value'       => get_post_meta( $variation->ID, 'ktmp_variation_group_code', true )
    ));
}
add_action( 'woocommerce_save_product_variation', 'ktmp_save_variation_group_code_field', 10, 2 );
function ktmp_save_variation_group_code_field( $variation_id, $i ) {
    $group_code = isset( $_POST['ktmp_variation_group_code'][$i] ) ? sanitize_text_field( $_POST['ktmp_variation_group_code'][$i]  ) : '';
    if ( ! empty( $group_code ) ) {
        update_post_meta( $variation_id, 'ktmp_variation_group_code', $group_code);
    }
	else {
        delete_post_meta( $variation_id, 'ktmp_variation_group_code' );
    }
}

add_action( 'woocommerce_product_after_variable_attributes', 'ktmp_marketplace_image_fields', 10, 3 );
function ktmp_marketplace_image_fields( $loop, $variation_data, $variation ) {
    $marketplace_image_fields = array();
    for ($i = 1; $i <= 5; $i++) {
        $marketplace_image_fields[] = $variation_data['ktmp_marketplace_image_field_' . $i][0] ?? null;
    }
    ?>
    <div class="marketplace-images">
        <h3><?php echo esc_html_e( 'Marketplace Images', 'keskintech-marketplaces' ); ?></h3>
		<p class="description"><?php echo esc_html_e( 'Add your marketplace images here. Do not add the variation featured image here.', 'keskintech-marketplaces' ); ?></p>
        <?php for ($i = 1; $i <= 5; $i++) : ?>
            <p class="upload_marketplace_image">
                <a href="#"
                    class="upload_marketplace_image_button tips <?php echo $marketplace_image_fields[$i-1] ? 'remove' : ''; ?>" onclick="initializeMarketplaceImageUploader(); return false;"
                    data-tip="<?php echo $marketplace_image_fields[$i-1] ? esc_attr__( 'Remove this image', 'keskintech-marketplaces' ) : esc_attr__( 'Upload an image', 'keskintech-marketplaces' ); ?>"
                    rel="<?php echo esc_attr( $variation->ID ); ?>"
                    data-input="<?php echo esc_attr( 'ktmp_upload_marketplace_image_field_' . $i . '[' . $loop . ']' ); ?>">
                    <img src="<?php echo $marketplace_image_fields[$i-1] ? esc_url( wp_get_attachment_thumb_url( $marketplace_image_fields[$i-1] ) ) : esc_url( wc_placeholder_img_src() ); ?>" />
                    <input
                        type="hidden"
                        name="ktmp_upload_marketplace_image_field_<?php echo esc_attr($i); ?>[<?php echo esc_attr( $loop ); ?>]"
                        class="ktmp_upload_marketplace_image_field" value="<?php echo esc_attr( $marketplace_image_fields[$i-1] ); ?>" />
                </a>
            </p>
        <?php endfor; ?>
    </div>
    <?php
}
add_action( 'woocommerce_save_product_variation', 'ktmp_save_marketplace_image_fields', 10, 2 );
function ktmp_save_marketplace_image_fields( $variation_id, $loop ) {
    $array = array();
    $order = 1;
    for ($i = 1; $i <= 5; $i++) {
        $field_name = 'ktmp_upload_marketplace_image_field_' . $i;
        if (isset( $_POST[ $field_name ][ $loop ]) && $_POST[ $field_name ][ $loop ] !== '') {
            $value = wc_clean( wp_unslash( $_POST[ $field_name ][ $loop ] ) );
            $array[$order] = esc_attr( $value );
            $order++;
        }
    }
    for ($i = 1; $i <= 5; $i++) {
        if (isset($array[$i])) {
            update_post_meta( $variation_id, 'ktmp_marketplace_image_field_' . $i, $array[$i] );
        } else {
            delete_post_meta($variation_id, 'ktmp_marketplace_image_field_' . $i);
        }
    }
}
function ktmp_register_settings() {
    register_setting('ktmp_options_group', 'ktmp_brand_options', [
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    register_setting('ktmp_options_group', 'ktmp_brand_from', [
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    register_setting('ktmp_options_group', 'ktmp_brand_term', [
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    register_setting('ktmp_options_group', 'ktmp_fixed_brand', [
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    register_setting('ktmp_options_group', 'ktmp_in_stock_value', [
        'sanitize_callback' => 'ktmp_sanitize_number',
    ]);
}
add_action('admin_init', 'ktmp_register_settings');

function ktmp_sanitize_number($input) {
    if (is_numeric($input)) {
        return $input;
    }
    return '';
}

function ktmp_no_marketplace_warning() { ?>
    <div class="ktmp-warning-box">
        <?php
        $message = sprintf(
            esc_html__(
                'Warning: Please add a marketplace first to proceed. Click %1$shere%2$s to add a marketplace.', 
                'keskintech-marketplaces'
            ),
            '<a href="' . esc_url(get_site_url() . '/wp-admin/admin.php?page=ktmp-marketplaces') . '" class="ktmp-warning-a">',
            '</a>'
        );
        echo wp_kses_post($message);
        ?>
    </div>
<?php }

function ktmp_log($error_message, $error_code = '0000'){
	$logs_class = \Keskintech\KeskintechMarketplaces\KTMP_Logs::get_instance();
    $logs_class->add_error($error_message, $error_code);
}
