<?php 
if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_menu(){
    add_menu_page(
        esc_html__( 'Marketplaces', 'keskintech-marketplaces' ), 
        esc_html__( 'Marketplaces', 'keskintech-marketplaces' ),
        'manage_options',
        'ktmp-marketplaces',
        'ktmp_marketplaces_callback',
        'dashicons-cart',
        54 
    );

    add_submenu_page(
        'ktmp-marketplaces',
        esc_html__( 'Pricing', 'keskintech-marketplaces' ), 
        esc_html__( 'Pricing', 'keskintech-marketplaces' ), 
        'manage_options',
        'ktmp-pricing',
        'ktmp_pricing_callback'
    );

    add_submenu_page(
        'ktmp-marketplaces',
        esc_html__( 'Send Products', 'keskintech-marketplaces' ),
        esc_html__( 'Send Products', 'keskintech-marketplaces' ),
        'manage_options',
        'ktmp-send-products',
        'ktmp_send_products_callback'
    );

    add_submenu_page(
        'ktmp-marketplaces',
        esc_html__( 'Update Products', 'keskintech-marketplaces' ), 
        esc_html__( 'Update Products', 'keskintech-marketplaces' ), 
        'manage_options',
        'ktmp-update-products',
        'ktmp_update_products_callback'
    );

    add_submenu_page(
        'ktmp-marketplaces',
        esc_html__( 'Matching Fields', 'keskintech-marketplaces' ), 
        esc_html__( 'Matching Fields', 'keskintech-marketplaces' ), 
        'manage_options',
        'ktmp-matching-fields',
        'ktmp_matching_fields_callback'
    );

    add_submenu_page(
        'ktmp-marketplaces',
        esc_html__( 'Settings', 'keskintech-marketplaces' ), 
        esc_html__( 'Settings', 'keskintech-marketplaces' ), 
        'manage_options',
        'ktmp-settings',
        'ktmp_settings_callback'
    );
}
add_action('admin_menu', 'ktmp_menu');
function ktmp_require_once_path( $path ) {
    require_once KTMP_PLUGIN_DIR . $path;
}	
function ktmp_pricing_callback() {
    echo '<div class="wrap">';
	$current_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'price-by-product';
    echo '<div class="nav-tab-wrapper">';
        echo '<a class="nav-tab ' . ($current_tab == 'price-by-product' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-pricing&tab=price-by-product">' . esc_html__( 'Price by Product', 'keskintech-marketplaces' ) . '</a>';
        echo '<a class="nav-tab ' . ($current_tab == 'marketplace-price-rules' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-pricing&tab=marketplace-price-rules">' . esc_html__( 'Marketplace Price Rules', 'keskintech-marketplaces' ) . '</a>';
    echo '</div>';
	if ($current_tab == 'marketplace-price-rules') {
		ktmp_require_once_path('parts/pricing/marketplace-price-rules.php');
    }
    else{
		ktmp_require_once_path('parts/pricing/price-by-product.php');
    }
    echo '</div>';
}
function ktmp_matching_fields_callback() {
    echo '<div class="wrap">';
    $current_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'terms';
    echo '<div class="nav-tab-wrapper">';
        echo '<a class="nav-tab ' . ($current_tab == 'terms' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-matching-fields&tab=terms">' . esc_html__( 'Terms', 'keskintech-marketplaces' ) . '</a>';
        echo '<a class="nav-tab ' . ($current_tab == 'brands' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-matching-fields&tab=brands">' . esc_html__( 'Brands', 'keskintech-marketplaces' ) . '</a>';
    echo '</div>';
	ktmp_require_once_path('parts/match/functions.php');
    if ($current_tab == 'brands') {
		ktmp_require_once_path('parts/match/brand.php');
    }
	else{
		ktmp_require_once_path('parts/match/attribute.php');
    }
    echo '</div>';
}

function ktmp_marketplaces_callback() {
	ktmp_require_once_path('parts/marketplaces/marketplaces.php');
}

function ktmp_send_products_callback() {
    ktmp_require_once_path( 'parts/marketplaces/send-product/send-product.php' );
    ktmp_require_once_path( 'parts/marketplaces/functions.php' );
    ktmp_require_once_path( 'parts/marketplaces/start-process.php' );
    ktmp_start_process( 'send' );
}

function ktmp_update_products_callback() {
    ktmp_require_once_path( 'parts/marketplaces/update-product/update-product.php' );
    ktmp_require_once_path( 'parts/marketplaces/functions.php' );
    ktmp_require_once_path( 'parts/marketplaces/start-process.php' );
    ktmp_start_process( 'update' );
}
function ktmp_settings_callback(){
    echo '<div class="wrap">';
    $current_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'general-settings';
    echo '<div class="nav-tab-wrapper">';
        echo '<a class="nav-tab ' . ($current_tab == 'general-settings' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-settings&tab=general-settings">' . esc_html__( 'General', 'keskintech-marketplaces' ) . '</a>';
        echo '<a class="nav-tab ' . ($current_tab == 'product-problems' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-settings&tab=product-problems">' . esc_html__( 'Product Problems', 'keskintech-marketplaces' ) . '</a>';
        echo '<a class="nav-tab ' . ($current_tab == 'logs' ? 'ktmp-nav-tab-active' : '') . '" href="?page=ktmp-settings&tab=logs">' . esc_html__( 'Logs', 'keskintech-marketplaces' ) . '</a>';
	echo '</div>';
	if ($current_tab == 'product-problems') {
		ktmp_require_once_path('/parts/settings/product-control.php');
    }
	elseif ($current_tab == 'logs') {
		ktmp_require_once_path('/parts/settings/logs.php');
    }
	else{
		ktmp_require_once_path('/parts/settings/settings.php');
    }
	echo '</div>';
}