<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function ktmp_active_plugin(){
	ktmp_active_database();
	
	ktmp_create_uploads_dir();
}

function ktmp_active_database(){  
 global $wpdb;
    $marketplace_table_name = "{$wpdb->prefix}ktmp_marketplaces";
    $marketplaces = "CREATE TABLE IF NOT EXISTS $marketplace_table_name (
        marketplace_id INT NOT NULL AUTO_INCREMENT,
        market_name VARCHAR(100) NOT NULL,
		role ENUM('base','amazon','ebay','alibaba','etsy','walmart','trendyol','n11','hepsiburada','pazarama','ciceksepeti','pttavm') DEFAULT NULL,
        PRIMARY KEY (marketplace_id),
		UNIQUE (role)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    $marketplaces_meta = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_marketplace_meta (
        meta_id INT NOT NULL AUTO_INCREMENT,
		marketplace_id INT NOT NULL,
		meta_key VARCHAR(100) NOT NULL,
        meta_value VARCHAR(100) NOT NULL,
		PRIMARY KEY (meta_id)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	$templates = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_templates (
        id INT NOT NULL AUTO_INCREMENT,
		template_name VARCHAR(100) NOT NULL,
		file_name VARCHAR(100) NOT NULL,
		columnname VARCHAR(100) NOT NULL,
		marketplace_id INT NOT NULL,
		header_name VARCHAR(100) NOT NULL,
		sheet_name VARCHAR(100) NOT NULL,
		template_date VARCHAR(16) NOT NULL,
		PRIMARY KEY (id)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	$productprice = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_product_prices (
        id INT NOT NULL AUTO_INCREMENT,
        product_id INT NOT NULL,
        marketplace_id INT NOT NULL,
        price DECIMAL(10, 2),
		old_price DECIMAL(10, 2),
        PRIMARY KEY (id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    $matching = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_matching (
	    match_id INT NOT NULL AUTO_INCREMENT,
        key_1 VARCHAR(100) NOT NULL,
		marketplace_id INT NOT NULL,
        meta_key ENUM('term','brand','category','att_taxonomy') NOT NULL,
		filter VARCHAR(100) DEFAULT NULL,
        key_2 VARCHAR(100) NOT NULL,
		key_2_value VARCHAR(100) DEFAULT NULL,
		PRIMARY KEY (match_id)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	$pricerules = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_price_rules (
	    rule_id INT NOT NULL AUTO_INCREMENT,
		rule_name VARCHAR(100),
        marketplace_id INT NOT NULL,
		filter_type VARCHAR(100),
        filter_value JSON,
		sorting_order INT,
		operation_type ENUM('addition', 'subtraction', 'multiplication', 'division'),
        value DECIMAL(10, 2) NOT NULL,
		PRIMARY KEY (rule_id)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	$logs = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ktmp_logs(
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        task_id mediumint(9) DEFAULT NULL,
        error_message text NOT NULL,
		error_code varchar(100) DEFAULT NULL,
        error_time datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY  (id),
        INDEX (task_id),
        INDEX (error_time)
    )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($marketplaces);
	dbDelta($marketplaces_meta);
	dbDelta($templates);
	dbDelta($productprice);
	dbDelta($matching);
	dbDelta($pricerules);
	dbDelta($logs);
	$base = 1;
	$existing_entry = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->prefix}ktmp_marketplaces WHERE marketplace_id = %d", $base
    ));
	if ($existing_entry == 0) {
        $wpdb->insert(
            "{$wpdb->prefix}ktmp_marketplaces",
            array(
                'marketplace_id' => 1,
                'market_name' => 'Base',
				'role' => 'base',
            ),
            array('%d', '%s', '%s')
        );
    }
}

function ktmp_create_uploads_dir() {
    $uploadDir = wp_upload_dir();
    $marketplacesDir = $uploadDir['basedir'] . '/keskintech-marketplaces';
    if (!file_exists($marketplacesDir)) {
        wp_mkdir_p($marketplacesDir);
    }
    
    $htaccessFile = $marketplacesDir . '/.htaccess';

    if (!file_exists($htaccessFile)) {
		$htaccessContent = "Order Deny,Allow\nDeny from all";
        file_put_contents($htaccessFile, $htaccessContent);
    }

    $tmpDir = $marketplacesDir . '/tmp';
    $subDirs = [
        'header-values',
        'matched-header',
        'ready-to-write',
        'saved-templates',
        'updated-file',
        'uploaded-file'
    ];

    foreach ($subDirs as $subDir) {
        $subDirPath = $tmpDir . '/' . $subDir;
        if (!file_exists($subDirPath)) {
            wp_mkdir_p($subDirPath);
        }
    }
}