<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Adiciona o campo para produtos simples
 */
add_action( 'woocommerce_product_options_general_product_data', 'kpco_add_plan_id_simple_product_field' );
function kpco_add_plan_id_simple_product_field() {
	echo '<div class="options_group">';

	woocommerce_wp_text_input( array(
		'id'          => '_kpco_plan_id',
		'label'       => __( 'Plan ID', 'keedpay-checkout-for-woocommerce' ),
		'desc_tip'    => true,
		'description' => __( 'Enter the plan ID associated with this product.', 'keedpay-checkout-for-woocommerce' ),
		'type'        => 'text',
	) );

	echo '</div>';

	wp_nonce_field( 'kpco_save_plan_id', 'kpco_plan_id_nonce' );
}

/**
 * Salva o campo do produto simples
 */
add_action( 'woocommerce_admin_process_product_object', 'kpco_save_plan_id_simple_product_field' );
function kpco_save_plan_id_simple_product_field( $product ) {
	if ( ! isset( $_POST['kpco_plan_id_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['kpco_plan_id_nonce'] ) ), 'kpco_save_plan_id' ) ) {
		return;
	}

	if ( isset( $_POST['_kpco_plan_id'] ) ) {
		$plan_id = sanitize_text_field( wp_unslash( $_POST['_kpco_plan_id'] ) );
		$product->update_meta_data( '_kpco_plan_id', $plan_id );
	}
}

/**
 * Adiciona o campo em cada variação */
add_action( 'woocommerce_product_after_variable_attributes', 'kpco_add_plan_id_variation_field', 10, 3 );
function kpco_add_plan_id_variation_field( $loop, $variation_data, $variation ) {
	$plan_id = get_post_meta( $variation->ID, '_kpco_plan_id', true );
	?>
	<div class="form-row form-row-full">
		<label><?php echo esc_html__( 'Plan ID', 'keedpay-checkout-for-woocommerce' ); ?></label>
		<input type="text"
			   name="kpco_plan_id[<?php echo esc_attr( $loop ); ?>]"
			   value="<?php echo esc_attr( $plan_id ); ?>"
			   placeholder="<?php esc_attr_e( 'Insira o ID do plano', 'keedpay-checkout-for-woocommerce' ); ?>"
			   style="width:100%;" />
	</div>

	<?php 
	wp_nonce_field( 'kpco_save_plan_id', 'kpco_plan_id_nonce' );
	?>
	<?php
}

/**
 * Salva o campo das variações
 */
add_action( 'woocommerce_save_product_variation', 'kpco_save_plan_id_variation_field', 10, 2 );
function kpco_save_plan_id_variation_field( $variation_id, $i ) {
	if ( ! isset( $_POST['kpco_plan_id_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['kpco_plan_id_nonce'] ) ), 'kpco_save_plan_id' ) ) {
		return;
	}

	if ( isset( $_POST['kpco_plan_id'][ $i ] ) ) {
		$plan_id = sanitize_text_field( wp_unslash( $_POST['kpco_plan_id'][ $i ] ) );
		update_post_meta( $variation_id, '_kpco_plan_id', $plan_id );
	}
}
