import {__} from '@wordpress/i18n';
import './view.scss';

const compareSliders = document.querySelectorAll(".juz-dualview");
const compareSlidersShowBeforeAfters = document.querySelectorAll(".juz-dualview__toolbar");

compareSliders.forEach((compareSlider, i) => {
    const input = compareSlider.querySelector(":scope > .juz-dualview__range");
    const before = compareSlider.querySelector(":scope > .juz-dualview__before");
    const after = compareSlider.querySelector(":scope > .juz-dualview__after");
    const showBefore = compareSlidersShowBeforeAfters[i].querySelector(":scope > .juz-dualview__show-before");
    const showAfter = compareSlidersShowBeforeAfters[i].querySelector(":scope > .juz-dualview__show-after");
    const onCompareSliderInputChange = () => {
        const value = input.value;

        compareSlider.style.setProperty(`--pos--juz-dualview`, value + "%");

        // Update ARIA attributes for accessibility
        input.setAttribute('aria-valuenow', value);
        input.setAttribute('aria-valuetext', `${value}%`);

        // Update live regions for screen readers
        before.setAttribute('aria-hidden', value <= 0 ? 'true' : 'false');
        after.setAttribute('aria-hidden', value >= 100 ? 'true' : 'false');
    }
    const onCompareSliderShow = (value) => {
        input.value = value;
        input.dispatchEvent(new Event('input'));
    }

    before.setAttribute('role', 'group');
    after.setAttribute('role', 'group');

    before.setAttribute('aria-label', __("\"Before\" view", 'juz-dualview'));
    after.setAttribute('aria-label', __("\"After\" view", 'juz-dualview'));

    input.oninput = onCompareSliderInputChange;
    showBefore.onclick = () => {onCompareSliderShow(100)};
    showAfter.onclick = () => {onCompareSliderShow(0)};
});
