export const buildDescriptionProperties = ({
                                               backgroundColor,
                                               style,
                                               blockProps
                                           }) => {
    const baseDescriptionClassName = 'juz-dualview__description';
    const backgroundClass = backgroundColor
        ? `has-${backgroundColor}-background-color has-background`
        : '';
    const descriptionClassName = [baseDescriptionClassName, backgroundClass]
        .filter(Boolean)
        .join(' ');

    const descriptionStyle = {
        ...blockProps.style,
        backgroundColor: backgroundColor
            ? undefined
            : style?.color?.background
    };

    return {
        descriptionClassName,
        descriptionStyle
    };
};
