<?php
/**
 * Plugin Name: JuZ DualView
 * Plugin URI: https://juzed.dev/projets/juz-dualview
 * Description: A Gutenberg block to display an easy "Before/After" comparison.
 * Version: 1.0.0
 * Author: Ju'Z[ed]
 * Author URI: https://juzed.dev/
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: juz-dualview
 * Domain Path: /lang
 */

function juz_dualview_register_block() {
    register_block_type( __DIR__ . '/build' );
}

add_action( 'init', 'juz_dualview_register_block' );

function juz_dualview_set_editor_script_translations() {
    $editor_script_handle = generate_block_asset_handle(
        'juzeddev/juz-dualview',
        'editorScript'
    );

    wp_set_script_translations(
        $editor_script_handle,
        'juz-dualview',
        plugin_dir_path( __FILE__ ) . 'lang'
    );

    wp_localize_script(
        $editor_script_handle,
        'juz_dualview_preview',
        [
            'preview_image'      => trailingslashit( plugin_dir_url(__FILE__) ) . 'src/assets/preview.jpg'
        ]
    );
}

add_action( 'enqueue_block_editor_assets', 'juz_dualview_set_editor_script_translations' );

function juz_dualview_set_view_script_translations() {
    $view_script_handle = generate_block_asset_handle(
        'juzeddev/juz-dualview',
        'viewScript'
    );

    wp_set_script_translations(
        $view_script_handle,
        'juz-dualview',
        plugin_dir_path( __FILE__ ) . 'lang'
    );
}

add_action( 'init', 'juz_dualview_set_view_script_translations' );
