<?php
namespace WPJT\Modules;

use WP_Exception;
use WPJT\Classes\JT_Locale;
use WPJT\Classes\JT_Path;

/** @package WPJT\Modules */
class JT {    
    private static $loaded = false;
 
    /** @return void  */
    public static function load (): void {              
        if (is_admin() && self::$loaded)  return;        
        do_action( 'wpjt_before_load' );
        
        $parsed = wp_parse_url( WPJT_SITE_URL );
        $path = isset($parsed['path']) ? $parsed['path'] : '';                
        $query = isset($parsed['query']) ? '?' . $parsed['query'] : '';

        /** jika pathnya kosong, ini adalah home di source */
        if(!$path) return;

        $o_path = JT_Path::get_instance($path);

        /** jika slug tidak standar diredirect */
        if( $o_path->value() !== $path ){        
            wp_redirect(home_url($o_path->value() . $query)); exit;
        }
        
        JT_Locale::set_active_code($o_path->locale_code);
        
        /** jika ini adalah source return */
        if($o_path->is_source) return;

        /** Jika locale code tidak terdaftar di supported language maka return */
        if(!in_array($o_path->locale_code, JT_Locale::get_codes())) return; 

        /** redirect canical */
        if(!$o_path->is_translated(JT_Locale::get_source_code())){
            $redirect_path = JT_Path::get_instance($o_path->value(JT_Locale::get_source_code()));
            if($redirect_path->is_translated($o_path->locale_code)) {
                wp_redirect(home_url($redirect_path->value($o_path->locale_code) . $query)); exit;
            }
        }

        $source_path = $o_path->value(JT_Locale::get_source_code());
        $source_uri = $source_path . $query;        
        
        /** set REQUEST_URI dan PATH_INFO sesuai dengan source path agar dikenali oleh WP request */
        $_SERVER['REQUEST_URI'] = $source_uri;
        $_SERVER['PATH_INFO'] = $source_path;

        add_filter('redirect_canonical', function($redirect_url) use($o_path) {
            if ( !strpos( $redirect_url, site_url() ) === 0 ) return $redirect_url;    

            if($o_path->is_source) return $redirect_url;

            $parsed = wp_parse_url( $redirect_url );
            $path = isset($parsed['path']) ? $parsed['path'] : '';                
            $query = isset($parsed['query']) ? '?' . $parsed['query'] : '';

            $rpath = JT_Path::get_instance($path);
            if($rpath->is_translated($o_path->locale_code)){
                return home_url($rpath->value($o_path->locale_code) . $query);
            }

            return $redirect_url;
        });              
        
        self::$loaded=true;

        do_action( 'wpjt_loaded' );
        
        return;
    } 
    
    /** @return bool  */
    public static function is_loaded(): bool {
        return self::$loaded;
    }

    /**
     * Callback for init action hook: https://developer.wordpress.org/reference/hooks/init/
     * @return void 
     * @throws WP_Exception 
     */
    public static function cb_init_action(): void{
        $uri = isset($_SERVER['REQUEST_URI']) ? sanitize_url( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';    

        wp_register_style('wpjt_translations', WPJT_URL . '/admin/css/translations.css', [], '0.0.1');
        wp_register_style('wpjt_language_switcher', WPJT_URL . '/frontend/css/language-switcher.css', [], '0.0.1');
        
        wp_register_script('wpjt_translations', WPJT_URL . '/admin/js/translations.js', [], '0.0.1', true); 
    }
    
    /** 
     * Callback for template_redirect action hook: https://developer.wordpress.org/reference/hooks/template_redirect/
     * @return void  
     * */
    public static function cb_template_redirect_action(): void {
        if( is_admin() ) return;
        if( !empty( error_get_last() ) ) return;

        // nanti mungkin perlu kondisi tambahan 
        ob_start(function($output){
            $active_code = JT_Locale::get_active_code();                        
            $uri = isset($_SERVER['REQUEST_URI']) ? sanitize_url( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';            
            $html_key = sha1($output);            
            $translated_html = JT_Cache::get_html_cache($uri, $active_code, $html_key);
            
            /** translate header, saat ini baru translate Link */            
            if(!$translated_html){                
                header('Content-Language: ' . $active_code);
                $translated_html = JT_Translator::translate_html($output, $active_code);
                JT_Cache::set_html_cache($uri, $active_code, $translated_html, $html_key);
            }
            
            JT_Translator::html_translate_http_header();            
            return $translated_html;
        });
    } 
}