<?php
/**
 * Plugin Name:       Just Translate
 * Description:       Automatically captures and translates text strings using a custom translation panel with multi-language support.
 * Version:           0.0.10
 * Requires at least: 6.5
 * Requires PHP:      8.1
 * Author:            wpid
 * Author URI:        https://www.wpid.dev/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       just-translate
 */

use WPJT\Helper\JT_Util;

if (!defined('ABSPATH')) exit;

define( 'WPJT_VERSION', '0.0.9' );
define( 'WPJT_PLUGIN_FILE', __FILE__  );
define( 'WPJT_PATH', plugin_dir_path( WPJT_PLUGIN_FILE ) );
define( 'WPJT_URL', plugin_dir_url( WPJT_PLUGIN_FILE ) );

define( 'WPJT_CACHE_DIR', WP_CONTENT_DIR . '/cache/wpjt/' );


// include
require_once WPJT_PATH . 'inc/base.php';
require_once WPJT_PATH . 'admin/base.php';

/** URL asli perlu disimpan karena WPJT akan melakukan manipulasi URL */
define( 'WPJT_SITE_URL', JT_Util::get_current_url());

// action
add_action('plugins_loaded', 'wpjt_run', 999);

register_activation_hook(__FILE__, function(){
    wpjt_setup();
});