<?php

use WPJT\Helper\JT_Util;
use WPJT\Modules\JT;
use WPJT\Modules\JT_Cache;
use WPJT\Modules\JT_Query;
use WPJT\Modules\JT_Settings;
use WPJT\Modules\JT_Table;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

add_action('wpjt_run', function(){    
    if (did_action('wpjt_run') > 1 ) return;

    /** Jalankan saat plugin update*/
    if(WPJT_VERSION > JT_Settings::get_plugin_version()){
        wpjt_setup();
    }    
    
    add_action( 'init', [JT::class, 'cb_init_action'] );
    add_action( 'template_redirect', [JT::class, 'cb_template_redirect_action'] );    
    
    add_action( 'wpjt_load', [JT::class, 'load'] );
    add_filter( 'wpjt_loaded', [JT::class, 'is_loaded'] );
    
    add_shortcode('wpjt_language_switcher', function ($atts) {
        $atts = shortcode_atts([
                'hide_flag' => false,
                'show_name' => false,
                'display_name' => 'lang_native_name',
        ], $atts, 'wpjt_language_switcher' );    
        
        return JT_Util::get_language_switcher($atts);
    });
    
    do_action( 'wpjt_init' );
    do_action( 'wpjt_load' );
});

function wpjt_setup(){
    JT_Table::do_setup();
    JT_Query::set_initial_settings();
    JT_Cache::clear_all();
}

function wpjt_run(){    
    do_action('wpjt_run');
}