<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use WPJT\Classes\JT_Locale;
use WPJT\Modules\JT;
use WPJT\Modules\JT_Settings;


/**
 * Get locale 
 * @param null|string $str_locale 
 * @param null|string $str_display_locale 
 * @return null|JT_Locale 
 */
function wpjt_get_locale( ?string $str_locale = null, ?string $str_display_locale = null ): ?JT_Locale {
    return JT_Locale::get_instance($str_locale, $str_display_locale);
}

/** @return string  */
function wpjt_get_active_locale_code(): string {
    return JT_Locale::get_active_code();
}

/**
 * @param string $locale_code 
 * @return void 
 */
function wpjt_set_active_locale_code(string $locale_code): void{
    JT_Locale::set_active_code($locale_code);
}

/** @return null|string  */
function wpjt_get_browser_locale_code(): ?string{
    return JT_Locale::get_browser_code();
}  


/**
 * @param string $str_locale 
 * @return null|string 
 */
function wpjt_get_locale_code(string $str_locale): ?string{
    return JT_Locale::get_code($str_locale);
}

/**
 * @param array $locale_codes 
 * @return void 
 */
function wpjt_set_locale_codes(array $locale_codes): void{
    JT_Locale::set_codes($locale_codes);
}


/**
 * @param mixed $slug 
 * @return null|string 
 */
function wpjt_get_locale_code_by_slug($slug = null): ?string {
    return JT_Locale::get_code_by_slug($slug);
}


/**
 * @param string $lang 
 * @return null|string 
 */
function wpjt_get_default_country(string $lang): ?string{
    return JT_Settings::get_default_country($lang);
}

/**
 * @param string $lang 
 * @return bool 
 */
function wpjt_get_default_rtl(string $lang): bool{
    return JT_Settings::get_default_rtl($lang);
}

/** @return string[]  */
function wpjt_get_locale_codes(): array {
    return JT_Locale::get_codes();
}

/** @return null|JT_Locale  */
function wpjt_get_source_locale(): ?JT_Locale {
    return JT_Locale::get_source();
}