<?php

use WPJT\Modules\JT_Cache;
use WPJT\Modules\JT_Query;

function wpjt_translation_page() {        
    $source_locale = wpjt_get_source_locale();

    if ( isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['form_translation_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['form_translation_nonce'])), 'form_translation_action')) {
            wp_die('Unauthorized form submission.');
        }        

        if (isset($_POST['wpjt_update']) && isset($_POST['translation'])) {            
            
            $translations = map_deep( wp_unslash( $_POST['translation'] ), 'sanitize_text_field' );
            
            foreach($translations as $key => $ar_translation) {
                foreach($ar_translation as $target_locale_code => $translation){
                    JT_Query::set_translation_string($key, $source_locale->code, $target_locale_code, $translation);
                }
            }            
            echo '<div class="updated"><p>Translations updated.</p></div>';
        } elseif (isset($_POST['wpjt_delete']) && !empty($_POST['delete_keys'])) {  
            // phpcs:ignore 	WordPress.Security.ValidatedSanitizedInput.InputNotSanitized --  sanitized using array_map
            $delete_keys = array_map('sanitize_text_field', array_keys( wp_unslash($_POST['delete_keys']) ));
            JT_Query::delete_string($delete_keys, $source_locale->code);
            echo '<div class="updated"><p>Selected strings deleted.</p></div>';
        }

        JT_Query::clear_html_cache();
        JT_Cache::clear_translated();
    }
    
    if( ( isset($_GET['s']) || isset($_GET['filter_langs']) || isset($_GET['translated']) )
    && ( !isset($_GET['form_filter_nonce']) || !wp_verify_nonce(sanitize_key(wp_unslash($_GET['form_filter_nonce'])), 'form_filter_action') ) ) {    
        wp_die('Unauthorized form submission.');        
    }

    $locale_codes = wpjt_get_locale_codes();
    
    $target_locale_codes = array_filter($locale_codes, fn($e) => $e !== $source_locale->code);

    if(empty($target_locale_codes)){
        wp_die('<p>You must set the target language(s) first!</p><p>Please goto <a href="' . esc_url(admin_url('admin.php?page=string-translation-settings')) . '">Translations > Settings</a></p>');
    }

    $page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $search = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';    
    $filter_locale_codes = isset($_GET['filter_langs']) ? array_map('sanitize_text_field', wp_unslash( $_GET['filter_langs']) ): $target_locale_codes;    
    $show_translated = isset($_GET['translated']) ? true : false;

    $t_list = JT_Query::get_translation_list([
        'page' => $page,
        'search' => $search,
        'filter_langs' => $filter_locale_codes,
        'show_translated' => $show_translated,        
    ]);
    
    wp_enqueue_style('wpjt_translations');
    wp_enqueue_script('wpjt_translations');

    ?>
    <div class="wrap"><h1>Translate Strings</h1>
        <form method="get"><input type="hidden" name="page" value="string-translations" />
            <p><input type="search" name="s" value="<?PHP echo esc_attr($search); ?>" placeholder="Search strings...">
            <label style="margin-left: 8px;"><input type="checkbox" name="translated" value="1"<?php echo ($show_translated ? ' checked' : ''); ?> > Show translated</label>
            <?php if(count($target_locale_codes)> 1) {?>
            <label style="margin-left: 20px;">Languages: 
                <?php
                foreach ($target_locale_codes as $target_locale_code) {
                    echo '<label style="margin: 0 5px;"><input type="checkbox" name="filter_langs[]" value="' . esc_attr($target_locale_code) . '"' . (in_array($target_locale_code, $filter_locale_codes) ? ' checked' : '') . '> ' . esc_html($target_locale_code) . '</label>';
                }
                ?>
            </label>
            <?php } ?>
            </label> 
            
            <?php wp_nonce_field('form_filter_action', 'form_filter_nonce'); ?>
            <button style="margin-left: 20px;" class="button">Filter</button></p>
        </form>

        <form method="post" enctype="multipart/form-data">
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th style="width:1.5em;">
                            <input type="checkbox" onclick="jQuery('.delete-box').prop('checked', this.checked)">
                        </th>
                        <th style="width:35%;">
                            Source String / <?php echo esc_html($source_locale->lang_name . ' (' . $source_locale->code . ')') ?>
                        </th>
                        <th>
                            Translations
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if(isset($t_list['strings'])) {
                    foreach ($t_list['strings'] as $key => $value) {
                        echo '<tr>';
                            echo '<td><input type="checkbox" class="delete-box" name="delete_keys[' . esc_attr($key) . ']"></td>';
                            echo '<td><div class="wpjt-string">' . esc_html($value['string']) . '</div></td>';
                            echo '<td>';
                            foreach ($value['translations'] as $target_locale_code => $translation) {
                                $locale = wpjt_get_locale($target_locale_code);
                                echo '<div style="display: flex;justify-content: space-between; padding:4px 0;">';
                                echo '<label style="width:15%; min-width: 80px;" for="' . esc_attr($key . $locale->code) . '">' . esc_html($locale->lang_name . ' (' . $locale->code . ')') . '</label>';
                                echo '<textarea name="translation[' . esc_attr($key) . '][' . esc_attr($target_locale_code) . ']" id="' . esc_attr($key . $target_locale_code) . '" rows="2" style="width:84%">' . esc_textarea($translation) . '</textarea>';
                                echo '</div>';
                            }
                            echo '</td>';
                        echo '</tr>';
                    }

                    }
                    ?>
                </tbody>
            </table>
            <?php wp_nonce_field('form_translation_action', 'form_translation_nonce'); ?>
            <p>
                <input type="submit" name="wpjt_update" class="button-primary" value="Save Translations">
                <input type="submit" name="wpjt_delete" class="button" value="Delete Selected" onclick="return confirm('Are you sure you want to delete selected strings?')">
            </p>
        </form>
        <?php
        $total = isset($t_list['total']) && isset($t_list['per_page']) ? ceil($t_list['total'] / $t_list['per_page']):0;
        $current = isset($t_list['page']) ? $t_list['page'] : 1;
        $page_links = paginate_links([
            'base' => add_query_arg('paged', '%#%'),
            'format' => '',
            'prev_text' => '&laquo;',
            'next_text' => '&raquo;',
            'total' => $total,
            'current' => $current
        ]);
        if ($page_links) echo '<div class="tablenav"><div class="tablenav-pages">' . wp_kses_post($page_links) . '</div></div>'; 
        ?>
    </div>

    <?php
}