<?php

use WPJT\Classes\JT_Locale;

function wpjt_translation_settings_page() {  
    if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['wpjt_settings_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wpjt_settings_nonce'])), 'wpjt_settings_action')) {
            wp_die('Unauthorized form submission.');
        } 

        if (isset($_POST['languages']) && is_array($_POST['languages'])) {
            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized --  sanitized using array_map
            $langs = array_map('sanitize_text_field', array_filter(wp_unslash($_POST['languages'])));
            JT_Locale::set_codes($langs);
        } else {
            JT_Locale::set_codes([]);
        }
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }

    $supported_locales = wpjt_get_locale_codes();

    $str_locales = ['id-ID', 'en-US', 'en-GB', 'es-ES', 'zh-CN', 'hi-IN', 'ar-SA', 'pt-BR', 'ru-RU', 'ja-JP', 'de-DE', 'fr-FR', 'ko-KR', 'it-IT','tr-TR', 'nl-NL', 'th-TH'
    , 'vi-VN', 'ms-MY', 'pl-PL', 'uk-UA', 'fa-IR', 'bn-BD', 'ta-IN', 'ur-PK', 'fil-PH', 'sv-SE', 'fi-FI', 'da-DK', 'no-NO', 'hu-HU', 'cs-CZ', 'ro-RO', 'el-GR',];

    $str_locales = apply_filters('wpjt_setting_locales', $str_locales); // gunakan filter jika ada
    $str_locales = array_merge($str_locales, $supported_locales); // pastikan supported ada di list

    /** pastikan locale valid dan bukan default language*/
    $str_locales = array_filter($str_locales, function($str_locale) {        
        return !( wpjt_get_locale($str_locale) === null ||  wpjt_get_locale($str_locale)->is_source );
    });     

    /** agar farmat locale seragam */
    $str_locales = array_map(function($locale) {
        return wpjt_get_locale($locale)->code;
    }, $str_locales);

    $str_locales = array_unique($str_locales); // patiskan unique

    // sort locales by Name
    usort($str_locales, function ($a, $b) {
        return wpjt_get_locale($a, JT_Locale::get_active_code())->name <=> wpjt_get_locale($b, JT_Locale::get_active_code())->name; 
    });     
            
    $source_locale = wpjt_get_source_locale();
    echo '<div class="wrap"><h1>Translation Settings</h1>';
    echo '<h2>Source Language:</h2>';
    echo '<p style="margin-bottom:2rem;">';
    // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage --  dynamic image based on locale
    echo '<img src="' . esc_url($source_locale->flag ?? '#') . '" style="width:22px; vertical-align:middle; margin-right:4px;">' . esc_html($source_locale->name);
    echo ' | <a href="' . esc_url(admin_url('options-general.php#WPLANG')) . '">Change source language</a>';
    echo '</p>';

    echo '<form method="post">';
    wp_nonce_field('wpjt_settings_action', 'wpjt_settings_nonce'); 
    echo '<h2>Target Languages:</h2><div style="display: flex; flex-direction: column; flex-wrap: wrap; height: 26em; width: 800px;">';

    foreach ($str_locales as $str_locale) {
        $locale = wpjt_get_locale($str_locale);
        $checked = in_array($locale->code, $supported_locales) ? 'checked' : '';

        echo '<label style="margin-right: 12px; display: inline-block; margin-bottom: 6px;">';            
            echo '<input type="checkbox" name="languages[]" value="' . esc_attr($locale->code)  . '" ' . esc_attr($checked)  . '>';
            // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage --  dynamic image based on locale
            echo '<img src="' . esc_url($locale->flag ?? '#') . '" style="width:22px; vertical-align:middle; margin-right:4px;">' . esc_html($locale->name);
        echo "</label> ";
    }
    echo '</div>';
    echo '<p><input type="submit" class="button-primary" value="Save Settings"></p>';
    echo '</form></div>';    
}