document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.wpjt-string').forEach(div => {
        div.addEventListener('click', () => {
            const text = div.innerText;

            navigator.clipboard.writeText(text).then(() => {
                div.classList.add('copied');

                // Hapus tooltip setelah 1.5 detik
                setTimeout(() => {
                    div.classList.remove('copied');
                }, 1500);
            }).catch(err => {
                console.error('Failed to copy:', err);
            });
        });
    });
});