<?php
/*
Plugin Name: Junk Header Remover for WordPress
Plugin URI: https://github.com/avocadowebservices/junk-header-remover
Description: Removes unnecessary clutter, meta, and scripts from the WordPress <head> for faster, cleaner pages.
Version: 1.0.1
Author: Joseph Brzezowski / AvocadoWeb Services LLC
Author URI: https://github.com/avocadowebservices
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

if (!defined('ABSPATH')) {
    exit;
}

function aw_remove_junk_headers() {
    // Classic junk
    remove_action('wp_head', 'rsd_link');
    remove_action('wp_head', 'wp_generator');
    remove_action('wp_head', 'feed_links', 2);
    remove_action('wp_head', 'feed_links_extra', 3);
    remove_action('wp_head', 'index_rel_link');
    remove_action('wp_head', 'wlwmanifest_link');
    remove_action('wp_head', 'start_post_rel_link', 10, 0);
    remove_action('wp_head', 'parent_post_rel_link', 10, 0);
    remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
    remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
    remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

    // Modern WP junk
    remove_action('wp_head', 'rest_output_link_wp_head', 10);
    remove_action('wp_head', 'wp_oembed_add_discovery_links', 10);
    remove_action('wp_head', 'wp_oembed_add_host_js');
    remove_action('wp_head', 'wp_resource_hints', 2);
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('wp_print_styles', 'print_emoji_styles');
    remove_action('template_redirect', 'wp_shortlink_header', 11);

    // Remove global styles (Gutenberg)
    remove_action('wp_head', 'wp_enqueue_global_styles', 1);
}
add_action('init', 'aw_remove_junk_headers');

// Disable XML-RPC completely
add_filter('xmlrpc_enabled', '__return_false');

// Remove X-Pingback from HTTP headers
add_filter('wp_headers', function($headers) {
    unset($headers['X-Pingback']);
    return $headers;
});

// Optionally turn off "expose_php"
@ini_set('expose_php', 'off');
