# Translation Files

This directory contains translation files for Pixengine plugin.

## Text Domain

`jprompts-pixengine`

## Generating POT File

To generate the translation template file:

```bash
wp i18n make-pot . languages/jprompts-pixengine.pot
```

Or using the WP-CLI Docker image:

```bash
docker run -it --rm -v $(pwd):/app -w /app wordpress:cli i18n make-pot . languages/jprompts-pixengine.pot
```

## Translating

1. Use Poedit or similar tool to create .po file from .pot template
2. Translate all strings
3. Generate .mo file
4. Place both .po and .mo files in this directory
5. Name format: `jprompts-pixengine-{locale}.po` and `jprompts-pixengine-{locale}.mo`

Example:
- `jprompts-pixengine-de_DE.po` (German)
- `jprompts-pixengine-de_DE.mo` (German)
- `jprompts-pixengine-fr_FR.po` (French)
- `jprompts-pixengine-fr_FR.mo` (French)

## Contributing Translations

To contribute translations:

1. Create translation files as described above
2. Test in WordPress with your locale
3. Submit via GitHub pull request or email to support@j-prompt.com

## Translation Stats

WordPress.org will show translation progress for approved languages.

Visit: https://translate.wordpress.org/projects/wp-plugins/jprompts-pixengine/
