# JPrompt's Pixengine - Image Converter & Optimizer

![WordPress Plugin Version](https://img.shields.io/badge/version-1.0.0-blue.svg)
![WordPress Compatibility](https://img.shields.io/badge/wordpress-5.8%2B-brightgreen.svg)
![PHP Version](https://img.shields.io/badge/php-7.4%2B-purple.svg)
![License](https://img.shields.io/badge/license-GPLv2%2B-orange.svg)

**Automatically convert and optimize images to WebP format with intelligent resizing. Boost page speed by 40-70% with superior compression.**

## 🚀 Features

### Automatic Conversion
- ✅ Auto-convert JPG and PNG uploads to WebP
- ✅ Smart resizing for images over 1920px width
- ✅ Maintains aspect ratio automatically
- ✅ Preserves transparency for PNG images
- ✅ Converts all WordPress thumbnail sizes

### Superior Compression
- ✅ Uses Imagick (when available) for best compression
- ✅ Strips unnecessary metadata (EXIF, profiles)
- ✅ Optimized WebP settings for 40-70% file size reduction
- ✅ Fallback to GD library with optimization
- ✅ Configurable quality control (recommended: 70-80)

### Bulk Conversion
- ✅ Convert existing media library images
- ✅ Keeps original files for compatibility
- ✅ Automatic .htaccess configuration
- ✅ Browser-based WebP delivery
- ✅ Real-time progress tracking with detailed logging

### Free Plan
- 🆓 500 image conversions per month
- ✅ All core features included
- ⬆️ Upgrade to Pro for unlimited conversions

## 📊 Performance Benefits

| Metric | Improvement |
|--------|-------------|
| File Size | 40-70% reduction |
| Page Load Time | 30-50% faster |
| Bandwidth Usage | 40-70% less data |
| Core Web Vitals | Significant improvement |
| SEO Rankings | Better performance scores |

## 🛠️ Installation

### Automatic Installation
1. Log in to your WordPress admin panel
2. Go to **Plugins > Add New**
3. Search for "Pixengine"
4. Click **Install Now** and then **Activate**
5. Go to **Settings > Pixengine** to configure

### Manual Installation
1. Download the plugin ZIP file
2. Go to **Plugins > Add New > Upload Plugin**
3. Select the ZIP file and click **Install Now**
4. Activate the plugin
5. Navigate to **Settings > Pixengine**

## ⚙️ Configuration

### Basic Setup
1. Go to **Pixengine** in your admin menu
2. Set your preferred quality (recommended: 75)
3. Set maximum width (default: 1920px)
4. Save settings

### Bulk Convert Existing Images
1. Go to **Settings > Pixengine**
2. Click **Start Bulk Conversion**
3. Wait for conversion to complete
4. Original files are kept alongside WebP versions

## 📋 System Requirements

- **WordPress:** 5.8 or higher
- **PHP:** 7.4 or higher
- **Image Library:** GD with WebP support OR Imagick extension
- **Server:** Apache with mod_rewrite (for .htaccess rules)

### Checking WebP Support
The plugin will automatically detect if your server supports WebP. If not supported, you'll see an admin notice with instructions.

## 🎯 How It Works

### New Uploads (Automatic)
```
1. User uploads JPG/PNG image
2. WordPress generates all thumbnail sizes
3. Pixengine converts original to WebP
4. All thumbnails converted to WebP
5. Original files deleted (saves storage)
6. WebP files replace originals
```

### Existing Images (Bulk Conversion)
```
1. User clicks "Start Bulk Conversion"
2. Plugin finds all JPG/PNG in media library
3. Creates WebP versions alongside originals
4. Originals kept for compatibility
5. .htaccess configured for automatic delivery
6. Supporting browsers get WebP, others get original
```

## 📐 Technical Details

### Compression Methods

**Primary (Imagick):**
- Method 6 compression (best quality)
- Lossy compression for better file sizes
- Alpha quality 100 (perfect transparency)
- Auto-filter optimization
- Metadata stripping

**Fallback (GD Library):**
- Alpha blending optimization
- Transparency preservation
- Quality-based compression
- Configurable settings

### File Size Examples

| Original Format | Original Size | WebP Size | Reduction |
|----------------|---------------|-----------|-----------|
| JPEG Photo (1000px) | 200 KB | 60-80 KB | 60-70% |
| PNG Graphic (800px) | 150 KB | 45-60 KB | 60-70% |
| Large JPEG (2500px) | 800 KB | 120-160 KB | 80-85% |

## 🔌 API & Hooks

### Actions
```php
// Before image conversion
do_action('pixengine_before_conversion', $file_path);

// After image conversion
do_action('pixengine_after_conversion', $webp_path, $original_path);
```

### Filters
```php
// Modify WebP quality
add_filter('pixengine_webp_quality', function($quality) {
    return 70; // Custom quality
});

// Modify max width
add_filter('pixengine_max_width', function($width) {
    return 2560; // Custom max width
});

// Skip conversion for specific images
add_filter('pixengine_should_convert', function($should_convert, $file_path) {
    if (strpos($file_path, 'no-convert') !== false) {
        return false;
    }
    return $should_convert;
}, 10, 2);
```

## 🌍 Browser Support

| Browser | WebP Support | Fallback |
|---------|-------------|----------|
| Chrome | ✅ Full | - |
| Firefox | ✅ Full | - |
| Edge | ✅ Full | - |
| Safari 14+ | ✅ Full | - |
| Opera | ✅ Full | - |
| IE 11 | ❌ No | JPG/PNG |
| Safari <14 | ❌ No | JPG/PNG |

## 🐛 Troubleshooting

### Images not converting
1. Check if WebP is supported: Settings > Pixengine
2. Verify file permissions on uploads directory
3. Check PHP error logs for issues
4. Test with Imagick disabled (force GD)

### Bulk conversion fails
1. Increase PHP max_execution_time
2. Increase PHP memory_limit
3. Reduce batch size in code
4. Check server disk space

### .htaccess not working
1. Verify mod_rewrite is enabled
2. Check .htaccess file permissions
3. Ensure AllowOverride is enabled
4. Test with simple rewrite rule

## 📞 Support

Community support via [WordPress.org Forums](https://wordpress.org/support/plugin/jprompts-pixengine/).

## 📄 License

This plugin is licensed under the GPLv2 or later.

## 🏆 Credits

Developed by JPrompt.

## 🔮 Roadmap

### Version 1.1
- [ ] AVIF format support
- [ ] Advanced caching integration
- [ ] Lazy loading integration
- [ ] Responsive image optimization

### Version 1.2
- [ ] Cloud storage integration (S3, CloudFlare)
- [ ] CLI commands for bulk operations
- [ ] Advanced analytics dashboard

## ⚠️ Important Notes

1. **Backup your site** before bulk converting existing images
2. **Test on staging** before deploying to production
3. **Check browser compatibility** if serving older audiences
4. **Monitor disk space** when keeping original files

## 🔒 Privacy

This plugin:
- ❌ Does NOT collect personal data
- ❌ Does NOT send images to external servers
- ❌ Does NOT use cookies
- ❌ Does NOT track users
- ❌ Does NOT make any external API calls
