<?php 
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$joocart_request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';
$joocart_query_string = isset($_SERVER['QUERY_STRING']) ? sanitize_text_field(wp_unslash($_SERVER['QUERY_STRING'])) : ''; 
if(isset($joocart_request_uri) && strstr($joocart_request_uri,"?") && (!isset($joocart_query_string) || trim($joocart_query_string)=="")){
	$joocart_queystring=explode("?",$joocart_request_uri,2);
	$joocart_queystring=$joocart_queystring[1];
	parse_str($joocart_queystring,$joocart_atts);
	if(is_array($joocart_atts)){
		foreach($joocart_atts as $joocart_key=>$joocart_value){
			if(isset($joocart_value) && $joocart_value!="") {
				$_GET[$joocart_key]=$joocart_value;
				$_REQUEST[$joocart_key]=$joocart_value;
			}
		}
	}	
}

// Add actions for ajax
global $joocart_global_admin_content;
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'page' is used for routing, not form processing
$joocart_page = isset($_GET['page']) ? sanitize_key(wp_unslash($_GET['page'])) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'page_id' is used for routing, not form processing
$joocart_page_id = isset($_GET['page_id']) ? sanitize_key(wp_unslash($_GET['page_id'])) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'route' is used for routing, not form processing
$joocart_route = isset($_REQUEST['route']) ? sanitize_text_field(wp_unslash($_REQUEST['route'])) : '';

if (is_admin() && ((isset($joocart_page) && strstr($joocart_page,"joocart") && !strstr($joocart_page,"joocart_options_page")) || (isset($joocart_route) && strstr($joocart_route,"/")))) {
	add_action('init', 'joocart_admin_main_init');	
}
// declare variables for joocart meta data,title and joocart main output
global $joocart_title,$joocart_description,$joocart_keywords,$joocart_global_main_content,$joocart_meta_links;
$joocart_title="";
$joocart_description="";
$joocart_keywords="";

if(!is_admin())
add_action('template_redirect', 'joocart_frontend_main');

// Add actions for admins and frontend
require_once(dirname(__FILE__).'/joocart_functions.php');
require_once(dirname(__FILE__).'/joocart_frontend_functions.php');
require_once(dirname(__FILE__).'/admin/joocart_admin_functions.php');
if( !is_admin() ) {
	add_filter('rewrite_rules_array','joocart_frontend_rewrite' );
	add_filter('query_vars','joocart_frontend_query_vars' );
	add_filter('wp_title', 'joocart_frontend_title');
	add_filter('redirect_canonical', 'joocart_redirect_canonical', 10, 2);
	add_action('wp_loaded','joocart_flush_rules' );
	add_action('wp_head','joocart_add_metadata');		
		
	add_shortcode('joocart_main_content','joocart_show_main_content');
}

if(!is_admin() && isset($joocart_route) && $joocart_route != "" && !isset($joocart_page_id) && get_option("joocart_shop_page_id") != "" && strstr($joocart_route,"/"))
$_REQUEST["page_id"]=$_GET["page_id"]=get_option("joocart_shop_page_id");

// Adding rewrite rules
function joocart_frontend_rewrite( $rules ) {	    
	$post_info=get_post(get_option("joocart_shop_page_id"));
	$post_name=$post_info->post_name;	
	$newrules = array();
	$newrules['^([^?]*)'.$post_name.'\/([^?]*)'] =  'index.php?page_id='.get_option("joocart_shop_page_id").'&_route_=$matches[2]';
	//$newrules['^([^?]*)'.$post_name] =  'index.php?page_id='.get_option("joocart_shop_page_id").'&_route_=home';
	return $newrules + $rules;	
}

// Adding the _route_ var so that WP recognizes it
function joocart_frontend_query_vars( $vars ){
    array_push($vars, '_route_');
	return $vars;
}

// flush_rules() if our rules are not yet included
function joocart_flush_rules(){
	$rules = get_option( 'rewrite_rules' );
	$post_info=get_post(get_option("joocart_shop_page_id"));
	$post_name=$post_info->post_name;	
	if (!isset($rules['^([^?]*)'.$post_name.'\/([^?]*)'])) {
		global $wp_rewrite;
	   	$wp_rewrite->flush_rules();
	}
}

// changing wordpress title 
function joocart_frontend_title($title){
	global $joocart_title;	
	if(defined("JOOCART_IN_MAIN_PAGE") && $joocart_title!="" && $title != ""){
		return $joocart_title." | ".$title;
	}
	elseif(defined("JOOCART_IN_MAIN_PAGE") && $joocart_title!=""){
		return $joocart_title . " | ";
	}
	else
		return $title;	
}

// changing redirection in frontpage
function joocart_redirect_canonical($redirect_url, $requested_url){
    if(is_front_page() && get_option('page_on_front') == get_option("joocart_shop_page_id"))
        return $requested_url;
    else
        return $redirect_url;
}


// add meta data to wordpress
function joocart_add_metadata(){
	if(defined("JOOCART_IN_MAIN_PAGE")){
		global $joocart_title,$joocart_description,$joocart_keywords,$joocart_meta_links;
		$meta_data_arr=array();
		$meta_data_arr[]='';
		// $meta_data_arr[]='<title>'.$title.'</title>';
		if($joocart_title!="")
		$meta_data_arr[]='<meta name="title" content="'.$joocart_title.'" />';
		if(isset($joocart_description) && $joocart_description!="")
		$meta_data_arr[]='<meta name="description" content="'.$joocart_description.'" />';
		if(isset($joocart_keywords) && $joocart_keywords!="")
		$meta_data_arr[]='<meta name="keywords" content="'.$joocart_keywords.'" />';
		if(isset($joocart_meta_links) && $joocart_meta_links!="")
		$meta_data_arr[]=$joocart_meta_links;
		$meta_data_arr[]='';
		if(function_exists('joocart_output_oc'))
		joocart_output_oc(implode("\n",$meta_data_arr));
	}
}
// check joocart admin previlige
function joocart_admin_check_previlige(){
	if(!is_admin())
	wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'joocart'));
	
	if(get_option("joocart_who_can_access_admin")=="subscriber")
		$joocart_access_previlige="read";
	elseif(get_option("joocart_who_can_access_admin")=="contributor")
		$joocart_access_previlige="edit_posts";
	elseif(get_option("joocart_who_can_access_admin")=="author")
		$joocart_access_previlige="publish_posts";
	elseif(get_option("joocart_who_can_access_admin")=="editor")
		$joocart_access_previlige="publish_pages";
	else
		$joocart_access_previlige="manage_options";
		
	if(!current_user_can($joocart_access_previlige)){
		wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'joocart'));
	}
}

// joocart frontend main function
function joocart_frontend_main(){
	// get shop page post information
	$post_info=get_post(get_option("joocart_shop_page_id"));
	$post_name=$post_info->post_name;
	// get current post information
	global $post;
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'route' is used for routing, not form processing
	$joocart_route = isset($_REQUEST['route']) ? sanitize_text_field(wp_unslash($_REQUEST['route'])) : '';
	if(isset($post) && has_shortcode($post->post_content, 'joocart_main_content') || get_option("joocart_shop_page_id")==get_query_var('page_id') || $post_name==get_query_var('name') || (isset($joocart_route) && strstr($joocart_route,"/") && !get_query_var('page_id'))){
		if(!defined('JOOCART_IN_MAIN_PAGE'))
		define('JOOCART_IN_MAIN_PAGE','Yes');
		require_once(dirname(__FILE__).'/joocart_frontend.php');	
	} //check joocart_pages shortcode with attributes and store output to global variable joocart_global_main_content
	
}
// show joocart_global_main_content in shop page using joocart_main_content shortcode
function joocart_show_main_content(){
	global $joocart_global_main_content;
	if(isset($joocart_global_main_content))
	return $joocart_global_main_content;
}


?>