<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//start JooCart Base class
class JooCartBase {		
	// Start Common functions	
	// redirect function for JooCart Controller URL
	public static function redirectControllerUrl($url, $status = 302){
		if( is_admin() ) {
			$url=str_replace("index.php?user_token=","admin.php?page=joocart&user_token=",$url);
			$url=str_replace("index.php?route=","admin.php?page=joocart&route=",$url);
		}
		else{				
			if(defined("JOOCART_PAGE_ID_PARAM"))
				$url=str_replace("index.php?user_token=","index.php?".JOOCART_PAGE_ID_PARAM."user_token=",$url);			
			
			if(defined("JOOCART_PAGE_ID_PARAM"))
				$url=str_replace("index.php?route=","index.php?".JOOCART_PAGE_ID_PARAM."route=",$url);			
		}
		$url=str_replace("&amp;page=","&amp;pages=",$url);
		$url=str_replace("&page=","&pages=",$url);
		$url=str_replace("pages=joocart","page=joocart",$url);
		if (!headers_sent()){	
			@header('Location: ' . str_replace(array('&amp;', "\n", "\r"), array('&', '', ''), $url), true, '302');		
		}
		
	}
	// redirect function for JooCart Controller URL
	public static function redirectResponseUrl($url){
		if( is_admin() && !(defined("HTTP_CATALOG") && strstr($url, HTTP_CATALOG . "index.php?")) ) {
			$url=str_replace("index.php?user_token=","admin.php?page=joocart&user_token=",$url);
			$url=str_replace("index.php?route=","admin.php?page=joocart&route=",$url);
		}
		else{
			if(defined("JOOCART_PAGE_ID_PARAM"))
				$url=str_replace("index.php?user_token=","index.php?".JOOCART_PAGE_ID_PARAM."user_token=",$url);
						
			if(defined("JOOCART_PAGE_ID_PARAM"))
				$url=str_replace("index.php?route=","index.php?".JOOCART_PAGE_ID_PARAM."route=",$url);			
		}
		$url=str_replace("&amp;page=","&amp;pages=",$url);
		$url=str_replace("&page=","&pages=",$url);
		$url=str_replace("pages=joocart","page=joocart",$url);
		
		if (!headers_sent()){	
			@header('Location: ' . str_replace(array('&amp;', "\n", "\r"), array('&', '', ''), $url), true, '302');		
		}
		
	}
	
	// JooCart URL Link function
	public static function urlWoorCartLink($url, $route){
		if( is_admin() ) {
			/*if(defined("JOOCART_PAGE_ID_PARAM"))
				$url .= 'admin.php?page=joocart&amp;'.str_replace("&","&amp;",JOOCART_PAGE_ID_PARAM).'route=' . $route;
			else*/
				$url .= 'admin.php?page=joocart&amp;route=' . $route;
		}
		else{
			if(defined("JOOCART_PAGE_ID_PARAM"))
				$url .= 'index.php?'.str_replace("&","&amp;",JOOCART_PAGE_ID_PARAM).'route=' . $route;
			else
				$url .= 'index.php?route=' . $route;
		}
		
		if(strstr($url,"route=checkout/success"))
			$url = str_replace("&amp;","&",$url);
			
		return $url;
	}
	// function for wordpress admin login integration
	public static function adminLoginIntegration($_class){
		if(isset($_class->request->get["pages"])){
			$_class->request->get["page"]=$_class->request->get["pages"];
			unset($_class->request->get["pages"]);
		}
		return $_class->request->get;
	}	
	// End Common functions
}
//end JooCart Base class
?>