<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//start JooCart Frontend Base class
class JooCartFrontendBase {	
	// Start Frontend functions
	//add extra code to column_left.php file	
	public static function addCodeToColumnLeft($layout_id, $_class){
		$module_data = array();
		$extensions = $_class->model_setting_extension->getExtensions('module');		
		
		foreach ($extensions as $extension) {
			$modules = $_class->config->get($extension['code'] . '_module');
			$extension['sort_order']=isset($extension['sort_order'])?$extension['sort_order']:0;
			if ($modules) {
				foreach ($modules as $module) {
					if (($module['status'] && (!defined("JOOCART_IN_MAIN_PAGE") || !defined("JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN") || JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN=="1")) || ($module['layout_id'] == $layout_id && $module['position'] == 'column_left' && $module['status'])) {
						$module_data[] = array(
							'code'       => $extension['code'],
							'setting'    => $module,
							'sort_order' => $module['sort_order']
						);
					}				
				
				}
			}
			if ($_class->config->get($extension['code'] . '_status') && ($_class->config->get($extension['code'] . '_position') == 'left' || (($_class->config->get($extension['code'] . '_position') == 'home' || $_class->config->get($extension['code'] . '_position') == 'right') && (!defined("JOOCART_IN_MAIN_PAGE") || !defined("JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN") || JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN=="1")))) {
				
						$module_data[] = array(
							'code'       => $extension['code'],
							'setting'    => $extension,
							'sort_order' => $extension['sort_order']
						);				
				
				
			}
		}
		return $module_data;
	}
	
	//add extra code to column_right.php file	
	public static function addCodeToColumnRight($layout_id, $_class){
		$module_data = array();
		$extensions = $_class->model_setting_extension->getExtensions('module');		
		
		foreach ($extensions as $extension) {
			$modules = $_class->config->get($extension['code'] . '_module');
			$extension['sort_order']=isset($extension['sort_order'])?$extension['sort_order']:0;
			if ($modules) {
				foreach ($modules as $module) {
					if ($module['layout_id'] == $layout_id && $module['position'] == 'column_right' && $module['status']) {
						$module_data[] = array(
							'code'       => $extension['code'],
							'setting'    => $module,
							'sort_order' => $module['sort_order']
						);				
					}
				}
			}
			if ($_class->config->get($extension['code'] . '_status') && $_class->config->get($extension['code'] . '_position') == 'right') {
						$module_data[] = array(
							'code'       => $extension['code'],
							'setting'    => $extension,
							'sort_order' => $extension['sort_order']
						);				
			}
		}
		return $module_data;
	}
	
	// fucntion for getting footer children array
	public static function getFooterChildrenArray(){
		$children =  array(
			'module/language',
			'module/currency',
		);
		return $children;
	}
	
	// fucntion for getting header children array
	public static function getHeaderChildrenArray(){
		$children = array(
			'module/language',
			'module/currency',
			'module/cart',
			'module/header',
			'module/footer',
			'common/content_top',
		);
		return $children;
	}	
	// End Frontend functions
}
//end JooCart Frontend Base class
?>