<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'route' is used for routing, not form processing
if(!isset($_GET["route"]) && isset($_REQUEST["route"])) {
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'route' is used for routing, not form processing
	$_GET["route"]=sanitize_text_field(wp_unslash($_REQUEST["route"]));
}

if(file_exists(JOOCART_PLUGIN_DIR . 'config.php')) {
	require_once(JOOCART_PLUGIN_DIR . 'config.php');
}
if(defined("JOOCART_OPENCART_DIR") && file_exists(JOOCART_PLUGIN_DIR . 'index.php') && file_exists(JOOCART_OPENCART_DIR . 'index.php')) {
	$prevcurdir=getcwd();
	ob_start();
	chdir(JOOCART_OPENCART_DIR);
	require_once(JOOCART_PLUGIN_DIR . 'index.php');
	$output = ob_get_contents();
	ob_end_clean();
	chdir($prevcurdir);
}
global $joocart_replace_output_array;
foreach($joocart_replace_output_array as $key=>$value){
	if(defined("JOOCART_SITE_URL") && defined("HTTP_SERVER") && HTTP_SERVER!=JOOCART_SITE_URL && (!defined("JOOCART_REDIRECT_HTTP_SERVER") || JOOCART_REDIRECT_HTTP_SERVER != "Yes"))
	$value=str_replace(JOOCART_SITE_URL,HTTP_SERVER,$value);
	
	$output=str_replace($key,$value,$output);			
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'tmpl' is used for routing, not form processing
if(isset($_REQUEST['tmpl']) && sanitize_key(wp_unslash($_REQUEST['tmpl']))=="component"){
		joocart_output_oc($output);
		exit();
}
else{
	global $joocart_global_main_content;
	$joocart_global_main_content=$output;
}

?>