<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
joocart_admin_check_previlige();
if(defined( 'ABSPATH' )){
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'upgn' is used for routing, not form processing
	$upgn = isset($_REQUEST['upgn']) ? sanitize_text_field(wp_unslash($_REQUEST['upgn'])) : '';
	if(isset($upgn) && $upgn=="install/delete" && file_exists(JOOCART_PLUGIN_DIR . "install/index.php")) {	
		if(is_dir(JOOCART_PLUGIN_DIR . "install")) {
			if(!function_exists("joocart_del_tree")){
				function joocart_del_tree($dir) {
					$files = array_diff(scandir($dir), array('.','..'));
					foreach ($files as $file) {
					  (is_dir("$dir/$file")) ? joocart_del_tree("$dir/$file") : unlink("$dir/$file");
					}
					global $wp_filesystem;
					WP_Filesystem();
					return $wp_filesystem->rmdir($dir);
					// return rmdir($dir);
				} 
			}
			joocart_del_tree(JOOCART_PLUGIN_DIR . "install");
		}
	}
	//if click to upgrade link then include upgrade file
    if(isset($upgn) && file_exists(JOOCART_PLUGIN_DIR."".$upgn.".php")){
		ob_start();
		require_once(JOOCART_PLUGIN_DIR.$upgn.".php");
		$output = ob_get_contents();
		ob_end_clean();
		global $joocart_global_admin_content;
		$joocart_global_admin_content=$output;
	}//checking upgrade installtion folder uploaded or not.If yes,then upgrade link will be visible
	elseif(file_exists(JOOCART_PLUGIN_DIR."install/upgrade.php")){
		$upgn = "install/upgrade";
		ob_start();
		require_once(JOOCART_PLUGIN_DIR.$upgn.".php");
		$output = ob_get_contents();
		ob_end_clean();
		global $joocart_global_admin_content;
		$joocart_global_admin_content=$output;
	}
	else{
		//checking upgrade installtion folder uploaded or not.If Not,then include JooCart  ouptput using obstart.
		if(file_exists(JOOCART_PLUGIN_DIR . 'admin/config.php')) {
			require_once(JOOCART_PLUGIN_DIR . 'admin/config.php');
		}
		//check token
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'user_token' is used for routing, not form processing
		$joocart_user_token = isset($_REQUEST['user_token']) ? sanitize_text_field(wp_unslash($_REQUEST['user_token'])) : '';
		
		if(isset($joocart_user_token))
			$_SESSION["user_token"]=$joocart_user_token;
		if(isset($_SESSION["user_token"])&&!isset($joocart_user_token))
			$_GET["user_token"]=sanitize_text_field(wp_unslash($_SESSION["user_token"]));

		//echo opencart output in wordpress
		global $joocart_replace_outputs_array;
		if(defined("JOOCART_OPENCART_DIR") && !file_exists(JOOCART_OPENCART_DIR . 'index.php')){
			$output = '<br/><h2>OpenCart files not found. So upload opencart files in ' . JOOCART_OPENCART_DIR . ' folder or change default "OpenCart Directory Path" from <a href="options-general.php?page=joocart_options_page">JooCart Options</a></h2>';
		} elseif(!defined("DIR_MODIFICATION") || !file_exists(DIR_MODIFICATION . 'system/startup.php')) {
			$output = '<br/><h2>Save your JooCart Settings again from here <a href="options-general.php?page=joocart_options_page">JooCart Options</a></h2>';
		} elseif(defined("JOOCART_OPENCART_DIR") && file_exists(JOOCART_OPENCART_DIR . 'admin/index.php')) {
			$prevcurdir=getcwd();
			ob_start();
			chdir(JOOCART_OPENCART_DIR.'admin');
			if(file_exists(JOOCART_PLUGIN_DIR . 'admin/index.php'))
			require_once(JOOCART_PLUGIN_DIR . 'admin/index.php');
			$output = ob_get_contents();
			ob_end_clean();
			chdir($prevcurdir);
		}
		if(isset($joocart_replace_outputs_array) && $joocart_replace_outputs_array) {
			foreach($joocart_replace_outputs_array as $key=>$value){
				$output=str_replace($key,$value,$output);
			}
		}
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'tmpl' is used for routing, not form processing
		if (isset($_REQUEST['tmpl']) && sanitize_text_field(wp_unslash($_REQUEST['tmpl']))=="component"){
				joocart_output_oc($output);
				exit();
		}
		else{
			global $joocart_global_admin_content;
			$joocart_global_admin_content=$output;
		}
	}//end if(if click to upgrade link then include upgrade file)


}
//set wordpress toolbar header and sub menu items
?>