<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//start JooCart Admin Base class
class JooCartAdminBase {	
	// START Admin Panel functions
	// function for refresh modification files outside of wordpress folder
	public static function RefreshModifications(){
		if(defined("ABSPATH") && is_admin()) {
			//Log
			$log = array();

			// Clear all modification files
			$files = array();

			// Make path into an array
			$path = array(DIR_MODIFICATION . '*');

			// While the path array is still populated keep looping through
			while (count($path) != 0) {
				$next = array_shift($path);

				foreach (glob($next) as $file) {
					// If directory add to path array
					if (is_dir($file)) {
						$path[] = $file . '/*';
					}

					// Add the file to the files to be deleted array
					$files[] = $file;
				}
			}

			// Reverse sort the file array
			rsort($files);
			global $wp_filesystem;
			WP_Filesystem();
			
			// Clear all modification files
			foreach ($files as $file) {
				if ($file != DIR_MODIFICATION . 'index.html') {
					// If file just delete
					if (is_file($file)) {
						// unlik modification files outside of wodpress plugin folder and outside of wordpress folder
						unlink($file);

					// If directory use the remove directory function
					} elseif (is_dir($file)) {
						// rmdir($file);
						// rmdir modification files outside of wodpress plugin folder and outside of wordpress folder
						$wp_filesystem->rmdir($file);
					}
				}
			}

			// Begin
			$xml = array();

			// Load the default modification XML
			$xml[] = file_get_contents(DIR_SYSTEM . 'modification.xml');
			// changed modification files outside of wodpress plugin folder and outside of wordpress folder
			$ocmod_files = array('joocart_admin.ocmod.xml', 'joocart_admin_common.ocmod.xml','joocart_frontend.ocmod.xml', 'joocart_frontend_common.ocmod.xml');
			if(defined("JOOCART_OPENCART_DIR") && JOOCART_PLUGIN_DIR != JOOCART_OPENCART_DIR ) {
				foreach($ocmod_files as $ocmod_file) {
					if(file_exists(JOOCART_PLUGIN_DIR . 'system/' . $ocmod_file)) {
						// rmdir modification files outside of wodpress plugin folder and outside of wordpress folder
						$wp_filesystem->put_contents(JOOCART_OPENCART_DIR . 'system/' . $ocmod_file, file_get_contents(JOOCART_PLUGIN_DIR . 'system/' . $ocmod_file), FS_CHMOD_FILE );
					}
				}
			}
			// This is purly for developers so they can run mods directly and have them run without upload after each change.
			$files = glob(DIR_SYSTEM . '*.ocmod.xml');

			if ($files) {
				foreach ($files as $file) {
					$xml[] = file_get_contents($file);
				}
			}

				
			// Get the default modification file
			$db_mod = new DB(DB_DRIVER, DB_HOSTNAME, DB_USERNAME, JOOCART_DB_PASS_WORD, DB_DATABASE, DB_PORT);
			$query_mod = $db_mod->query("SELECT * FROM `" . DB_PREFIX . "modification`  ORDER BY name ASC");
			$results_mod = $query_mod->rows;		
			foreach ($results_mod as $result_mod) {
				if ($result_mod['status']) {
					$xml[] = $result_mod['xml'];
				}
			}
			$modification = array();

			foreach ($xml as $xml) {
				if (empty($xml)){
					continue;
				}
				
				$dom = new DOMDocument('1.0', 'UTF-8');
				$dom->preserveWhiteSpace = false;
				$dom->loadXml($xml);

				// Log
				$log[] = 'MOD: ' . $dom->getElementsByTagName('name')->item(0)->textContent;

				// Wipe the past modification store in the backup array
				$recovery = array();

				// Set the a recovery of the modification code in case we need to use it if an abort attribute is used.
				if (isset($modification)) {
					$recovery = $modification;
				}

				$files = $dom->getElementsByTagName('modification')->item(0)->getElementsByTagName('file');

				foreach ($files as $file) {
					$operations = $file->getElementsByTagName('operation');

					$files = explode('|', $file->getAttribute('path'));

					foreach ($files as $file) {
						$path = '';

						// Get the full path of the files that are going to be used for modification
						if ((substr($file, 0, 7) == 'catalog')) {
							$path = DIR_CATALOG . substr($file, 8);
						}

						if ((substr($file, 0, 5) == 'admin')) {
							$path = DIR_APPLICATION . substr($file, 6);
						}

						if ((substr($file, 0, 6) == 'system')) {
							$path = DIR_SYSTEM . substr($file, 7);
						}
						
						

						if ($path) {
							$files = glob($path, GLOB_BRACE);

							if ($files) {
								foreach ($files as $file) {
									// Get the key to be used for the modification cache filename.
									if (substr($file, 0, strlen(DIR_CATALOG)) == DIR_CATALOG) {
										$key = 'catalog/' . substr($file, strlen(DIR_CATALOG));
									}

									if (substr($file, 0, strlen(DIR_APPLICATION)) == DIR_APPLICATION) {
										$key = 'admin/' . substr($file, strlen(DIR_APPLICATION));
									}

									if (substr($file, 0, strlen(DIR_SYSTEM)) == DIR_SYSTEM) {
										$key = 'system/' . substr($file, strlen(DIR_SYSTEM));
									}

									// If file contents is not already in the modification array we need to load it.
									if (!isset($modification[$key])) {
										$content = file_get_contents($file);

										$modification[$key] = preg_replace('~\r?\n~', "\n", $content);
										$original[$key] = preg_replace('~\r?\n~', "\n", $content);

										// Log
										$log[] = PHP_EOL . 'FILE: ' . $key;
									}

									foreach ($operations as $operation) {
										$error = $operation->getAttribute('error');

										// Ignoreif
										$ignoreif = $operation->getElementsByTagName('ignoreif')->item(0);

										if ($ignoreif) {
											if ($ignoreif->getAttribute('regex') != 'true') {
												if (strpos($modification[$key], $ignoreif->textContent) !== false) {
													continue;
												}
											} else {
												if (preg_match($ignoreif->textContent, $modification[$key])) {
													continue;
												}
											}
										}

										$status = false;

										// Search and replace
										if ($operation->getElementsByTagName('search')->item(0)->getAttribute('regex') != 'true') {
											// Search
											$search = $operation->getElementsByTagName('search')->item(0)->textContent;
											$trim = $operation->getElementsByTagName('search')->item(0)->getAttribute('trim');
											$index = $operation->getElementsByTagName('search')->item(0)->getAttribute('index');

											// Trim line if no trim attribute is set or is set to true.
											if (!$trim || $trim == 'true') {
												$search = trim($search);
											}

											// Add
											$add = $operation->getElementsByTagName('add')->item(0)->textContent;
											$trim = $operation->getElementsByTagName('add')->item(0)->getAttribute('trim');
											$position = $operation->getElementsByTagName('add')->item(0)->getAttribute('position');
											$offset = $operation->getElementsByTagName('add')->item(0)->getAttribute('offset');

											if ($offset == '') {
												$offset = 0;
											}

											// Trim line if is set to true.
											if ($trim == 'true') {
												$add = trim($add);
											}

											// Log
											$log[] = 'CODE: ' . $search;

											// Check if using indexes
											if ($index !== '') {
												$indexes = explode(',', $index);
											} else {
												$indexes = array();
											}

											// Get all the matches
											$i = 0;

											$lines = explode("\n", $modification[$key]);

											for ($line_id = 0; $line_id < count($lines); $line_id++) {
												$line = $lines[$line_id];

												// Status
												$match = false;

												// Check to see if the line matches the search code.
												if (stripos($line, $search) !== false) {
													// If indexes are not used then just set the found status to true.
													if (!$indexes) {
														$match = true;
													} elseif (in_array($i, $indexes)) {
														$match = true;
													}

													$i++;
												}

												// Now for replacing or adding to the matched elements
												if ($match) {
													switch ($position) {
														default:
														case 'replace':
															$new_lines = explode("\n", $add);

															if ($offset < 0) {
																array_splice($lines, $line_id + $offset, abs($offset) + 1, array(str_replace($search, $add, $line)));

																$line_id -= $offset;
															} else {
																array_splice($lines, $line_id, $offset + 1, array(str_replace($search, $add, $line)));
															}
															break;
														case 'before':
															$new_lines = explode("\n", $add);

															array_splice($lines, $line_id - $offset, 0, $new_lines);

															$line_id += count($new_lines);
															break;
														case 'after':
															$new_lines = explode("\n", $add);

															array_splice($lines, ($line_id + 1) + $offset, 0, $new_lines);

															$line_id += count($new_lines);
															break;
													}

													// Log
													$log[] = 'LINE: ' . $line_id;

													$status = true;
												}
											}

											$modification[$key] = implode("\n", $lines);
										} else {
											$search = trim($operation->getElementsByTagName('search')->item(0)->textContent);
											$limit = $operation->getElementsByTagName('search')->item(0)->getAttribute('limit');
											$replace = trim($operation->getElementsByTagName('add')->item(0)->textContent);

											// Limit
											if (!$limit) {
												$limit = -1;
											}

											// Log
											$match = array();

											preg_match_all($search, $modification[$key], $match, PREG_OFFSET_CAPTURE);

											// Remove part of the the result if a limit is set.
											if ($limit > 0) {
												$match[0] = array_slice($match[0], 0, $limit);
											}

											if ($match[0]) {
												$log[] = 'REGEX: ' . $search;

												for ($i = 0; $i < count($match[0]); $i++) {
													$log[] = 'LINE: ' . (substr_count(substr($modification[$key], 0, $match[0][$i][1]), "\n") + 1);
												}

												$status = true;
											}

											// Make the modification
											$modification[$key] = preg_replace($search, $replace, $modification[$key], $limit);
										}

										if (!$status) {
											// Abort applying this modification completely.
											if ($error == 'abort') {
												$modification = $recovery;
												// Log
												$log[] = 'NOT FOUND - ABORTING!';
												break 5;
											}
											// Skip current operation or break
											elseif ($error == 'skip') {
												// Log
												$log[] = 'NOT FOUND - OPERATION SKIPPED!';
												continue;
											}
											// Break current operations
											else {
												// Log
												$log[] = 'NOT FOUND - OPERATIONS ABORTED!';
												break;
											}
										}
									}
								}
							}
						}
					}
				}

				// Log
				$log[] = '----------------------------------------------------------------';
			}

			// Log
			$ocmod = new Log('ocmod.log');
			$ocmod->write(implode("\n", $log));

			// Write all modification files
			global $wp_filesystem;
			WP_Filesystem();
			foreach ($modification as $key => $value) {
				// Only create a file if there are changes
				if ($original[$key] != $value) {
					$path = '';

					$directories = explode('/', dirname($key));

					foreach ($directories as $directory) {
						$path = $path . '/' . $directory;

						if (!is_dir(DIR_MODIFICATION . $path)) {
							// mkdir for modification files outside of wodpress plugin folder and outside of wordpress folder
							$wp_filesystem->mkdir(DIR_MODIFICATION . $path, 0777);
						}
					}

					// $handle = fopen(DIR_MODIFICATION . $key, 'w');

					// fwrite($handle, $value);

					// fclose($handle);
					// change modification files outside of wodpress plugin folder and outside of wordpress folder
					$wp_filesystem->put_contents(DIR_MODIFICATION . $key, $value, FS_CHMOD_FILE );
				}
			}
		}
	}
	public static function setJooCartConfigFile(){
		$joocart_shop_page_id="";
		$joocart_use_wordpress_button="";
		$joocart_dont_show_header="";
		$joocart_dont_show_footer="";
		$joocart_dont_show_menus="";
		$joocart_dont_show_admin_login="";
		$joocart_dont_include_jquery="";
		$joocart_disable_bootstrap_tooltip = "";
		$joocart_use_jquery_dollar="";
		$joocart_dont_show_left_right_column="";
		$joocart_enable_wp_widget_title="";
		$joocart_main_http_server="";
		$joocart_redirect_http_server="";
		$joocart_change_lang_to_default="";
		$joocart_use_wordpress_db="1";
		$joocart_show_logo_header="";
		$joocart_use_oc_template="";
		$joocart_use_custom_color="";
		$joocart_default_txt_color="";
		$joocart_default_link_color="";
		$joocart_default_link_hover_color="";
		$joocart_default_button_box_color="";
		$joocart_default_button_hover_color="";
		$joocart_default_button_txt_color="";	
		$joocart_default_menu_link_color="";
		$joocart_default_menu_link_hover_color="";
		$joocart_use_gradient_color="";
		$joocart_custom_css_oc="";
		$joocart_select_seo_for_prod_cat="";
		$joocart_use_dynamic_checkout_urls="";
		if(joocart_get_option('joocart_shop_page_id')!=""){
			$joocart_shop_page_id=joocart_get_option('joocart_shop_page_id');
		}
		if(joocart_get_option('joocart_dont_show_menus')!=""){
			$joocart_dont_show_menus=joocart_get_option('joocart_dont_show_menus');
		}
		$joocart_opencart_dir_path = JOOCART_PLUGIN_DIR;
		if(trim(joocart_get_option('joocart_opencart_dir_path'))!=""){
			$joocart_opencart_dir_path = rtrim(str_replace('\\', '/', trim(joocart_get_option('joocart_opencart_dir_path'))), '/') . '/';

			if(is_dir($joocart_opencart_dir_path ))
			joocart_define_oc('JOOCART_OPENCART_DIR', $joocart_opencart_dir_path);
			else
			joocart_define_oc('JOOCART_OPENCART_DIR', JOOCART_PLUGIN_DIR);
		} else {
			joocart_define_oc('JOOCART_OPENCART_DIR', JOOCART_PLUGIN_DIR);
		}		
		if($joocart_shop_page_id!=""){
			joocart_define_oc('JOOCART_SHOP_PAGE_ID', $joocart_shop_page_id);
		} else {
			joocart_define_oc('JOOCART_SHOP_PAGE_ID', "0");
		}
		if($joocart_dont_show_admin_login!=""){
			joocart_define_oc('JOOCART_DONT_SHOW_ADMIN_LOGIN', $joocart_dont_show_admin_login);
		} else {
			joocart_define_oc('JOOCART_DONT_SHOW_ADMIN_LOGIN', "0");
		}
		if(!is_admin()) {
			$post_info=get_post(joocart_get_option("joocart_shop_page_id"));
			$post_name=$post_info->post_name;
			joocart_define_oc('JOOCART_SHOP_SEO_KEY',$post_name);
			if(defined("JOOCART_SHOP_PAGE_ID") && JOOCART_SHOP_PAGE_ID){
				joocart_define_oc('JOOCART_PAGE_ID_PARAM', 'page_id='.JOOCART_SHOP_PAGE_ID.'&');
				
			} else {
				joocart_define_oc('JOOCART_PAGE_ID_PARAM', '');
			}
		}
		if($joocart_use_wordpress_button!=""){
			joocart_define_oc('JOOCART_USE_WORDPRESS_BUTTON', $joocart_use_wordpress_button);
		} else {
			joocart_define_oc('JOOCART_USE_WORDPRESS_BUTTON', "0");
		}
		
		if($joocart_dont_show_header!=""){
			joocart_define_oc('JOOCART_DONT_SHOW_HEADER', $joocart_dont_show_header);
		} else {
			joocart_define_oc('JOOCART_DONT_SHOW_HEADER', "0");
		}
		
		if($joocart_dont_show_footer!=""){
			joocart_define_oc('JOOCART_DONT_SHOW_FOOTER', $joocart_dont_show_footer);
		}else {
			joocart_define_oc('JOOCART_DONT_SHOW_FOOTER', "0");
		}
		
		if($joocart_dont_show_menus!=""){
			joocart_define_oc('JOOCART_DONT_SHOW_MENUS', $joocart_dont_show_menus);
		} else {
			joocart_define_oc('JOOCART_DONT_SHOW_MENUS', "1");
		}		
				
		if($joocart_dont_include_jquery!=""){
			joocart_define_oc('JOOCART_DONT_INCLUDE_JQUERY', $joocart_dont_include_jquery);
		} else {
			joocart_define_oc('JOOCART_DONT_INCLUDE_JQUERY', "0");
		}
		
		if($joocart_use_jquery_dollar!=""){
			joocart_define_oc('JOOCART_USE_JQUERY_DOLLAR', $joocart_use_jquery_dollar);
		} else {
			joocart_define_oc('JOOCART_USE_JQUERY_DOLLAR', "1");
		}
		
		if($joocart_disable_bootstrap_tooltip!=""){
			joocart_define_oc('JOOCART_DISABLE_BOOTSTRAP_TOOLTIP', $joocart_disable_bootstrap_tooltip);
		} else {
			joocart_define_oc('JOOCART_DISABLE_BOOTSTRAP_TOOLTIP', "0");
		}
		
		if($joocart_dont_show_left_right_column!=""){
			joocart_define_oc('JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN', $joocart_dont_show_left_right_column);
		} else {
			joocart_define_oc('JOOCART_DONT_SHOW_LEFTRIGHT_COLUMN', "0");
		}
		
		if($joocart_enable_wp_widget_title!=""){
			joocart_define_oc('JOOCART_ENABLE_WP_WIDGET_TITLE', $joocart_enable_wp_widget_title);
		} else {
			joocart_define_oc('JOOCART_ENABLE_WP_WIDGET_TITLE', "1");
		}
		
		if($joocart_change_lang_to_default!=""){
			joocart_define_oc('JOOCART_CHANGE_LANG_TO_DEFAULT', $joocart_change_lang_to_default);
		} else {
			joocart_define_oc('JOOCART_CHANGE_LANG_TO_DEFAULT', "1");
		}
		
		if($joocart_show_logo_header!=""){
			joocart_define_oc('JOOCART_SHOW_LOGO_HEADER', $joocart_show_logo_header);
		} else {
			joocart_define_oc('JOOCART_SHOW_LOGO_HEADER', "0");
		}
		
		if($joocart_use_oc_template!=""){
			joocart_define_oc('JOOCART_USE_OC_TEMPLATE', $joocart_use_oc_template);
		} else {
			joocart_define_oc('JOOCART_USE_OC_TEMPLATE', "0");
		}
		
		if($joocart_use_custom_color!=""){
			joocart_define_oc('JOOCART_USE_CUSTOM_COLOR', $joocart_use_custom_color);
		} else {
			joocart_define_oc('JOOCART_USE_CUSTOM_COLOR', "0");
		}
		if($joocart_default_txt_color!=""){
			joocart_define_oc('JOOCART_DEFAULT_TXT_COLOR', $joocart_default_txt_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_TXT_COLOR', "000000");
		}
		if($joocart_default_link_color!=""){
			joocart_define_oc('JOOCART_DEFAULT_LINK_COLOR', $joocart_default_link_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_LINK_COLOR', "00A7E5");
		}
		if($joocart_default_link_hover_color != "") {
			joocart_define_oc('JOOCART_DEFAULT_LINK_HOVER_COLOR', $joocart_default_link_hover_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_LINK_HOVER_COLOR', "0");
		}
		if($joocart_default_button_box_color!=""){
			joocart_define_oc('JOOCART_DEFAULT_BUTTONBOX_COLOR', $joocart_default_button_box_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_BUTTONBOX_COLOR', "00A7E5");
		}
		if($joocart_default_button_hover_color!=""){
			joocart_define_oc('JOOCART_DEFAULT_BUTTON_HOVER_COLOR', $joocart_default_button_hover_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_BUTTON_HOVER_COLOR', "267799");
		}
		if($joocart_default_button_txt_color!=""){
			joocart_define_oc('JOOCART_DEFAULT_BUTTON_TEXT_COLOR', $joocart_default_button_txt_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_BUTTON_TEXT_COLOR', "FFFFFF");
		}		
		if($joocart_default_menu_link_color != "") {
			joocart_define_oc('JOOCART_DEFAULT_MENU_LINK_COLOR', $joocart_default_menu_link_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_MENU_LINK_COLOR', "0");
		}
		if($joocart_default_menu_link_hover_color != "") {
			joocart_define_oc('JOOCART_DEFAULT_MENU_LINK_HOVER_COLOR', $joocart_default_menu_link_hover_color);
		} else {
			joocart_define_oc('JOOCART_DEFAULT_MENU_LINK_HOVER_COLOR', "0");
		}
		if($joocart_use_gradient_color!=""){
			joocart_define_oc('JOOCART_USE_GRADIENT_COLOR', $joocart_use_gradient_color);
		} else {
			joocart_define_oc('JOOCART_USE_GRADIENT_COLOR', "0");
		}
		if($joocart_select_seo_for_prod_cat != "") {
			joocart_define_oc('JOOCART_SELECT_SEO_FOR_PROD_CAT', $joocart_select_seo_for_prod_cat);
		} else {
			joocart_define_oc('JOOCART_SELECT_SEO_FOR_PROD_CAT', "0");
		}
		if($joocart_use_dynamic_checkout_urls != "") {
			joocart_define_oc('JOOCART_USE_DYNAMIC_CHECKOUT_URLS', $joocart_use_dynamic_checkout_urls);
		} else {
			joocart_define_oc('JOOCART_USE_DYNAMIC_CHECKOUT_URLS', "0");
		}
		if($joocart_redirect_http_server!="" && $joocart_redirect_http_server=="1"){
			joocart_define_oc('JOOCART_REDIRECT_HTTP_SERVER', "Yes");
		} else {
			joocart_define_oc('JOOCART_REDIRECT_HTTP_SERVER', "");
		}	
		
		if($joocart_use_wordpress_db==="0"){
			joocart_define_oc('JOOCART_USE_MANUAL_DB', '1');
		} else {
			joocart_define_oc('JOOCART_USE_MANUAL_DB', '0');
		}
		//joocart_define_oc('JOOCART_DB_PASS_WORD', $db_user_password);
		$joocart_site_url = trim(site_url(), '/') . '/';
		$joocart_site_https_url = str_replace("http://", "https://", $joocart_site_url);
		
		$joocart_site_admin_url = trim(admin_url(), '/') . '/';
		$joocart_site_admin_https_url = str_replace("http://", "https://", $joocart_site_admin_url);
		
		$joocart_opencart_url = trim(joocart_get_option('joocart_opencart_dir_url'), '/') . '/';
		$joocart_opencart_https_url = str_replace("http://", "https://", $joocart_opencart_url);
		
		
		joocart_define_oc('JOOCART_SITE_URL', $joocart_site_url);
		joocart_define_oc('JOOCART_SITE_ADMIN_URL', $joocart_site_admin_url);
		
		$joocart_default_relative_url = str_replace(JOOCART_SITE_URL, "", JOOCART_PLUGIN_URL);
		$parse_http_server_one = parse_url($joocart_site_url);
		$parse_http_server_two = parse_url($joocart_opencart_url);
		if($parse_http_server_one['host'] == $parse_http_server_two['host']){
			$joocart_relative_url = joocart_get_relative_path($joocart_site_url, $joocart_opencart_url);
			if(substr( $joocart_relative_url, 0, 2 ) === "./") {
				$joocart_relative_url = substr($joocart_relative_url, 2, (strlen($joocart_relative_url)-2));
			}
			$joocart_main_http_server = "";
		} else {
			$joocart_relative_url = $joocart_default_relative_url;
			$joocart_main_http_server = str_replace($joocart_default_relative_url, "", $joocart_opencart_url);
		}
		
		joocart_define_oc('JOOCART_RELATIVE_URL', $joocart_relative_url);
		joocart_define_oc('JOOCART_MAIN_HTTP_SERVER', $joocart_main_http_server);
		if(isset($_SERVER['HTTPS']) && ((sanitize_text_field(wp_unslash($_SERVER['HTTPS'])) == 'on') || (sanitize_text_field(wp_unslash($_SERVER['HTTPS'])) == '1'))){
			joocart_define_oc('JOOCART_SITE_HTTPS_URL', $joocart_site_https_url);
			joocart_define_oc('JOOCART_SITE_ADMIN_HTTPS_URL', $joocart_site_admin_https_url);
			joocart_define_oc('JOOCART_OPENCART_URL', $joocart_opencart_https_url);
		} else {
			joocart_define_oc('JOOCART_SITE_HTTPS_URL', $joocart_site_url);
			joocart_define_oc('JOOCART_SITE_ADMIN_HTTPS_URL', $joocart_site_admin_url);
			joocart_define_oc('JOOCART_OPENCART_URL', $joocart_opencart_url);
		}
		if(is_admin()) {
			$joocart_oc_config_filename = 'admin/config.php';			
		} else {
			$joocart_oc_config_filename = 'config.php';
		}
		if(JOOCART_PLUGIN_DIR != $joocart_opencart_dir_path && file_exists($joocart_opencart_dir_path . $joocart_oc_config_filename)) {
			$lines=file($joocart_opencart_dir_path . $joocart_oc_config_filename);
			foreach($lines as $line) {
				$matches=array();
				if (preg_match("/define\s*\(\s*'([^']+)'\s*,\s*(.+?)\s*\);/", $line, $matches)) {
					$name=$matches[1];
					$value = preg_replace("/['\".\s]/", '', $matches[2]);
					if($name == 'DB_PASSWORD')
					$name = 'JOOCART_DB_PASS_WORD';
					elseif($name == 'HTTP_SERVER' && is_admin())
					$value = JOOCART_SITE_ADMIN_URL;
					elseif($name == 'HTTP_SERVER')
					$value = JOOCART_SITE_URL;
					elseif($name == 'HTTPS_SERVER' && is_admin())
					$value = JOOCART_SITE_ADMIN_HTTPS_URL;
					elseif($name == 'HTTPS_SERVER')
					$value = JOOCART_SITE_HTTPS_URL;
					elseif($name == 'HTTP_CATALOG')
					$value = JOOCART_SITE_URL;
					elseif($name == 'HTTPS_CATALOG')
					$value = JOOCART_SITE_URL;
					
					if(defined("DIR_SYSTEM"))
					$value = str_replace('DIR_SYSTEM', DIR_SYSTEM, $value);
					if(defined("DIR_APPLICATION"))
					$value = str_replace('DIR_APPLICATION', DIR_APPLICATION, $value);					
					if(defined("DIR_STORAGE"))
					$value = str_replace('DIR_STORAGE', DIR_STORAGE, $value);					
					
					joocart_define_oc($name, $value);
				}

			}
		}
	}
	// End Admin Panel functions
}
//end JooCart Admin Base class
function joocart_define_oc($joocart_var_name, $joocart_value) {
	if(!defined($joocart_var_name))
	define($joocart_var_name, $joocart_value);
}

function joocart_get_option($option_name) {
        if (isset($_POST['joocart_options_form_nonce']) && wp_verify_nonce(sanitize_key($_POST['joocart_options_form_nonce']), 'joocart_options_form_action' ) && isset($_REQUEST[$option_name]) && !empty($_REQUEST[$option_name]))
        return sanitize_text_field(wp_unslash($_REQUEST[$option_name]));
	else
	return get_option($option_name);
}
function joocart_get_relative_path($from, $to){
	if(strstr($from, "http://") && strstr($to, "https://")){
		$from = str_replace("http://", "https://", $from);
	}
	if(strstr($from, "https://") && strstr($to, "http://")){
		$to = str_replace("http://", "https://", $to);
	}
		
	// some compatibility fixes for Windows paths
	$from = is_dir($from) ? rtrim($from, '\/') . '/' : $from;
	$to   = is_dir($to)   ? rtrim($to, '\/') . '/'   : $to;
	$from = str_replace('\\', '/', $from);
	$to   = str_replace('\\', '/', $to);

	$from     = explode('/', $from);
	$to       = explode('/', $to);
	$relPath  = $to;

	foreach($from as $depth => $dir) {
		// find first non-matching dir
		if($dir === $to[$depth]) {
			// ignore this directory
			array_shift($relPath);
		} else {
			// get number of remaining dirs to $from
			$remaining = count($from) - $depth;
			if($remaining > 1) {
				// add traversals up to first matching dir
				$padLength = (count($relPath) + $remaining - 1) * -1;
				$relPath = array_pad($relPath, $padLength, '..');
				break;
			} else {
				$relPath[0] = './' . $relPath[0];
			}
		}
	}
	return implode('/', $relPath);
}
?>