<?php
/**
 * @package		JooCart
 * @copyright	Copyright (C) 2009 - 2025 softPHP,https://www.soft-php.com
 * @license		GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
register_activation_hook(JOOCART_PLUGIN_FILENAME,'joocart_store_activate');
register_deactivation_hook(JOOCART_PLUGIN_FILENAME,'joocart_store_deactivate');	
add_action('admin_init','joocart_options_api_init');
add_action('wp_dashboard_setup','joocart_add_dashboard_widgets');
add_action('admin_menu','joocart_menu_options_add_page');
require_once(dirname(__FILE__).'/joocart_install.php');
require_once(dirname(__FILE__).'/joocart_admin_functions.php');
function joocart_dashboard_widget_function(){
	echo "<a href=\"options-general.php?page=joocart_options_page\">" . esc_html__('JooCart Options', 'joocart') . "</a> | 
		  <a href=\"admin.php?page=joocart\">" . esc_html__('JooCart Admin Panel', 'joocart') . "</a><br/><br/>
		  <a href=\"" . esc_url(get_permalink(get_option("joocart_shop_page_id"))) . "\" target=\"_blank\">" . esc_html__('JooCart Frontend', 'joocart') . "</a> | 
		  <a href=\"https://www.soft-php.com/support.html\" target=\"_blank\">" . esc_html__('Support', 'joocart') . "</a><br/><br/>";
}
function joocart_add_dashboard_widgets(){
	if(current_user_can('administrator'))
	wp_add_dashboard_widget('joocart_dashboard_widget','JooCart Links','joocart_dashboard_widget_function');
}
function joocart_menu_options_add_page(){
	add_options_page('JooCart Options','JooCart Options','manage_options','joocart_options_page','joocart_options_do_page');
	
	if(get_option("joocart_who_can_access_admin")=="subscriber")
		$joocart_access_previlige="read";
	elseif(get_option("joocart_who_can_access_admin")=="contributor")
		$joocart_access_previlige="edit_posts";
	elseif(get_option("joocart_who_can_access_admin")=="author")
		$joocart_access_previlige="publish_posts";
	elseif(get_option("joocart_who_can_access_admin")=="editor")
		$joocart_access_previlige="publish_pages";
	else
		$joocart_access_previlige="manage_options";
	if(isset($_POST['joocart_options_form_nonce']) && wp_verify_nonce( sanitize_key($_POST['joocart_options_form_nonce']), 'joocart_options_form_action' ) && isset($_REQUEST["joocart_order_email"], $_REQUEST["joocart_upgrade_download_id"], $_REQUEST["joocart_opencart_dir_path"], $_REQUEST["joocart_opencart_dir_url"])) {
		$joocart_email    = sanitize_email(wp_unslash($_REQUEST["joocart_order_email"]));
		$joocart_download = sanitize_text_field(wp_unslash($_REQUEST["joocart_upgrade_download_id"]));
		$joocart_path     = sanitize_text_field(wp_unslash($_REQUEST["joocart_opencart_dir_path"]));
		$joocart_url      = esc_url_raw(wp_unslash($_REQUEST["joocart_opencart_dir_url"]));
		
		$joocart_path = rtrim(str_replace('\\', '/', trim($joocart_path)), '/') . '/';
		if(!file_exists($joocart_path . 'system/startup.php')){
			wp_die(esc_html__('Please provide correct OpenCart Directory Path.', 'joocart'));
		}
		if($joocart_path !== '' && $joocart_url !== '') {
			JooCartAdminBase::setJooCartConfigFile();
			// print_r(get_defined_constants(true)['user']);
			if(defined("DIR_SYSTEM") && file_exists(DIR_SYSTEM . 'startup.php')) {
				require_once(DIR_SYSTEM . 'startup.php');
				JooCartAdminBase::RefreshModifications();
			}
		}
	}
	$joocart_opencart_dir_path = rtrim(str_replace('\\', '/', trim(get_option('joocart_opencart_dir_path'))), '/') . '/';
	if(file_exists($joocart_opencart_dir_path . 'system/startup.php')) {
		add_menu_page(__('JooCart Administrator','joocart'),__('JooCart','joocart'),$joocart_access_previlige,'joocart','joocart_admin_main','dashicons-cart');	
		add_submenu_page('joocart',__('Categories','joocart'),__('Categories','joocart'),$joocart_access_previlige,'joocart_category','joocart_admin_main');
		add_submenu_page('joocart',__('Products','joocart'),__('Products','joocart'),$joocart_access_previlige,'joocart_product','joocart_admin_main');
		add_submenu_page('joocart',__('Modules','joocart'),__('Modules','joocart'),$joocart_access_previlige,'joocart_module','joocart_admin_main');
		add_submenu_page('joocart',__('Shippings','joocart'),__('Shippings','joocart'),$joocart_access_previlige,'joocart_shipping','joocart_admin_main');
		add_submenu_page('joocart',__('Payments','joocart'),__('Payments','joocart'),$joocart_access_previlige,'joocart_payment','joocart_admin_main');
		add_submenu_page('joocart',__('Orders','joocart'),__('Orders','joocart'),$joocart_access_previlige,'joocart_order','joocart_admin_main');
		add_submenu_page('joocart',__('Customers','joocart'),__('Customers','joocart'),$joocart_access_previlige,'joocart_customer','joocart_admin_main');
		add_submenu_page('joocart',__('Settings','joocart'),__('Settings','joocart'),$joocart_access_previlige,'joocart_store','joocart_admin_main');
	} else {
		add_menu_page(__('JooCart Administrator','joocart'),__('JooCart','joocart'),$joocart_access_previlige,'joocart','joocart_installation_page','dashicons-cart');	
	}
	
}

function joocart_admin_main(){
	global $joocart_global_admin_content;
	if(isset($joocart_global_admin_content) && function_exists('joocart_output_oc'))
	joocart_output_oc($joocart_global_admin_content);	
}
function joocart_admin_main_init(){
	joocart_admin_check_previlige();
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- 'page' is used for routing, not form processing
	$joocart_page = isset($_REQUEST['page']) ? sanitize_key(wp_unslash($_REQUEST['page'])) : '';


	switch ($joocart_page) {
		case 'joocart_store':
			$_GET["route"] = "setting/store";
			break;
		case 'joocart_category':
			$_GET["route"] = "catalog/category";
			break;
		case 'joocart_product':
			$_GET["route"] = "catalog/product";
			break;
		case 'joocart_module':
			$_GET["route"] = "marketplace/extension";
			$_GET["type"] = "module";
			break;
		case 'joocart_shipping':
			$_GET["route"] = "marketplace/extension";
			$_GET["type"] = "shipping";
			break;
		case 'joocart_payment':
			$_GET["route"] = "marketplace/extension";
			$_GET["type"] = "payment";
			break;
		case 'joocart_order':
			$_GET["route"] = "sale/order";
			break;
		case 'joocart_customer':
			$_GET["route"] = "customer/customer";
			break;
	}

	if (!empty($joocart_page)) {
		$joocart_page_name = $joocart_page;
		unset($_REQUEST["page"], $_GET["page"]);
	}
	require_once(dirname(__FILE__).'/joocart_admin_main.php');
	if(isset($joocart_page_name))
	$_GET["page"] = $_REQUEST["page"] = $joocart_page_name;	
}
function joocart_options_api_init(){
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_upgrade_download_id", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_order_email", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_opencart_dir_path", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_opencart_dir_url", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_who_can_access_admin", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_wordpress_button", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_show_header", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_show_footer", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_show_menus", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_show_admin_login", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_include_jquery", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_disable_bootstrap_tooltip", array('sanitize_callback' =>  'sanitize_text_field'));	
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_jquery_dollar", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_dont_show_left_right_column", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_enable_wp_widget_title", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_redirect_http_server", array('sanitize_callback' =>  'sanitize_text_field'));	
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_change_lang_to_default", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_wordpress_db", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_db_user_name", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_db_user_password", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_db_user_host", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_db_name", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_db_user_prefix", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_show_logo_header", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_oc_template", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_custom_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_txt_color", array('sanitize_callback' =>  'sanitize_text_field'));	
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_link_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_link_hover_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_button_box_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_button_hover_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_button_txt_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_menu_link_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_default_menu_link_hover_color", array('sanitize_callback' =>  'sanitize_text_field'));	
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_gradient_color", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_custom_css_oc", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_select_seo_for_prod_cat", array('sanitize_callback' =>  'sanitize_text_field'));
	// phpcs:ignore PluginCheck.CodeAnalysis.SettingSanitization.register_settingDynamic -- All settings use valid static sanitization callbacks
	register_setting('joocart_options_page',"joocart_use_dynamic_checkout_urls", array('sanitize_callback' =>  'sanitize_text_field'));
}
function joocart_options_do_page(){
	$joocart_shop_page_id=get_option("joocart_shop_page_id");
	$joocart_upgrade_download_id=get_option("joocart_upgrade_download_id");
	$joocart_order_email=get_option("joocart_order_email");
	// $joocart_site_url=get_option("joocart_site_url");
	$joocart_opencart_dir_path=get_option("joocart_opencart_dir_path");
	$joocart_opencart_dir_url=get_option("joocart_opencart_dir_url");
	$joocart_who_can_access_admin=get_option("joocart_who_can_access_admin");
	$joocart_use_wordpress_button=get_option("joocart_use_wordpress_button");
	$joocart_dont_show_header=get_option("joocart_dont_show_header");
	$joocart_dont_show_footer=get_option("joocart_dont_show_footer");
	$joocart_dont_show_menus=get_option("joocart_dont_show_menus");
	$joocart_dont_show_admin_login=get_option("joocart_dont_show_admin_login");
	$joocart_dont_include_jquery=get_option("joocart_dont_include_jquery");
	$joocart_disable_bootstrap_tooltip=get_option("joocart_disable_bootstrap_tooltip");
	$joocart_use_jquery_dollar=get_option("joocart_use_jquery_dollar");
	$joocart_dont_show_left_right_column=get_option("joocart_dont_show_left_right_column");
	$joocart_enable_wp_widget_title=get_option("joocart_enable_wp_widget_title");
	// $joocart_main_http_server=get_option("joocart_main_http_server");
	$joocart_redirect_http_server=get_option("joocart_redirect_http_server");
	$joocart_change_lang_to_default=get_option("joocart_change_lang_to_default");
	$joocart_use_wordpress_db=get_option("joocart_use_wordpress_db");
	$joocart_db_user_name=get_option("joocart_db_user_name");
	$joocart_db_user_password=get_option("joocart_db_user_password");
	$joocart_db_user_host=get_option("joocart_db_user_host");
	$joocart_db_name=get_option("joocart_db_name");
	$joocart_db_user_prefix=get_option("joocart_db_user_prefix");
	$joocart_show_logo_header=get_option("joocart_show_logo_header");
	$joocart_use_oc_template=get_option("joocart_use_oc_template");
	$joocart_use_custom_color=get_option("joocart_use_custom_color");
	$joocart_default_txt_color=get_option("joocart_default_txt_color");	
	$joocart_default_link_color=get_option("joocart_default_link_color");
	$joocart_default_link_hover_color=get_option("joocart_default_link_hover_color");
	$joocart_default_button_box_color=get_option("joocart_default_button_box_color");
	$joocart_default_button_hover_color=get_option("joocart_default_button_hover_color");
	$joocart_default_button_txt_color=get_option("joocart_default_button_txt_color");
	$joocart_default_menu_link_color=get_option("joocart_default_menu_link_color");
	$joocart_default_menu_link_hover_color=get_option("joocart_default_menu_link_hover_color");
	$joocart_use_gradient_color=get_option("joocart_use_gradient_color");
	$joocart_custom_css_oc=get_option("joocart_custom_css_oc");
	$joocart_select_seo_for_prod_cat=get_option("joocart_select_seo_for_prod_cat");
	$joocart_use_dynamic_checkout_urls=get_option("joocart_use_dynamic_checkout_urls");
	
	if(function_exists("get_editable_roles"))
	$joocart_wp_rules=get_editable_roles();
	else
	$joocart_wp_rules=array();
	
	$joocart_wp_user_groups=array();
	foreach($joocart_wp_rules as $key=>$value){
		$joocart_wp_user_groups[$key]["wordpress_user_group_id"]=$key;
		$joocart_wp_user_groups[$key]["name"]=$value["name"];
		
	}
	?>
	<div  class="wrap">
	<h1>JooCart Options</h1>
	<form method="post" action="options.php" onsubmit="return joocart_validate_form()">
	<?php settings_fields('joocart_options_page');?>
	<?php wp_nonce_field( 'joocart_options_form_action', 'joocart_options_form_nonce' ); ?>
	<h2 class="nav-tab-wrapper">
		 <a href="#tab1" class="nav-tab nav-tab-active"><?php esc_html_e('JooCart', 'joocart'); ?></a>
         <a href="#tab2" class="nav-tab" style="color:red"><?php esc_html_e('JooCart Pro', 'joocart'); ?></a>
    </h2>
	<div id="tab1">
	<table class="form-table">
		<p> <?php esc_html_e('Provide your existing installed opencart directory and url below:', 'joocart'); ?></p>
		<tr title="<?php esc_html_e('OpenCart Directory Path', 'joocart'); ?>">
			<th scope="row"><label for="joocart_opencart_dir_path"><?php esc_html_e('OpenCart Directory Path', 'joocart'); ?></label></th>
			<td><input name="joocart_opencart_dir_path" id="joocart_opencart_dir_path" value="<?php if(isset($joocart_opencart_dir_path) && trim($joocart_opencart_dir_path) !="" && is_dir(trim($joocart_opencart_dir_path))) { echo esc_html($joocart_opencart_dir_path); } else { echo esc_html(JOOCART_PLUGIN_DIR); }?>" class="regular-text" style="width:100%;" type="text"></td>
		</tr>
		<tr title="<?php esc_html_e('OpenCart Directory URL', 'joocart'); ?>">
			<th scope="row"><label for="joocart_opencart_dir_url"><?php esc_html_e('OpenCart Directory URL', 'joocart'); ?></label></th>
			<td><input name="joocart_opencart_dir_url" id="joocart_opencart_dir_url" value="<?php if(isset($joocart_opencart_dir_url) && trim($joocart_opencart_dir_url) !="") { echo esc_html($joocart_opencart_dir_url); } else { echo esc_html(JOOCART_PLUGIN_URL); }?>" class="regular-text" style="width:100%;" type="text"></td>
		</tr>
	</table>
	</div>
	<div id="tab2">
	<h2 style="color: #2c3e50; font-size: 24px; font-weight: bold;">
    <?php esc_html_e('Add Powerful Features with ', 'joocart'); ?> 
    <a href="https://www.soft-php.com/joocart-wordpress-shopping-cart.html" 
       style="color: #e74c3c; text-decoration: none; font-weight: bold;">
       <?php esc_html_e('JooCart Pro', 'joocart'); ?>
    </a>
</h2>

<p style="font-size: 16px; color: #555;">
    <?php esc_html_e('Enhance your WordPress e-commerce experience with JooCart Pro! Get access to premium features:', 'joocart'); ?>
</p>

<ul style="list-style-type: none; padding: 0;">
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Seamless WordPress Integration:', 'joocart'); ?></strong> <?php esc_html_e('Unified front-end and back-end login.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Custom WordPress Widgets:', 'joocart'); ?></strong> <?php esc_html_e('Categories, Shopping Cart, Information & more.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Multilingual Support:', 'joocart'); ?></strong> <?php esc_html_e('Works flawlessly with WordPress language settings.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Flexible OpenCart Extensions:', 'joocart'); ?></strong> <?php esc_html_e('Use OpenCart add-ons as WordPress widgets.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('SEO-Optimized:', 'joocart'); ?></strong> <?php esc_html_e('Integrated with WordPress SEO URLs for better visibility.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Smart Navigation:', 'joocart'); ?></strong> <?php esc_html_e('Link products, categories, and information seamlessly.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Shortcode Support:', 'joocart'); ?></strong> <?php esc_html_e('Easily add products to posts with a simple shortcode.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Admin Access Control:', 'joocart'); ?></strong> <?php esc_html_e('Restrict panel access based on user roles.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Flexible Layout Options:', 'joocart'); ?></strong> <?php esc_html_e('Show/hide OpenCart columns,header,footer and WordPress widgets.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Customizable Design:', 'joocart'); ?></strong> <?php esc_html_e('Modify button, menu, and template colors to match your brand.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Easy Installation or Connect with Existing OpenCart:', 'joocart'); ?></strong> <?php esc_html_e('One click easy installation or connect with your existing OpenCart setup.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✅ <strong><?php esc_html_e('Frequent Updates & Dedicated Support:', 'joocart'); ?></strong> <?php esc_html_e('Stay ahead with regular improvements.', 'joocart'); ?></li>
    <li style="margin-bottom: 8px;">✨ <strong><?php esc_html_e('And Many More!', 'joocart'); ?></strong></li>
</ul>

<p style="margin-top: 15px;">
    <a href="https://www.soft-php.com/joocart-wordpress-shopping-cart.html" 
       style="background: #e74c3c; color: #fff; padding: 10px 15px; text-decoration: none; border-radius: 5px; font-weight: bold;">
       <?php esc_html_e('Get JooCart Pro Now', 'joocart'); ?>
    </a>
</p>

	<table class="form-table" id="disabledtablepro">
		<tr style="display:none;" title="<?php esc_html_e('JooCart Pro Upgrade Package Download ID', 'joocart'); ?>">
			<th scope="row"><label for="joocart_upgrade_download_id"><?php esc_html_e('JooCart Pro Upgrade Package Download ID', 'joocart'); ?></label></th>
			<td><input name="joocart_upgrade_download_id" id="joocart_upgrade_download_id" value="00000" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('JooCart Pro Order Email', 'joocart'); ?>">
			<th scope="row"><label for="joocart_order_email"><?php esc_html_e('JooCart Order Email', 'joocart'); ?></label></th>
			<td><input name="joocart_order_email" id="joocart_order_email" value="free@soft-php.com" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select a WordPress user group who can access JooCart Admin Panel', 'joocart'); ?>">
			<th scope="row"><label for="joocart_who_can_access_admin"><?php esc_html_e('Show JooCart Admin Panel to', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_who_can_access_admin" name="joocart_who_can_access_admin">
				<?php foreach ($joocart_wp_user_groups as $joocart_wp_user_group) { ?>                
                <option <?php if(isset($joocart_who_can_access_admin) && $joocart_who_can_access_admin==$joocart_wp_user_group['wordpress_user_group_id']) { echo 'selected="selected"'; }?> value="<?php echo esc_html($joocart_wp_user_group['wordpress_user_group_id']); ?>"><?php echo esc_html($joocart_wp_user_group['name']); ?></option>
                <?php } ?>
			</select>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Use WordPress buttons for JooCart.If you set it to No then JooCart default button will be shown.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_wordpress_button"><?php esc_html_e('Use WordPress buttons', 'joocart'); ?></label></th>												
			<td>
			<input id="joocart_use_wordpress_button0" name="joocart_use_wordpress_button" value="1" <?php if(isset($joocart_use_wordpress_button) && $joocart_use_wordpress_button=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_wordpress_button0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_wordpress_button1" name="joocart_use_wordpress_button" value="0" <?php if(empty($joocart_use_wordpress_button) || $joocart_use_wordpress_button==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_wordpress_button1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Hide header of JooCart.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_dont_show_header"><?php esc_html_e('Hide header', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_dont_show_header" name="joocart_dont_show_header">
				<option value="0" <?php if(isset($joocart_dont_show_header) && $joocart_dont_show_header==="0") { echo 'selected="selected"'; }?>><?php esc_html_e('No,Don\'t Hide', 'joocart'); ?></option>
				<option value="1" <?php if(isset($joocart_dont_show_header) && $joocart_dont_show_header=="1") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,Hide Header', 'joocart'); ?></option>
				<option value="2" <?php if(isset($joocart_dont_show_header) && $joocart_dont_show_header=="2") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,Hide Header for JooCart Header Module', 'joocart'); ?></option>
			</select>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Hide footer of JooCart.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_dont_show_footer"><?php esc_html_e('Hide footer', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_dont_show_footer0" name="joocart_dont_show_footer" value="1" <?php if(isset($joocart_dont_show_footer) && $joocart_dont_show_footer=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_footer0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_dont_show_footer1" name="joocart_dont_show_footer" value="0" <?php if(empty($joocart_dont_show_footer) || $joocart_dont_show_footer==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_footer1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Hide Top Category Menu of JooCart.', 'joocart');?>">
			<th scope="row"><label for="joocart_dont_show_menus"><?php esc_html_e('Hide Top Category Menu', 'joocart');?></label></th>
			<td>
			<input id="joocart_dont_show_menus0" name="joocart_dont_show_menus" value="1" checked="checked" type="radio"><label for="joocart_dont_show_menus0">&nbsp;<?php esc_html_e('Yes', 'joocart');?></label>
			<input id="joocart_dont_show_menus1" name="joocart_dont_show_menus" value="0" <?php if(isset($joocart_dont_show_menus) && $joocart_dont_show_menus==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_menus1">&nbsp;<?php esc_html_e('No', 'joocart');?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Single Admin Login for JooCart and WordPress,If you set it to Yes,then you don\'t need to login in JooCart admin panel after you logged in WordPress.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_dont_show_admin_login"><?php esc_html_e('Single Admin Login', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_dont_show_admin_login0" name="joocart_dont_show_admin_login" value="1" <?php if(isset($joocart_dont_show_admin_login) && $joocart_dont_show_admin_login=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_admin_login0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_dont_show_admin_login1" name="joocart_dont_show_admin_login" value="0" <?php if(empty($joocart_dont_show_admin_login) || $joocart_dont_show_admin_login==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_admin_login1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>		
		<tr style="display:none;" title="<?php esc_html_e('If you alreay enabled javascript library of jQuery and Bootstrap for your site,then you can change it as required,othewise don\'t change it.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_dont_include_jquery"><?php esc_html_e('Include javascript library', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_dont_include_jquery" name="joocart_dont_include_jquery">
				<option value="0" <?php if(isset($joocart_dont_include_jquery) && $joocart_dont_include_jquery==="0") { echo 'selected="selected"'; }?>><?php esc_html_e('All', 'joocart'); ?></option>
				<option value="1" <?php if(isset($joocart_dont_include_jquery) && $joocart_dont_include_jquery=="1") { echo 'selected="selected"'; }?>><?php esc_html_e('Bootstrap only', 'joocart'); ?></option>
				<option value="2" <?php if(isset($joocart_dont_include_jquery) && $joocart_dont_include_jquery=="2") { echo 'selected="selected"'; }?>><?php esc_html_e('jQuery only', 'joocart'); ?></option>
				<option value="3" <?php if(isset($joocart_dont_include_jquery) && $joocart_dont_include_jquery=="3") { echo 'selected="selected"'; }?>><?php esc_html_e('None', 'joocart'); ?></option>
			</select>			
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('If you see Bootstrap Tooltip conflicts with MooTools etc, you can disable it.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_disable_bootstrap_tooltip"><?php esc_html_e('Disable Bootstrap Tooltip', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_disable_bootstrap_tooltip" name="joocart_disable_bootstrap_tooltip">
				<option value="0" <?php if(isset($joocart_disable_bootstrap_tooltip) && $joocart_disable_bootstrap_tooltip==="0") { echo 'selected="selected"'; }?>><?php esc_html_e('No', 'joocart'); ?></option>
				<option value="1" <?php if(isset($joocart_disable_bootstrap_tooltip) && $joocart_disable_bootstrap_tooltip=="1") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes', 'joocart'); ?></option>
				<option value="2" <?php if(isset($joocart_disable_bootstrap_tooltip) && $joocart_disable_bootstrap_tooltip=="2") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes for admin panel only', 'joocart'); ?></option>
				<option value="3" <?php if(isset($joocart_disable_bootstrap_tooltip) && $joocart_disable_bootstrap_tooltip=="3") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes for frontend only', 'joocart'); ?></option>
			</select>			
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('If you want to use third party extensions which uses $ as a jQuery variable or function name in custom js files,then set it to Yes.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_jquery_dollar"><?php esc_html_e('Use $ as a jQuery variable', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_use_jquery_dollar0" name="joocart_use_jquery_dollar" value="1" checked="checked" type="radio"><label for="joocart_use_jquery_dollar0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_jquery_dollar1" name="joocart_use_jquery_dollar" value="0" <?php if(isset($joocart_use_jquery_dollar) && $joocart_use_jquery_dollar==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_jquery_dollar1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Enable WordPress widget title.If you enable it then your JooCart WordPress widget title will come from WordPress widget title otherwise it will come from JooCart language file.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_enable_wp_widget_title"><?php esc_html_e('WordPress Widget Title', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_enable_wp_widget_title0" name="joocart_enable_wp_widget_title" value="1" checked="checked" type="radio"><label for="joocart_enable_wp_widget_title0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_enable_wp_widget_title1" name="joocart_enable_wp_widget_title" value="0" <?php if(isset($joocart_enable_wp_widget_title) && $joocart_enable_wp_widget_title==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_enable_wp_widget_title1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Hide left/right column of OpenCart,If you don\'t use wordpress left/right modules,then you can set it to No,otherwise no need to change this option.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_dont_show_left_right_column"><?php esc_html_e('Hide left/right column', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_dont_show_left_right_column0" name="joocart_dont_show_left_right_column" value="1" checked="checked" type="radio"><label for="joocart_dont_show_left_right_column0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_dont_show_left_right_column1" name="joocart_dont_show_left_right_column" value="0" <?php if(isset($joocart_dont_show_left_right_column) && $joocart_dont_show_left_right_column==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_dont_show_left_right_column1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<!-- <tr style="display:none;" title="<?php esc_html_e('Main http server URL for multistore or connecting JooCart with another opencart site etc.Need to put slash at the end(e.g.http://your-another-opencart-site.com/).If you don\'t sure,then keep it blank.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_main_http_server"><?php esc_html_e('Main Server URL', 'joocart'); ?></label></th>
			<td><input name="joocart_main_http_server" id="joocart_main_http_server" value="<?php if(isset($joocart_main_http_server)) { echo esc_html($joocart_main_http_server); }?>" class="regular-text" type="text"></td>
		</tr> -->
		<tr style="display:none;" title="<?php esc_html_e('If you want to redirect all JooCart multistore sites to Main Site,then set it to Yes.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_redirect_http_server"><?php esc_html_e('Redirect to Main Site', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_redirect_http_server0" name="joocart_redirect_http_server" value="1" <?php if(isset($joocart_redirect_http_server) && $joocart_redirect_http_server=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_redirect_http_server0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_redirect_http_server1" name="joocart_redirect_http_server" value="0" <?php if(empty($joocart_redirect_http_server) || $joocart_redirect_http_server==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_redirect_http_server1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('If you set it to Yes,then JooCart language will be set according to WordPress default language automatically.If you have single WordPress language and mulitple JooCart languages,then set it to No,otherwise set it to Yes', 'joocart'); ?>">
			<th scope="row"><label for="joocart_change_lang_to_default"><?php esc_html_e('Change Language to WP Default', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_change_lang_to_default0" name="joocart_change_lang_to_default" value="1" checked="checked" type="radio"><label for="joocart_change_lang_to_default0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_change_lang_to_default1" name="joocart_change_lang_to_default" value="0" <?php if(isset($joocart_change_lang_to_default) && $joocart_change_lang_to_default==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_change_lang_to_default1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Use Default Database.If you set to Yes,then below field\'s value will not be used.Do not change this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server or to enable Multistore ).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_wordpress_db"><?php esc_html_e('Use Default Database', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_use_wordpress_db0" name="joocart_use_wordpress_db" value="1" checked="checked" type="radio"><label for="joocart_use_wordpress_db0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_wordpress_db1" name="joocart_use_wordpress_db" value="0" <?php if(isset($joocart_use_wordpress_db) && $joocart_use_wordpress_db==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_wordpress_db1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('The username to access your database(JooCart). Do not edit this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_db_user_name"><?php esc_html_e('Database Username', 'joocart'); ?></label></th>
			<td><input name="joocart_db_user_name" id="joocart_db_user_name" value="<?php if(isset($joocart_db_user_name)) { echo esc_html($joocart_db_user_name); }?>" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('The password to access your database(JooCart). Do not edit this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_db_user_password"><?php esc_html_e('Database Password', 'joocart'); ?></label></th>
			<td><input name="joocart_db_user_password" id="joocart_db_user_password" value="<?php if(isset($joocart_db_user_password)) { echo esc_html($joocart_db_user_password); }?>" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('The hostname for your database(JooCart). Do not edit this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_db_user_host"><?php esc_html_e('Host', 'joocart'); ?></label></th>
			<td><input name="joocart_db_user_host" id="joocart_db_user_host" value="<?php if(isset($joocart_db_user_host)) { echo esc_html($joocart_db_user_host); }?>" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('The name for your database(JooCart). Do not edit this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_db_name"><?php esc_html_e('Database Name', 'joocart'); ?></label></th>	
			<td><input name="joocart_db_name" id="joocart_db_name" value="<?php if(isset($joocart_db_name)) { echo esc_html($joocart_db_name); }?>" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('The prefix used for your database(JooCart) tables. Do not edit this field unless absolutely necessary (e.g. to use a different database for JooCart from a different server).', 'joocart'); ?>">
			<th scope="row"><label for="joocart_db_user_prefix"><?php esc_html_e('Database Tables Prefix', 'joocart'); ?></label></th>
			<td><input name="joocart_db_user_prefix" id="joocart_db_user_prefix" value="<?php if(isset($joocart_db_user_prefix)) { echo esc_html($joocart_db_user_prefix); }?>" class="regular-text" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Show store logo in JooCart Header.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_show_logo_header"><?php esc_html_e('Show logo in JooCart header', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_show_logo_header0" name="joocart_show_logo_header" value="1" <?php if(isset($joocart_show_logo_header) && $joocart_show_logo_header=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_show_logo_header0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_show_logo_header1" name="joocart_show_logo_header" value="0" <?php if(empty($joocart_show_logo_header) || $joocart_show_logo_header==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_show_logo_header1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Use OpenCart third party template with or without Wordpress template for the store.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_oc_template"><?php esc_html_e('Use OpenCart template only', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_use_oc_template" name="joocart_use_oc_template">
				<option value="0" <?php if(isset($joocart_use_oc_template) && $joocart_use_oc_template==="0") { echo 'selected="selected"'; }?>><?php esc_html_e('No', 'joocart'); ?></option>
				<option value="1" <?php if(isset($joocart_use_oc_template) && $joocart_use_oc_template=="1") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,without WordPress template(Frontend)', 'joocart'); ?></option>
				<option value="2" <?php if(isset($joocart_use_oc_template) && $joocart_use_oc_template=="2") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,with Wordpress template(Frontend)', 'joocart'); ?></option>
				<option value="3" <?php if(isset($joocart_use_oc_template) && $joocart_use_oc_template=="3") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,without WordPress template(Backend)', 'joocart'); ?></option>
				<option value="4" <?php if(isset($joocart_use_oc_template) && $joocart_use_oc_template=="4") { echo 'selected="selected"'; }?>><?php esc_html_e('Yes,without WordPress template(Frontend & Backend)', 'joocart'); ?></option>
			</select>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('If you want to use different color for default template then set it to Yes.Then following values will be used.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_custom_color"><?php esc_html_e('Use Custom color', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_use_custom_color0" name="joocart_use_custom_color" value="1" <?php if(isset($joocart_use_custom_color) && $joocart_use_custom_color=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_custom_color0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_custom_color1" name="joocart_use_custom_color" value="0" <?php if(empty($joocart_use_custom_color) || $joocart_use_custom_color==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_custom_color1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select your text color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_txt_color"><?php esc_html_e('Text color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_txt_color" id="joocart_default_txt_color" value="<?php if(!empty($joocart_default_txt_color)) { echo esc_html($joocart_default_txt_color); } else { echo "000000"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select your link color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_link_color"><?php esc_html_e('Link color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_link_color" id="joocart_default_link_color" value="<?php if(!empty($joocart_default_link_color)) { echo esc_html($joocart_default_link_color); } else { echo "00A7E5"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select your link hover color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_link_hover_color"><?php esc_html_e('Link hover color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_link_hover_color" id="joocart_default_link_hover_color" value="<?php if(!empty($joocart_default_link_hover_color)) { echo esc_html($joocart_default_link_hover_color); } else { echo "267799"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select button,menu,box header color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_button_box_color"><?php esc_html_e('Button,menu,box color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_button_box_color" id="joocart_default_button_box_color" value="<?php if(!empty($joocart_default_button_box_color)) { echo esc_html($joocart_default_button_box_color); } else { echo "00A7E5"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select button,menu etc hover color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_button_hover_color"><?php esc_html_e('Button,menu hover color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_button_hover_color" id="joocart_default_button_hover_color" value="<?php if(!empty($joocart_default_button_hover_color)) { echo esc_html($joocart_default_button_hover_color); } else { echo "267799"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select button,menu,box etc text color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_button_txt_color"><?php esc_html_e('Button,menu text color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_button_txt_color" id="joocart_default_button_txt_color" value="<?php if(!empty($joocart_default_button_txt_color)) { echo esc_html($joocart_default_button_txt_color); } else { echo "FFFFFF"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select menu link color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_menu_link_color"><?php esc_html_e('Menu link color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_menu_link_color" id="joocart_default_menu_link_color" value="<?php if(!empty($joocart_default_menu_link_color)) { echo esc_html($joocart_default_menu_link_color); } else { echo "FFFFFF"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select menu link hover color for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_default_menu_link_hover_color"><?php esc_html_e('Menu link hover color', 'joocart'); ?></label></th>
			<td><input class="color" name="joocart_default_menu_link_hover_color" id="joocart_default_menu_link_hover_color" value="<?php if(!empty($joocart_default_menu_link_hover_color)) { echo esc_html($joocart_default_menu_link_hover_color); } else { echo "FFFFFF"; }?>" class="color" type="text"></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Use gradient color in button,menu,box etc for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_gradient_color"><?php esc_html_e('Use gradient color', 'joocart'); ?></label></th>												
			<td>
			<input id="joocart_use_gradient_color0" name="joocart_use_gradient_color" value="1" <?php if(isset($joocart_use_gradient_color) && $joocart_use_gradient_color=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_gradient_color0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_gradient_color1" name="joocart_use_gradient_color" value="0" <?php if(empty($joocart_use_gradient_color) || $joocart_use_gradient_color==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_gradient_color1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Put custom CSS for default template.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_custom_css_oc"><?php esc_html_e('Custom CSS', 'joocart'); ?></label></th>
			<td><textarea name="joocart_custom_css_oc" id="joocart_custom_css_oc"><?php if(!empty($joocart_custom_css_oc)) { echo esc_html($joocart_custom_css_oc); }?></textarea></td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Select SEO URL type for products and categories.', 'joocart'); ?>">
			<th scope="row"><label for="joocart_select_seo_for_prod_cat"><?php esc_html_e('SEO URL type for products and categories', 'joocart'); ?></label></th>
			<td>
			<select id="joocart_select_seo_for_prod_cat" name="joocart_select_seo_for_prod_cat">
				<option value="0" <?php if(isset($joocart_select_seo_for_prod_cat) && $joocart_select_seo_for_prod_cat==="0") { echo 'selected="selected"'; }?>><?php esc_html_e('Default SEO URL', 'joocart'); ?></option>
				<option value="1" <?php if(isset($joocart_select_seo_for_prod_cat) && $joocart_select_seo_for_prod_cat=="1") { echo 'selected="selected"'; }?>><?php esc_html_e('Short versions of the links', 'joocart'); ?></option>
				<option value="2" <?php if(isset($joocart_select_seo_for_prod_cat) && $joocart_select_seo_for_prod_cat=="2") { echo 'selected="selected"'; }?>><?php esc_html_e('Long versions of the links', 'joocart'); ?></option>
				<option value="3" <?php if(isset($joocart_select_seo_for_prod_cat) && $joocart_select_seo_for_prod_cat=="3") { echo 'selected="selected"'; }?>><?php esc_html_e('Short links for products and long links for categories', 'joocart'); ?></option>
			</select>			
			</td>
		</tr>
		<tr style="display:none;" title="<?php esc_html_e('Use dynamic URL for checkout and shopping cart URLS permanantly', 'joocart'); ?>">
			<th scope="row"><label for="joocart_use_dynamic_checkout_urls"><?php esc_html_e('Use dynamic checkout,cart URLS', 'joocart'); ?></label></th>
			<td>
			<input id="joocart_use_dynamic_checkout_urls0" name="joocart_use_dynamic_checkout_urls" value="1" <?php if(isset($joocart_use_dynamic_checkout_urls) && $joocart_use_dynamic_checkout_urls=="1") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_dynamic_checkout_urls0">&nbsp;<?php esc_html_e('Yes', 'joocart'); ?></label>
			<input id="joocart_use_dynamic_checkout_urls1" name="joocart_use_dynamic_checkout_urls" value="0" <?php if(empty($joocart_use_dynamic_checkout_urls) || $joocart_use_dynamic_checkout_urls==="0") { echo 'checked="checked"'; }?> type="radio"><label for="joocart_use_dynamic_checkout_urls1">&nbsp;<?php esc_html_e('No', 'joocart'); ?></label>
			</td>
		</tr>
	</table>
	</div>
	<p class="submit">
		<input type="submit" class="button-primary" value="<?php esc_html_e('Save Changes', 'joocart'); ?>" />
	</p>
</form>
</div>
<?php
wp_enqueue_script( 'joocart-admin-options-script', JOOCART_PLUGIN_URL . 'admin/view/javascript/custom/admin_options.js', array(), wp_get_wp_version(), true );
}
?>
