/*
  Jiffy Gallery Press -- WordPress plugin for setting up image galleries in a
                         jiffy via shortcodes associated with image slugs, and
                         for having the images load in a jiffy by downloading
                         only the minimum size image necessary for the client
                         viewport size.

  Copyright (C) 2016-2017  Marat Nepomnyashy  http://maratbn.com  maratbn@gmail

  Version:        1.1.0

  Module:         jiffy-gallery-press/jiffy-gallery-press.js

  Description:    Main JavaScript file for the WordPress plugin Jiffy Gallery Press.

  This file is part of Jiffy Gallery Press.

  Licensed under the GNU General Public License Version 3.

  Jiffy Gallery Press is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Jiffy Gallery Press is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Jiffy Gallery Press.  If not, see <http://www.gnu.org/licenses/>.
*/

window.JiffyGalleryPressLightbox = function (params) {

    var $         = params.$,
        ajax_url  = params.ajax_url,
        objTitles = params.titles;


    /*  The following is 'icons.svg' minified and URL-encoded.  It is encoded here so that it does
        not have to be loaded separately, and also because some web servers upload *.svg files with
        mime type 'text/plain', which prevents them from getting rendered in web browsers.

        Minified at:     http://www.webtoolkitonline.com/xml-minifier.html
        URL-encoded at:  http://codepen.io/yoksel/details/JDqvs/

        These icons are actually derivative works of Topcoat Icons
        taken from https://github.com/topcoat/icons/ and used here
        under the Apache License granted by Adobe Systems, which is
        listed below:

            Copyright (C) 2012 Adobe Systems Incorporated. All rights reserved.

                                         Apache License
                                   Version 2.0, January 2004
                                http://www.apache.org/licenses/

           TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

           1. Definitions.

              "License" shall mean the terms and conditions for use, reproduction,
              and distribution as defined by Sections 1 through 9 of this document.

              "Licensor" shall mean the copyright owner or entity authorized by
              the copyright owner that is granting the License.

              "Legal Entity" shall mean the union of the acting entity and all
              other entities that control, are controlled by, or are under common
              control with that entity. For the purposes of this definition,
              "control" means (i) the power, direct or indirect, to cause the
              direction or management of such entity, whether by contract or
              otherwise, or (ii) ownership of fifty percent (50%) or more of the
              outstanding shares, or (iii) beneficial ownership of such entity.

              "You" (or "Your") shall mean an individual or Legal Entity
              exercising permissions granted by this License.

              "Source" form shall mean the preferred form for making modifications,
              including but not limited to software source code, documentation
              source, and configuration files.

              "Object" form shall mean any form resulting from mechanical
              transformation or translation of a Source form, including but
              not limited to compiled object code, generated documentation,
              and conversions to other media types.

              "Work" shall mean the work of authorship, whether in Source or
              Object form, made available under the License, as indicated by a
              copyright notice that is included in or attached to the work
              (an example is provided in the Appendix below).

              "Derivative Works" shall mean any work, whether in Source or Object
              form, that is based on (or derived from) the Work and for which the
              editorial revisions, annotations, elaborations, or other modifications
              represent, as a whole, an original work of authorship. For the purposes
              of this License, Derivative Works shall not include works that remain
              separable from, or merely link (or bind by name) to the interfaces of,
              the Work and Derivative Works thereof.

              "Contribution" shall mean any work of authorship, including
              the original version of the Work and any modifications or additions
              to that Work or Derivative Works thereof, that is intentionally
              submitted to Licensor for inclusion in the Work by the copyright owner
              or by an individual or Legal Entity authorized to submit on behalf of
              the copyright owner. For the purposes of this definition, "submitted"
              means any form of electronic, verbal, or written communication sent
              to the Licensor or its representatives, including but not limited to
              communication on electronic mailing lists, source code control systems,
              and issue tracking systems that are managed by, or on behalf of, the
              Licensor for the purpose of discussing and improving the Work, but
              excluding communication that is conspicuously marked or otherwise
              designated in writing by the copyright owner as "Not a Contribution."

              "Contributor" shall mean Licensor and any individual or Legal Entity
              on behalf of whom a Contribution has been received by Licensor and
              subsequently incorporated within the Work.

           2. Grant of Copyright License. Subject to the terms and conditions of
              this License, each Contributor hereby grants to You a perpetual,
              worldwide, non-exclusive, no-charge, royalty-free, irrevocable
              copyright license to reproduce, prepare Derivative Works of,
              publicly display, publicly perform, sublicense, and distribute the
              Work and such Derivative Works in Source or Object form.

           3. Grant of Patent License. Subject to the terms and conditions of
              this License, each Contributor hereby grants to You a perpetual,
              worldwide, non-exclusive, no-charge, royalty-free, irrevocable
              (except as stated in this section) patent license to make, have made,
              use, offer to sell, sell, import, and otherwise transfer the Work,
              where such license applies only to those patent claims licensable
              by such Contributor that are necessarily infringed by their
              Contribution(s) alone or by combination of their Contribution(s)
              with the Work to which such Contribution(s) was submitted. If You
              institute patent litigation against any entity (including a
              cross-claim or counterclaim in a lawsuit) alleging that the Work
              or a Contribution incorporated within the Work constitutes direct
              or contributory patent infringement, then any patent licenses
              granted to You under this License for that Work shall terminate
              as of the date such litigation is filed.

           4. Redistribution. You may reproduce and distribute copies of the
              Work or Derivative Works thereof in any medium, with or without
              modifications, and in Source or Object form, provided that You
              meet the following conditions:

              (a) You must give any other recipients of the Work or
                  Derivative Works a copy of this License; and

              (b) You must cause any modified files to carry prominent notices
                  stating that You changed the files; and

              (c) You must retain, in the Source form of any Derivative Works
                  that You distribute, all copyright, patent, trademark, and
                  attribution notices from the Source form of the Work,
                  excluding those notices that do not pertain to any part of
                  the Derivative Works; and

              (d) If the Work includes a "NOTICE" text file as part of its
                  distribution, then any Derivative Works that You distribute must
                  include a readable copy of the attribution notices contained
                  within such NOTICE file, excluding those notices that do not
                  pertain to any part of the Derivative Works, in at least one
                  of the following places: within a NOTICE text file distributed
                  as part of the Derivative Works; within the Source form or
                  documentation, if provided along with the Derivative Works; or,
                  within a display generated by the Derivative Works, if and
                  wherever such third-party notices normally appear. The contents
                  of the NOTICE file are for informational purposes only and
                  do not modify the License. You may add Your own attribution
                  notices within Derivative Works that You distribute, alongside
                  or as an addendum to the NOTICE text from the Work, provided
                  that such additional attribution notices cannot be construed
                  as modifying the License.

              You may add Your own copyright statement to Your modifications and
              may provide additional or different license terms and conditions
              for use, reproduction, or distribution of Your modifications, or
              for any such Derivative Works as a whole, provided Your use,
              reproduction, and distribution of the Work otherwise complies with
              the conditions stated in this License.

           5. Submission of Contributions. Unless You explicitly state otherwise,
              any Contribution intentionally submitted for inclusion in the Work
              by You to the Licensor shall be under the terms and conditions of
              this License, without any additional terms or conditions.
              Notwithstanding the above, nothing herein shall supersede or modify
              the terms of any separate license agreement you may have executed
              with Licensor regarding such Contributions.

           6. Trademarks. This License does not grant permission to use the trade
              names, trademarks, service marks, or product names of the Licensor,
              except as required for reasonable and customary use in describing the
              origin of the Work and reproducing the content of the NOTICE file.

           7. Disclaimer of Warranty. Unless required by applicable law or
              agreed to in writing, Licensor provides the Work (and each
              Contributor provides its Contributions) on an "AS IS" BASIS,
              WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
              implied, including, without limitation, any warranties or conditions
              of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
              PARTICULAR PURPOSE. You are solely responsible for determining the
              appropriateness of using or redistributing the Work and assume any
              risks associated with Your exercise of permissions under this License.

           8. Limitation of Liability. In no event and under no legal theory,
              whether in tort (including negligence), contract, or otherwise,
              unless required by applicable law (such as deliberate and grossly
              negligent acts) or agreed to in writing, shall any Contributor be
              liable to You for damages, including any direct, indirect, special,
              incidental, or consequential damages of any character arising as a
              result of this License or out of the use or inability to use the
              Work (including but not limited to damages for loss of goodwill,
              work stoppage, computer failure or malfunction, or any and all
              other commercial damages or losses), even if such Contributor
              has been advised of the possibility of such damages.

           9. Accepting Warranty or Additional Liability. While redistributing
              the Work or Derivative Works thereof, You may choose to offer,
              and charge a fee for, acceptance of support, warranty, indemnity,
              or other liability obligations and/or rights consistent with this
              License. However, in accepting such obligations, You may act only
              on Your own behalf and on Your sole responsibility, not on behalf
              of any other Contributor, and only if You agree to indemnify,
              defend, and hold each Contributor harmless for any liability
              incurred by, or claims asserted against, such Contributor by reason
              of your accepting any such warranty or additional liability.

           END OF TERMS AND CONDITIONS

           APPENDIX: How to apply the Apache License to your work.

              To apply the Apache License to your work, attach the following
              boilerplate notice, with the fields enclosed by brackets "[]"
              replaced with your own identifying information. (Don't include
              the brackets!)  The text should be enclosed in the appropriate
              comment syntax for the file format. We also recommend that a
              file or class name and description of purpose be included on the
              same "printed page" as the copyright notice for easier
              identification within third-party archives.

           Copyright [yyyy] [name of copyright owner]

           Licensed under the Apache License, Version 2.0 (the "License");
           you may not use this file except in compliance with the License.
           You may obtain a copy of the License at

               http://www.apache.org/licenses/LICENSE-2.0

           Unless required by applicable law or agreed to in writing, software
           distributed under the License is distributed on an "AS IS" BASIS,
           WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
           See the License for the specific language governing permissions and
           limitations under the License.
        */
    url_icons = 'data:image/svg+xml,%3Csvg%20xmlns%3D%27http%3A//www.w3.org/2000/svg%27%20xmlns%3Axlink%3D%27http%3A//www.w3.org/1999/xlink%27%20width%3D%27400%27%20height%3D%27400%27%3E%3Cdef%3E%3Cpolygon%20id%3D%27prev_2%27%20fill-rule%3D%22evenodd%22%20points%3D%2227.066%2C1%207%2C21.068%2026.568%2C40.637%2031.502%2C35.704%2016.865%2C21.068%2032%2C5.933%20%22%20stroke%3D%27black%27%20stroke-width%3D%273%27%20transform%3D%27scale%282%29%27%20/%3E%3Cuse%20id%3D%27prev_2_white%27%20xlink%3Ahref%3D%27%23prev_2%27%20fill%3D%27white%27%20/%3E%3Cuse%20id%3D%27prev_2_red%27%20xlink%3Ahref%3D%27%23prev_2%27%20fill%3D%27red%27%20/%3E%3Cpolygon%20id%3D%27next_2%27%20fill-rule%3D%22evenodd%22%20points%3D%2213.933%2C1%2034%2C21.068%2014.431%2C40.637%209.498%2C35.704%2024.136%2C21.068%209%2C5.933%20%22%20stroke%3D%27black%27%20stroke-width%3D%273%27%20transform%3D%27scale%282%29%27%20/%3E%3Cuse%20id%3D%27next_2_white%27%20xlink%3Ahref%3D%27%23next_2%27%20fill%3D%27white%27%20/%3E%3Cuse%20id%3D%27next_2_red%27%20xlink%3Ahref%3D%27%23next_2%27%20fill%3D%27red%27%20/%3E%3Cpath%20id%3D%27close%27%20fill-rule%3D%22evenodd%22%20d%3D%22M21.002%2C26.588l10.357%2C10.604c1.039%2C1.072%2C1.715%2C1.083%2C2.773%2C0l2.078-2.128%20c1.018-1.042%2C1.087-1.726%2C0-2.839L25.245%2C21L36.211%2C9.775c1.027-1.055%2C1.047-1.767%2C0-2.84l-2.078-2.127%20c-1.078-1.104-1.744-1.053-2.773%2C0L21.002%2C15.412L10.645%2C4.809c-1.029-1.053-1.695-1.104-2.773%2C0L5.794%2C6.936%20c-1.048%2C1.073-1.029%2C1.785%2C0%2C2.84L16.759%2C21L5.794%2C32.225c-1.087%2C1.113-1.029%2C1.797%2C0%2C2.839l2.077%2C2.128%20c1.049%2C1.083%2C1.725%2C1.072%2C2.773%2C0L21.002%2C26.588z%22%20stroke%3D%27black%27%20stroke-width%3D%273%27%20/%3E%3Cuse%20id%3D%27close_1.5%27%20xlink%3Ahref%3D%27%23close%27%20transform%3D%27scale%281.5%29%27%20/%3E%3Cuse%20id%3D%27close_1.5_white%27%20xlink%3Ahref%3D%27%23close_1.5%27%20fill%3D%27white%27%20/%3E%3Cuse%20id%3D%27close_1.5_red%27%20xlink%3Ahref%3D%27%23close_1.5%27%20fill%3D%27red%27%20/%3E%3Cuse%20id%3D%27close_2%27%20xlink%3Ahref%3D%27%23close%27%20transform%3D%27scale%282%29%27%20/%3E%3Cuse%20id%3D%27close_2_white%27%20xlink%3Ahref%3D%27%23close_2%27%20fill%3D%27white%27%20/%3E%3Cuse%20id%3D%27close_2_red%27%20xlink%3Ahref%3D%27%23close_2%27%20fill%3D%27red%27%20/%3E%3C/def%3E%3Cuse%20xlink%3Ahref%3D%27%23prev_2_white%27%20y%3D%275%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23prev_2_red%27%20x%3D%2775%27%20y%3D%275%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23next_2_white%27%20y%3D%27100%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23next_2_red%27%20x%3D%2775%27%20y%3D%27100%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23close_2_white%27%20y%3D%27195%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23close_2_red%27%20x%3D%2775%27%20y%3D%27195%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23close_1.5_white%27%20x%3D%27150%27%20y%3D%27195%27%20/%3E%3Cuse%20xlink%3Ahref%3D%27%23close_1.5_red%27%20x%3D%27225%27%20y%3D%27195%27%20/%3E%3C/svg%3E';

    function _getSegment(arrHashSegments, regexSegmentFind) {
        if (!arrHashSegments) return null;

        for (var i = 0; i < arrHashSegments.length; i++) {
            var strSegment = arrHashSegments[i];
            if (!strSegment) continue;

            if (regexSegmentFind.test(strSegment)) return strSegment;
        }

        return null;
    }

    function _getSegmentValue(arrHashSegments, strSegmentFind) {
        var strSegment = _getSegment(arrHashSegments, strSegmentFind);
        if (!strSegment) return null;

        var indexEquals = strSegment.indexOf('=');
        if (indexEquals < 0) return null;

        return strSegment.substr(indexEquals+1);
    }

    function _getBrowseInfo() {
        var strHash = window.location.hash;
        if (!strHash) return null;

        var arrHashSegments = strHash.split('&');

        var strCloseup = _getSegment(arrHashSegments, /^#jgp_closeup$/i);
        if (!strCloseup) return null;

        var strItems = _getSegmentValue(arrHashSegments, /^items=\d+(,\d+)*$/i);
        if (!strItems) return null;

        var arrItems  = strItems.split(','),
            pos       = _getSegmentValue(arrHashSegments, /^pos=\d+$/i) || 0;

        var posPrev = pos - 1;
        if (posPrev < 0) posPrev = arrItems.length - 1;

        var posNext = window.parseInt(pos) + 1;
        if (posNext >= arrItems.length) posNext = 0;

        var strItemIDs = arrItems.join(',');

        return {frag_next:  '#jgp_closeup&pos=' + posNext + '&items=' + strItemIDs,
                frag_prev:  '#jgp_closeup&pos=' + posPrev + '&items=' + strItemIDs,
                pos:        pos,
                pos_next:   posNext,
                pos_prev:   posPrev,
                items:      arrItems};
    }


    var $body = $('body');

    var $divScreen  = $('<div>').css({'position':           'fixed',
                                      'top':                0,
                                      'left':               0,
                                      'bottom':             0,
                                      'right':              0,
                                      'background-color':   'black',
                                      'opacity':            0.95})
                                .appendTo($body),

        $divPhotoC  = $('<div>').css({'position':           'fixed',
                                      'top':                0,
                                      'left':               0,
                                      'bottom':             0,
                                      'right':              0})
                                .appendTo($body);


    var $divPhoto   = $('<div>').css({'width':              '100%',
                                      'height':             '100%',
                                      'background-position':
                                                            'center center',
                                      'background-repeat':  'no-repeat',
                                      'background-size':    'contain'})
                                .appendTo($divPhotoC),

        $divBrowser = $('<div>').css({'background-color':   'black',
                                      'opacity':            '0.7',
                                      'font-weight':        'bold',
                                      'position':           'absolute',
                                      'left':               0,
                                      'right':              0,
                                      'bottom':             0,
                                      'text-align':         'center'
                                    })
                                .appendTo($divPhotoC),

        $divStripLeft = $('<div>').css({'position':         'absolute',
                                        'top':              0,
                                        'left':             0,
                                        'bottom':           0,
                                        'width':            '80px'})
                                  .appendTo($divPhotoC),

        $divStripRight = $('<div>').css({'position':        'absolute',
                                         'top':             0,
                                         'right':           0,
                                         'bottom':          0,
                                         'width':           '80px'})
                                   .appendTo($divPhotoC);


    $('<a>').attr('href', '#jgp_close')
            .css({'display':             'block',
                  'width':               '50px',
                  'height':              '60px',
                  'background-image':    'url(' + url_icons + ')',
                  'background-position': '-157px -195px',
                  'background-repeat':   'no-repeat',
                  'position':            'absolute',
                  'top':                 '10px',
                  'right':               '10px'})
            .appendTo($divStripRight)


    var $divTitle   = $('<div>').css({'color':              'white'})
                                .appendTo($divBrowser),

        $aIconNext  = $('<a>').css({'display':              'block',
                                    'width':                '80px',
                                    'height':               '90px',
                                    'background-image':     'url(' + url_icons + ')',
                                    'background-position':  '5px -95px',
                                    'background-repeat':    'no-repeat',
                                    'position':             'absolute',
                                    'top':                  '50%',
                                    'margin-top':           '-45px'})
                              .appendTo($divStripRight),

        $aIconPrev  = $('<a>').css({'display':              'block',
                                    'width':                '80px',
                                    'height':               '90px',
                                    'background-image':     'url(' + url_icons + ')',
                                    'background-position':  '-7px 0px',
                                    'background-repeat':    'no-repeat',
                                    'position':             'absolute',
                                    'top':                  '50%',
                                    'margin-top':           '-45px'})
                              .appendTo($divStripLeft),

        $window     = $(window),

        $head       = $('head'),

        $metaA      = $('<meta>').attr({'name':             'apple-mobile-web-app-capable',
                                        'content':          'yes'}),

        $metaV      = $('<meta>').attr({'name':             'viewport',
                                        'content':          'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no'});


    function _updateCloseup(objBrowseInfo) {
        var $wpadminbar = $('#wpadminbar');
        if ($wpadminbar) {
            $wpadminbar.css('display', objBrowseInfo ? 'none' : "");
        }

        var $adminmenumain = $('#adminmenumain');
        if ($adminmenumain) {
            $adminmenumain.css('display', objBrowseInfo ? 'none' : "");
        }

        var strDisplay = objBrowseInfo ? "" : 'none';

        $divScreen.css('display', strDisplay);
        $divPhotoC.css('display', strDisplay);

        if (!objBrowseInfo) {
            $metaA.remove();
            $metaV.remove();
            return;
        }

        $metaA.appendTo($head);
        $metaV.appendTo($head);

        var idImage = objBrowseInfo.items[objBrowseInfo.pos];

        $divPhoto.css('background-image',
                      'url(' + ajax_url + '?action=jiffy_gallery_press__get_image&id='
                                        + idImage
                                        + '&width=' + $window.width()
                                        + '&height=' + $window.height() + ')');

        $divTitle.text(objTitles[idImage] || "");

        $aIconPrev.attr('href', objBrowseInfo.frag_prev);
        $aIconNext.attr('href', objBrowseInfo.frag_next);
    }

    function _processLinkClickNext(event) {
        if (!window.history ||
            !window.history.replaceState) return;

        var objBrowseInfo = _getBrowseInfo();
        if (!objBrowseInfo) return;

        event.preventDefault();

        window.history.replaceState(null, null, objBrowseInfo.frag_next);

        _updateCloseup(_getBrowseInfo());
    }

    function _processLinkClickPrev(event) {
        if (!window.history ||
            !window.history.replaceState) return;

        var objBrowseInfo = _getBrowseInfo();
        if (!objBrowseInfo) return;

        event.preventDefault();

        window.history.replaceState(null, null, objBrowseInfo.frag_prev);

        _updateCloseup(_getBrowseInfo());
    }

    $aIconNext.click(_processLinkClickNext);
    $aIconPrev.click(_processLinkClickPrev);

    function _processUrlFragment() {
        _updateCloseup(_getBrowseInfo());
    }
    _processUrlFragment();
    $window.on('hashchange', _processUrlFragment);
}
