document.addEventListener("DOMContentLoaded", function () {
    // یک تابع کمکی برای خواندن کوکی که خارج از رویداد کلیک تعریف شده
    function getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
    }

    document.body.addEventListener("click", function (e) {
        const link = e.target.closest("a");
        if (!link || !link.href) return;

        const targetUrl = link.href;
        const anchorText = link.textContent.trim();

        if (!targetUrl.startsWith(window.location.origin)) return;

        const sourcePage = window.location.origin + window.location.pathname;

        const cleanTargetUrl = targetUrl.split('#')[0];
        const cleanSourcePage = sourcePage.split('#')[0];
        const clickKey = cleanTargetUrl + "|" + cleanSourcePage + "|" + anchorText;

        // اولویت با کوکی است، اگر کوکی نبود از تنظیمات اولیه استفاده کن
        const cookieMethod = getCookie('jaycoto_storage_method');
        const method = cookieMethod || (typeof jaycoto_click_tracker !== 'undefined' ? jaycoto_click_tracker.storage : 'session');
        const storage = method === "local" ? localStorage : sessionStorage;

        const recentClicks = JSON.parse(storage.getItem("jaycoto_recent_clicks") || "[]");

        if (recentClicks.includes(clickKey)) return;

        recentClicks.push(clickKey);
        if (recentClicks.length > 100) recentClicks.shift();
        storage.setItem("jaycoto_recent_clicks", JSON.stringify(recentClicks));

        const formData = new FormData();
        formData.append("action", "jaycoto_track_click");
        formData.append("url", targetUrl);
        formData.append("text", anchorText);
        formData.append("source", sourcePage);
        formData.append("nonce", (typeof jaycoto_click_tracker !== 'undefined' ? jaycoto_click_tracker.nonce : ''));

// چک می‌کنیم که آیا اطلاعات ایجکس از PHP به درستی ارسال شده است یا خیر
if (typeof jaycoto_click_tracker === 'undefined' || !jaycoto_click_tracker.ajax_url) {
    return; 
}
navigator.sendBeacon(jaycoto_click_tracker.ajax_url, formData);

        
    });
});