<?php
/*
Plugin Name: Jay Console Tools
Description:ابزاری قدرتمند برای تحلیل کلمات کلیدی، انکر تکست‌ها و آمار کلیک در وردپرس. مناسب برای سئوکارها، نویسندگان محتوا و مدیران سایت.
Version: 2.1.1 
Author: jayarsiech
Author URI: https://instagram.com/jayarsiech
License: GPLv2 or later
Text Domain: jay-console-tools

*/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
require_once plugin_dir_path( __FILE__ ) . 'includes/jaycoto-click-tracking-db.php';
register_activation_hook( __FILE__, 'jaycoto_create_clicks_table' );

require_once plugin_dir_path( __FILE__ ) . 'includes/jaycoto-click-tracking-endpoint.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/jaycoto-jdf.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/ajax/jaycoto-anchor-load-more.php';


// افزودن متاباکس به نوشته‌ها
function jaycoto_add_keywords_metabox() {
	$screens = array( 'post', 'product' ); // ← حالا هم برای نوشته، هم محصول

	foreach ( $screens as $screen ) {
		add_meta_box(
			'jaycoto_keywords_box',
			'🎯 کلمات کلیدی هدف',
			'jaycoto_render_metabox',
			$screen,
			'side',
			'high'
		);
	}
}
add_action( 'add_meta_boxes', 'jaycoto_add_keywords_metabox' );

// افزودن فیلد به دسته‌ها
add_action( 'category_add_form_fields', 'jaycoto_add_term_keywords_field' );
add_action( 'category_edit_form_fields', 'jaycoto_edit_term_keywords_field' );
add_action( 'created_category', 'jaycoto_save_term_keywords' );
add_action( 'edited_category', 'jaycoto_save_term_keywords' );


function jaycoto_render_metabox( $post ) {
	$keywords       = jaycoto_get_keywords_for_object( $post->ID, 'post' );
	wp_nonce_field( 'jaycoto_save_keywords', 'jaycoto_keywords_nonce' );
	$all_keywords = jaycoto_get_all_keywords_except( $post->ID );

	echo '<input name="jaycoto_keywords" id="jaycoto_keywords_input" value="' . esc_attr( $keywords ) . '">';
	// نمایش پست‌های مرتبط
	$related_posts = jaycoto_get_related_posts_by_keywords( $post->ID );
	if ( ! empty( $related_posts ) ) {
		echo '<div style="margin-top:15px;"><strong>🔗 پست‌های مرتبط برای لینک‌سازی:</strong><ul>';
		foreach ( $related_posts as $related ) {
			$permalink = esc_url( get_permalink( $related->ID ) );
			$title     = esc_html( $related->post_title );

			echo '<li><span class="jaycoto-copy-related" data-link="' . esc_attr( $permalink ) . '" style="cursor:pointer; color:#2271b1; text-decoration:underline;">' . esc_html( $title ) . '</span></li>';
		}
		echo '</ul><div id="jaycoto-copy-feedback" style="color:green; margin-top:5px; display:none;">✅ لینک کپی شد</div></div>';

	}
	// بررسی کلمات تکراری
	if ( ! empty( $all_keywords ) ) {
		echo '<div id="jaycoto-duplicate-warning" style="margin-top: 10px; color: #cc0000; font-weight:bold;"></div>';
	}
	?>
	<p>هر کلمه رو با Enter اضافه کن (مثلاً: آموزش وردپرس ↵ سئو داخلی ↵)</p>
	<?php
}
function jaycoto_clear_anchor_cache_on_save( $post_id ) {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	if ( ! in_array( get_post_type( $post_id ), array( 'post', 'product' ), true ) ) {
		return;
	}
	delete_transient( 'jaycoto_anchor_analysis_data' );
}
add_action( 'save_post', 'jaycoto_clear_anchor_cache_on_save' );

// پست های مرتبط
function jaycoto_get_related_posts_by_keywords( $current_post_id ) {
	$cache_key  = "jaycoto_related_posts_{$current_post_id}";
	$cached_ids = wp_cache_get( $cache_key, 'jaycoto_keywords' );

	if ( false !== $cached_ids ) {
		if ( empty( $cached_ids ) ) {
			return array();
		}
		return get_posts(
			array(
				'post_type'      => array( 'post', 'product' ),
				'post_status'    => 'publish',
				'posts_per_page' => 10,
				'post__in'       => $cached_ids,
			)
		);
	}

	global $wpdb;
	$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';

	// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery
	$current_keywords = $wpdb->get_col( $wpdb->prepare( "SELECT keyword FROM {$table_name} WHERE object_id = %d AND object_type = 'post'", $current_post_id ) );

	if ( empty( $current_keywords ) ) {
		wp_cache_set( $cache_key, array(), 'jaycoto_keywords', HOUR_IN_SECONDS ); // کش کردن نتیجه خالی
		return array();
	}

	$placeholders = implode( ', ', array_fill( 0, count( $current_keywords ), '%s' ) );
	// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	$sql = $wpdb->prepare( "SELECT DISTINCT object_id FROM {$table_name} WHERE keyword IN ({$placeholders}) AND object_id != %d AND object_type = 'post'", array_merge( $current_keywords, array( $current_post_id ) ) );

	// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery
	$related_post_ids = $wpdb->get_col( $sql );
	wp_cache_set( $cache_key, $related_post_ids, 'jaycoto_keywords', HOUR_IN_SECONDS );

	if ( empty( $related_post_ids ) ) {
		return array();
	}

	return get_posts(
		array(
			'post_type'      => array( 'post', 'product' ),
			'post_status'    => 'publish',
			'posts_per_page' => 10,
			'post__in'       => $related_post_ids,
		)
	);
}
// ذخیره کردن کلیدواژه‌ها
function jaycoto_save_keywords( $post_id ) {
	if ( wp_is_post_revision( $post_id ) ) {
		return;
	}
	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	if ( ! isset( $_POST['jaycoto_keywords_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['jaycoto_keywords_nonce'] ) ), 'jaycoto_save_keywords' ) ) {
		return;
	}
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}

	global $wpdb;
	$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';

	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
	$wpdb->delete(
		$table_name,
		array(
			'object_id'   => $post_id,
			'object_type' => 'post',
		),
		array( '%d', '%s' )
	);

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	if ( isset( $_POST['jaycoto_keywords'] ) ) {
	    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$json_string = wp_unslash( $_POST['jaycoto_keywords'] );
		if ( ! empty( $json_string ) ) {
			$keywords_data = json_decode( $json_string, true );

			if ( is_array( $keywords_data ) ) {
				foreach ( $keywords_data as $keyword_item ) {
					if ( ! empty( $keyword_item['value'] ) ) {
						// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
						$wpdb->insert(
							$table_name,
							array(
								'object_id'   => $post_id,
								'keyword'     => sanitize_text_field( $keyword_item['value'] ),
								'object_type' => 'post',
							),
							array( '%d', '%s', '%s' )
						);
					}
				}
			}
		}
	}
	wp_cache_delete( "jaycoto_keywords_post_{$post_id}", 'jaycoto_keywords' );
	wp_cache_delete( "jaycoto_keywords_column_{$post_id}", 'jaycoto_keywords' );
	wp_cache_delete( "jaycoto_all_except_{$post_id}", 'jaycoto_keywords' );
	wp_cache_delete( 'jaycoto_all_except_0', 'jaycoto_keywords' );
	wp_cache_delete('jaycoto_keywords_list_' . md5(''), 'jaycoto_keywords');
	wp_cache_flush_group('jaycoto_keywords');

}
add_action( 'save_post', 'jaycoto_save_keywords' );

// اضافه کردن آیتم منوی مدیریت
function jaycoto_add_admin_menu() {
	add_menu_page( 'کلمات کلیدی هدف', 'جی کنسول<br><br>', 'manage_options', 'jaycoto_keywords_list', 'jaycoto_render_admin_page', plugin_dir_url( __FILE__ ) . 'assets/jayconsoletools32.png', 26 );
	add_submenu_page( 'jaycoto_keywords_list', 'تحلیل انکر تکست‌ها', ' انکر تکست‌ها', 'manage_options', 'jaycoto_anchor_analysis', 'jaycoto_render_anchor_analysis_page' );
	add_submenu_page( 'jaycoto_keywords_list', 'آمار کلیک‌ها', '📊 آمار کلیک‌ها', 'manage_options', 'jaycoto_click_stats', 'jaycoto_render_click_stats_page' );
	add_submenu_page(
		null,
		'جزئیات کلیک‌ها',
		'جزئیات کلیک‌ها',
		'manage_options',
		'jaycoto-click-details',
		function () {
			include plugin_dir_path( __FILE__ ) . 'admin/jaycoto-click-details.php';
		}
	);
}
add_action( 'admin_menu', 'jaycoto_add_admin_menu' );
// تغییر عنوان زیرمنوی اول بدون تکرار منوی اصلی
add_action(
	'admin_menu',
	function() {
		global $submenu;
		if ( isset( $submenu['jaycoto_keywords_list'][0] ) ) {
			$submenu['jaycoto_keywords_list'][0][0] = 'کلمات کلیدی مطالب';
		}
	},
	999
);

function jaycoto_render_click_stats_page() {
	require_once plugin_dir_path( __FILE__ ) . 'admin/jaycoto-click-stats-page.php';
}


// تنظیمات افزونه: افزودن زیرمنو
function jaycoto_add_click_settings_submenu() {
	add_submenu_page( 'jaycoto_keywords_list', 'تنظیمات کلیک', '🎯 تنظیمات کلیک', 'manage_options', 'jaycoto_click_settings', 'jaycoto_render_click_settings_page' );
}
add_action( 'admin_menu', 'jaycoto_add_click_settings_submenu' );

function jaycoto_render_click_settings_page() {

	// ابتدا چک می‌کنیم که آیا فرم با دکمه مشخص شده ما ارسال شده است یا خیر
	if ( isset( $_POST['jaycoto_submit_settings'] ) ) {
		// سپس نانس را به صورت الزامی و جداگانه بررسی می‌کنیم
		check_admin_referer( 'jaycoto_click_settings_action', 'jaycoto_settings_nonce' );

		if ( isset( $_POST['jaycoto_click_storage'] ) ) {
			$storage = sanitize_text_field( wp_unslash( $_POST['jaycoto_click_storage'] ) );
			update_option( 'jaycoto_click_storage_method', $storage );

			// این خط ضروری برای همگام‌سازی بین تب‌هاست
			setcookie( 'jaycoto_storage_method', $storage, time() + YEAR_IN_SECONDS, COOKIEPATH, COOKIE_DOMAIN );

			echo '<div class="notice notice-success"><p>✅ ذخیره شد.</p></div>';
		}
	}

	$current = get_option( 'jaycoto_click_storage_method', 'session' );
	?>
	<div class="wrap">
		<h1>⚙️ تنظیمات ذخیره‌سازی کلیک</h1>
		<form method="post">
			<?php wp_nonce_field( 'jaycoto_click_settings_action', 'jaycoto_settings_nonce' ); ?>
			<table class="form-table">
				<tr>
					<th scope="row">نوع ذخیره‌سازی کلیک‌ها</th>
					<td>
						<label><input type="radio" name="jaycoto_click_storage" value="session" <?php checked( $current, 'session' ); ?>> فقط در هر نشست (sessionStorage)</label><br>
						<label><input type="radio" name="jaycoto_click_storage" value="local" <?php checked( $current, 'local' ); ?>> یکبار در هر روز از یک لینک(localStorage)</label>
					</td>
				</tr>
			</table>
			<p><button type="submit" name="jaycoto_submit_settings" class="button button-primary">💾 ذخیره</button></p>
		</form>
	</div>
	<?php
}


// تحلیل
function jaycoto_render_anchor_analysis_page() {
	require_once plugin_dir_path( __FILE__ ) . 'admin/jaycoto-anchor-analysis-page.php';
}


// لود کردن فایل صفحه مدیریت
function jaycoto_render_admin_page() {
	require_once plugin_dir_path( __FILE__ ) . 'admin/jaycoto-keywords-list-page.php';
}

// بررسی کلمات تکراری
function jaycoto_get_all_keywords_except( $exclude_object_id = 0 ) {
	$cache_key      = "jaycoto_all_except_{$exclude_object_id}";
	$cached_results = wp_cache_get( $cache_key, 'jaycoto_keywords' );

	if ( false !== $cached_results ) {
		return $cached_results;
	}

	global $wpdb;
	$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';
	// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	$sql = "SELECT DISTINCT keyword FROM {$table_name} WHERE object_type = 'post'";

	if ( ! empty( $exclude_object_id ) ) {
		$sql .= $wpdb->prepare( ' AND object_id != %d', $exclude_object_id );
	}
	// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery
	$results = $wpdb->get_col( $sql );

	wp_cache_set( $cache_key, $results, 'jaycoto_keywords', HOUR_IN_SECONDS );

	return $results;
}
// برای دسته بندی ها
function jaycoto_add_term_keywords_field( $taxonomy ) {
	?>
	<div class="form-field term-group">
		<?php wp_nonce_field( 'jaycoto_save_term_keywords_action', 'jaycoto_term_nonce' ); ?>
		<label for="jaycoto_keywords"><?php esc_html_e( '🎯 کلمات کلیدی هدف', 'jay-console-tools' ); ?></label>
		<input type="text" name="jaycoto_keywords" id="jaycoto_keywords_input_term">
		<p class="description">هر کلمه را با Enter جدا کن</p>
	</div>
	<?php
}

function jaycoto_edit_term_keywords_field( $term ) {
	$meta = jaycoto_get_keywords_for_object( $term->term_id, 'term' );
	?>
	<tr class="form-field term-group-wrap">
		<th scope="row"><label for="jaycoto_keywords"><?php esc_html_e( '🎯 کلمات کلیدی هدف', 'jay-console-tools' ); ?></label></th>
		<td>
			<?php wp_nonce_field( 'jaycoto_save_term_keywords_action', 'jaycoto_term_nonce' ); ?>
			<input type="text" name="jaycoto_keywords" id="jaycoto_keywords_input_term" value="<?php echo esc_attr( $meta ); ?>">
			<div id="jaycoto-duplicate-warning" style="margin-top: 10px; color: #cc0000; font-weight:bold;"></div>
			<p class="description">هر کلمه را با Enter جدا کن</p>
		</td>
	</tr>
	<?php
}

function jaycoto_save_term_keywords( $term_id ) {
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	if ( ! isset( $_POST['jaycoto_term_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['jaycoto_term_nonce'] ) ), 'jaycoto_save_term_keywords_action' ) ) {
		return;
	}
	if ( ! current_user_can( 'manage_categories' ) ) {
		return;
	}

	global $wpdb;
	$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';

	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
	$wpdb->delete(
		$table_name,
		array(
			'object_id'   => $term_id,
			'object_type' => 'term',
		),
		array( '%d', '%s' )
	);

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	if ( isset( $_POST['jaycoto_keywords'] ) ) {
	    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$json_string = wp_unslash( $_POST['jaycoto_keywords'] );
		if ( ! empty( $json_string ) ) {
			$keywords_data = json_decode( $json_string, true );
			if ( is_array( $keywords_data ) ) {
				foreach ( $keywords_data as $keyword_item ) {
					if ( ! empty( $keyword_item['value'] ) ) {
						// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
						$wpdb->insert(
							$table_name,
							array(
								'object_id'   => $term_id,
								'keyword'     => sanitize_text_field( $keyword_item['value'] ),
								'object_type' => 'term',
							),
							array( '%d', '%s', '%s' )
						);
					}
				}
			}
		}
	}
	wp_cache_delete( "jaycoto_keywords_term_{$term_id}", 'jaycoto_keywords' );
	wp_cache_delete('jaycoto_keywords_list_' . md5(''), 'jaycoto_keywords');
	wp_cache_flush_group('jaycoto_keywords');
}


// افزودن ستون به post و product
function jaycoto_add_custom_column( $columns ) {
	$columns['jaycoto_keywords'] = '🎯 کلمات کلیدی هدف';
	return $columns;
}
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
add_filter( 'manage_post_posts_columns', 'jaycoto_add_custom_column' );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
add_filter( 'manage_product_posts_columns', 'jaycoto_add_custom_column' );

// مقداردهی به ستون
function jaycoto_render_custom_column( $column, $post_id ) {
	if ( 'jaycoto_keywords' === $column ) {
		$cache_key = "jaycoto_keywords_column_{$post_id}";
		$keywords  = wp_cache_get( $cache_key, 'jaycoto_keywords' );

		if ( false === $keywords ) {
			global $wpdb;
			$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';
			// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery
			$keywords = $wpdb->get_col( $wpdb->prepare( "SELECT keyword FROM {$table_name} WHERE object_id = %d AND object_type = 'post'", $post_id ) );
			wp_cache_set( $cache_key, $keywords, 'jaycoto_keywords', DAY_IN_SECONDS );
		}

		if ( ! empty( $keywords ) ) {
			foreach ( $keywords as $keyword ) {
				echo '<span style="background:#f3f3f3; border:1px solid #ccc; border-radius:4px; padding:2px 6px; margin:1px; display:inline-block;">' . esc_html( $keyword ) . '</span>';
			}
		} else {
			echo '<span style="color:red;">🔴 بدون کلیدواژه</span>';
		}
	}
}
add_action( 'manage_post_posts_custom_column', 'jaycoto_render_custom_column', 10, 2 );
add_action( 'manage_product_posts_custom_column', 'jaycoto_render_custom_column', 10, 2 );


// فایل ها
function jaycoto_enqueue_metabox_scripts( $hook ) {
	$screen = get_current_screen();
	$base   = plugin_dir_path( __FILE__ );
	$url    = plugin_dir_url( __FILE__ );

	// شرط برای پست‌ها و محصولات
	$is_post_edit = ( 'post.php' === $hook || 'post-new.php' === $hook );

	// شرط برای دسته‌بندی‌ها
	$is_category_edit = (
		( 'term.php' === $hook || 'edit-tags.php' === $hook ) &&
		isset( $screen->taxonomy ) &&
		'category' === $screen->taxonomy
	);

	if ( $is_post_edit || $is_category_edit ) {
		// بارگذاری نسخه محلی tagify
		wp_enqueue_script(
			'jaycoto-tagify-js',
			$url . 'js/tagify.min.js',
			array(),
			filemtime( $base . 'js/tagify.min.js' ),
			true
		);

		wp_enqueue_style(
			'jaycoto-tagify-css',
			$url . 'css/tagify.css',
			array(),
			filemtime( $base . 'css/tagify.css' )
		);
		wp_enqueue_script(
			'jaycoto-metabox',
			$url . 'js/metabox.js',
			array( 'jaycoto-tagify-js' ),
			filemtime( $base . 'js/metabox.js' ),
			true
		);
		// داده‌های لازم برای هشدار کلمه کلیدی تکراری را به اسکریپت پاس بده
		if ( $is_post_edit || $is_category_edit ) {
			$exclude_id = 0;
			// اگر در صفحه ویرایش نوشته بودیم، ID نوشته را بگیر
			if ( $is_post_edit ) {
				global $post;
				if ( $post ) {
					$exclude_id = $post->ID;
				}
			} elseif ( $is_category_edit ) {
   	           // phpcs:disable WordPress.Security.NonceVerification.Recommended
				if ( isset( $_GET['tag_ID'] ) ) {
					$exclude_id = intval( $_GET['tag_ID'] );
				}
				// phpcs:enable
}

			// لیست کلمات کلیدی موجود در پست‌های دیگر را بگیر
			$all_keywords = jaycoto_get_all_keywords_except( $exclude_id );
			$data         = 'window.jaycoto_existing_keywords = ' . wp_json_encode( $all_keywords ) . ';';
			wp_add_inline_script( 'jaycoto-metabox', $data, 'before' );
		}
	}
}
add_action( 'admin_enqueue_scripts', 'jaycoto_enqueue_metabox_scripts' );


function jaycoto_enqueue_admin_page_scripts( $hook ) {
	if ( 'toplevel_page_jaycoto_keywords_list' !== $hook ) {
		return;
	}

	$base = plugin_dir_path( __FILE__ );
	$url  = plugin_dir_url( __FILE__ );

	wp_enqueue_script(
		'jaycoto-admin-list',
		$url . 'js/admin-list.js',
		array(),
		filemtime( $base . 'js/admin-list.js' ),
		true
	);
	wp_enqueue_style( 'jaycoto-anchor-css', $url . 'css/anchor-analysis.css', array(), filemtime( $base . 'css/anchor-analysis.css' ) );

}

add_action( 'admin_enqueue_scripts', 'jaycoto_enqueue_admin_page_scripts' );

//فایل ها
function jaycoto_enqueue_anchor_analysis_assets( $hook ) {
    if ( strpos( $hook, 'jaycoto_anchor_analysis' ) !== false ) {
        $base = plugin_dir_path( __FILE__ );
        $url  = plugin_dir_url( __FILE__ );

        wp_enqueue_script( 'jaycoto-anchor-js', $url . 'js/anchor-analysis.js', array( 'wp-i18n' ), filemtime( $base . 'js/anchor-analysis.js' ), true );
        wp_enqueue_style( 'jaycoto-anchor-css', $url . 'css/anchor-analysis.css', array(), filemtime( $base . 'css/anchor-analysis.css' ) );

        // این بخش اضافه شد
        wp_localize_script(
            'jaycoto-anchor-js',
            'jaycoto_anchor_ajax',
            array(
                'nonce' => wp_create_nonce( 'jaycoto_anchor_analysis_nonce' ),
            )
        );
    }
}
add_action( 'admin_enqueue_scripts', 'jaycoto_enqueue_anchor_analysis_assets' );


//amar
function jaycoto_enqueue_click_analysis_assets( $hook ) { // هوک اضافه شد تا شرطی اجرا شود
	if ( strpos( $hook, 'jaycoto_click_stats' ) === false && strpos( $hook, 'jaycoto-click-details' ) === false ) {
		return;
	}

	$base = plugin_dir_path( __FILE__ );
	$url  = plugin_dir_url( __FILE__ );

	wp_enqueue_script( 'jaycoto-click-admin-js', $url . 'js/amarclick_admin.js', array(), filemtime( $base . 'js/amarclick_admin.js' ), true ); // تغییر نام شناسه
	wp_enqueue_style( 'jaycoto-click-admin-css', $url . 'css/amarclick_admin.css', array(), filemtime( $base . 'css/amarclick_admin.css' ) ); // تغییر نام شناسه
}
add_action( 'admin_enqueue_scripts', 'jaycoto_enqueue_click_analysis_assets' );

// فایل کلیک
function jaycoto_enqueue_front_click_tracker() {
	wp_enqueue_script(
		'jaycoto-click-tracker',
		plugin_dir_url( __FILE__ ) . 'js/click-tracker.js',
		array(),
		filemtime( plugin_dir_path( __FILE__ ) . 'js/click-tracker.js' ),
		true
	);

	wp_localize_script(
		'jaycoto-click-tracker',
		'jaycoto_click_tracker',
		array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'storage'  => get_option( 'jaycoto_click_storage_method', 'session' ),
			'nonce'    => wp_create_nonce( 'jaycoto_track_click_nonce' ),
		)
	);
}
add_action( 'wp_enqueue_scripts', 'jaycoto_enqueue_front_click_tracker' );


//فایل تاریخ
function jaycoto_add_persian_datepicker_assets( $hook ) { // تغییر نام تابع
	// فقط در صفحه آمار کلیک‌ها
	if ( strpos( $hook, 'jaycoto_click_stats' ) !== false || strpos( $hook, 'jaycoto-click-details' ) !== false ) {
		$base = plugin_dir_path( __FILE__ );
		$url  = plugin_dir_url( __FILE__ );

		wp_enqueue_style( 'jaycoto-persian-datepicker-style', $url . 'css/persianDatepicker.css', array(), filemtime( $base . 'css/persianDatepicker.css' ) ); // تغییر نام و افزودن ورژن
		wp_enqueue_script( 'jaycoto-persian-datepicker-script', $url . 'js/persianDatepicker.min.js', array( 'jquery' ), filemtime( $base . 'js/persianDatepicker.min.js' ), true ); // تغییر نام و افزودن ورژن

		wp_add_inline_script(
			'jaycoto-persian-datepicker-script',
			" // تغییر نام شناسه
			function initPersianDatepicker(selector) {
				jQuery(selector).persianDatepicker({
					initialValue: false,
					format: 'YYYY/MM/DD',
					minDate: null,
					endDate: '1424/05/05'
				});
			} 

			jQuery(document).ready(function($) {
				initPersianDatepicker('.persian-date');
			});
		"
		);
	}
}
add_action( 'admin_enqueue_scripts', 'jaycoto_add_persian_datepicker_assets' );

function jaycoto_get_keywords_for_object( $object_id, $object_type ) {
	$cache_key       = "jaycoto_keywords_{$object_type}_{$object_id}";
	$cached_keywords = wp_cache_get( $cache_key, 'jaycoto_keywords' );

	if ( false !== $cached_keywords ) {
		return $cached_keywords;
	}

	global $wpdb;
	$table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';

	// phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery
	$keywords = $wpdb->get_col(
		$wpdb->prepare(
			"SELECT keyword FROM {$table_name} WHERE object_id = %d AND object_type = %s",
			$object_id,
			$object_type
		)
	);
	// phpcs:enable

	if ( empty( $keywords ) ) {
		$json_output = '[]';
	} else {
		$tagify_format = array_map(
			function( $kw ) {
				return array( 'value' => $kw );
			},
			$keywords
		);
		$json_output   = wp_json_encode( $tagify_format );
	}

	wp_cache_set( $cache_key, $json_output, 'jaycoto_keywords', HOUR_IN_SECONDS );

	return $json_output;
}