<?php
// ذخیره کلیک از طریق AJAX
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

add_action('wp_ajax_jaycoto_track_click', 'jaycoto_track_click_handler');
add_action('wp_ajax_nopriv_jaycoto_track_click', 'jaycoto_track_click_handler');

function jaycoto_track_click_handler() {
// قدم اول: بررسی نانس به صورت جداگانه
if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'jaycoto_track_click_nonce' ) ) {
    wp_send_json_error( 'Nonce نامعتبر است.' );
    return;
}

// قدم دوم: بررسی وجود بقیه پارامترها
if ( ! isset( $_POST['url'], $_POST['text'], $_POST['source'] ) ) {
    wp_send_json_error( 'پارامترهای ورودی ناقص است.' );
    return;
}
 
    global $wpdb;

    $table = $wpdb->prefix . 'jay_jaycoto_clicks';

    // پاک‌سازی و امن‌سازی داده‌ها
    $url    = esc_url_raw( wp_unslash( $_POST['url'] ) );
    $text   = sanitize_text_field( wp_unslash( $_POST['text'] ) );
    $source = esc_url_raw( wp_unslash( $_POST['source'] ) );
    $today  = current_time( 'Y-m-d' );

    // phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $sql = $wpdb->prepare(
        "INSERT INTO {$table} (anchor_text, target_url, source_page, click_date, click_count) VALUES (%s, %s, %s, %s, 1)
        ON DUPLICATE KEY UPDATE click_count = click_count + 1",
        $text,
        $url,
        $source,
        $today
    );
    // phpcs:enable
    
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query($sql);
    // phpcs:enable

    wp_send_json_success('ثبت شد');
}