<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function jaycoto_create_clicks_table() {
    global $wpdb;
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    $charset_collate = $wpdb->get_charset_collate();

    // --- جدول قبلی برای کلیک‌ها ---
    $table_clicks = $wpdb->prefix . 'jay_jaycoto_clicks';
    $sql_clicks = "CREATE TABLE $table_clicks (
        id BIGINT(20) NOT NULL AUTO_INCREMENT,
        anchor_text TEXT NOT NULL,
        target_url TEXT NOT NULL,
        source_page TEXT NOT NULL,
        click_date DATE NOT NULL,
        click_count INT DEFAULT 1,
        PRIMARY KEY  (id),
        UNIQUE KEY unique_click (click_date, anchor_text(100), target_url(100), source_page(100))
    ) $charset_collate;";
    dbDelta($sql_clicks);

    // --- جدول جدید و بهینه برای کلمات کلیدی ---
    $table_keywords = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';
    $sql_keywords = "CREATE TABLE $table_keywords (
        relation_id BIGINT(20) NOT NULL AUTO_INCREMENT,
        object_id BIGINT(20) NOT NULL,
        keyword VARCHAR(200) NOT NULL,
        object_type VARCHAR(20) NOT NULL,
        PRIMARY KEY  (relation_id),
        KEY object_id (object_id),
        KEY keyword (keyword)
    ) $charset_collate;";
    dbDelta($sql_keywords);
}