<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// phpcs:disable WordPress.Security.NonceVerification.Recommended
// تنظیمات اولیه
$paged    = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$per_page = 10;
$offset   = ($paged - 1) * $per_page;
$search   = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
// phpcs:enable WordPress.Security.NonceVerification.Recommended
// ساخت کلید کش بر اساس جستجو
$cache_key = 'jaycoto_keywords_list_' . md5($search);
$cache_group = 'jaycoto_keywords';
$cached_data = wp_cache_get($cache_key, $cache_group);

if (false !== $cached_data) { 
    $combined_items = $cached_data['items'];
    $total_items = $cached_data['total'];
} else {
    global $wpdb;
    $table_name = $wpdb->prefix . 'jay_jaycoto_keyword_relationships';

    $sql = "SELECT object_id, object_type, keyword FROM {$table_name}";
    if (!empty($search)) {
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $sql = $wpdb->prepare("SELECT object_id, object_type, keyword FROM {$table_name} WHERE keyword LIKE %s", '%' . $wpdb->esc_like($search) . '%');
    }

    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
    $all_keywords_results = $wpdb->get_results($sql);

    $items_by_id = [];
    foreach ($all_keywords_results as $row) {
        if (!isset($items_by_id[$row->object_id])) {
            $items_by_id[$row->object_id] = [
                'type'     => $row->object_type,
                'keywords' => [],
            ];
        }
        $items_by_id[$row->object_id]['keywords'][] = $row->keyword;
    }

    $post_ids = [];
    $term_ids = [];
    foreach ($items_by_id as $id => $data) {
        if ('post' === $data['type']) {
            $post_ids[] = $id;
        } elseif ('term' === $data['type']) {
            $term_ids[] = $id;
        }
    }

    $combined_items = [];

    if (!empty($post_ids)) {
        $posts = get_posts(['post__in' => $post_ids, 'post_type' => ['post', 'product'], 'posts_per_page' => -1]);
        foreach ($posts as $post) {
            $combined_items[] = [
                'type'     => 'post',
                'title'    => $post->post_title,
                'keywords' => $items_by_id[$post->ID]['keywords'],
                'link'     => get_permalink($post->ID),
                'edit'     => get_edit_post_link($post->ID),
            ];
        }
    }

    if (!empty($term_ids)) {
        $terms = get_terms(['taxonomy' => 'category', 'include' => $term_ids]);
        foreach ($terms as $term) {
            $combined_items[] = [
                'type'     => 'term',
                'title'    => $term->name . ' (دسته)',
                'keywords' => $items_by_id[$term->term_id]['keywords'],
                'link'     => get_term_link($term),
                'edit'     => get_edit_term_link($term->term_id),
            ];
        }
    }

    usort($combined_items, function($a, $b) {
        return strcmp($a['title'], $b['title']);
    });

    $total_items = count($combined_items);
    wp_cache_set($cache_key, ['items' => $combined_items, 'total' => $total_items], $cache_group, HOUR_IN_SECONDS);
}

// صفحه‌بندی
$total_pages    = ceil($total_items / $per_page);
$combined_items = array_slice($combined_items, $offset, $per_page);
// شمارنده ردیف
$row_index = $offset + 1;

?>
<div class="wrap">
    <h1>🎯 کلمات کلیدی هدف نوشته‌ها</h1>
<form id="jaycoto-search-form" method="get" action="">
    <input type="hidden" name="page" value="jaycoto_keywords_list">
    <input type="text" id="jaycoto-search" name="s" value="<?php echo esc_attr($search); ?>" placeholder="جستجو در کلمات کلیدی..." style="width: 300px; margin-bottom: 20px;" />
    <button type="submit" class="button">جستجو</button>
</form>


    <table class="widefat fixed" id="jaycoto-table">
        <thead>
            <tr>
                <th>ردیف</th>
                <th>عنوان نوشته</th>
                <th>کلمات کلیدی هدف</th>
                <th>پیوند یکتا</th>
                <th>لینک</th>
                
            </tr>
        </thead>
        <tbody>
          

<?php foreach ($combined_items as $item): ?>
<tr>
<td><?php echo esc_html($row_index++); ?></td>
    <td><?php echo esc_html($item['title']); ?></td>
    <td>
    <?php
if (is_array($item['keywords'])) {
    foreach ($item['keywords'] as $keyword) {
        echo '<span style="display:inline-block; background:#f3f3f3; border:1px solid #ccc; border-radius:4px; padding:2px 6px; margin:2px; font-size:12px;">' . esc_html($keyword) . '</span>';
    }
}
?>
    </td>
    <td>
        <a href="<?php echo esc_url($item['link']); ?>" target="_blank">لینک</a>
        <button class="jaycoto-copy-button" data-link="<?php echo esc_url($item['link']); ?>" style="margin-left:5px;">📋</button>
    </td>
    <td>
        <a href="<?php echo esc_url($item['edit']); ?>">ویرایش</a>
    </td>
</tr>
<?php endforeach; ?>


        </tbody>
        
    </table>
<?php if ($total_pages > 1): ?>
    <div id="jaycoto-keyword-pagination" style="text-align:center; margin-top:20px;">
        <?php
        $base_url = remove_query_arg(['paged', 's']);
        $range = 2; // چند شماره صفحه اطراف صفحه جاری نمایش داده بشه

        // دکمه قبلی
        if ($paged > 1) {
            $prev_url = add_query_arg(['paged' => $paged - 1, 's' => $search], $base_url);
            echo '<a class="button" href="' . esc_url($prev_url) . '">◀ قبلی</a>';
        }

        // اعداد صفحه
        for ($i = max(1, $paged - $range); $i <= min($total_pages, $paged + $range); $i++) {
            $url = add_query_arg(['paged' => $i, 's' => $search], $base_url);
            $class = ($i === $paged) ? 'button button-primary' : 'button';
            echo '<a class="' . esc_attr($class) . '" href="' . esc_url($url) . '" style="margin: 0 3px;">' . esc_html($i) . '</a>';
        }

        // دکمه بعدی
        if ($paged < $total_pages) {
            $next_url = add_query_arg(['paged' => $paged + 1, 's' => $search], $base_url);
            echo '<a class="button" href="' . esc_url($next_url) . '">بعدی ▶</a>';
        }
        ?>
    </div>
<?php endif; ?>


</div>
