<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (!current_user_can('edit_published_posts')) {
	wp_die('شما اجازه دسترسی به این بخش را ندارید.');
}

global $wpdb;
$table = esc_sql($wpdb->prefix . 'jay_jaycoto_clicks');
require_once plugin_dir_path(__FILE__) . '../includes/jaycoto-jdf.php';

// phpcs:disable WordPress.Security.NonceVerification.Recommended
$date_filter = '';
$where_clauses = [];
$params = [];

if (!empty($_GET['click_date'])) {
	$date_filter = sanitize_text_field(wp_unslash($_GET['click_date']));
	list($jy, $jm, $jd) = explode('/', $date_filter);
	$gregorian = jaycoto_jalali_to_gregorian((int)$jy, (int)$jm, (int)$jd);
	$date_g = sprintf('%04d-%02d-%02d', $gregorian[0], $gregorian[1], $gregorian[2]);

	$where_clauses[] = "click_date = %s";
	$params[] = $date_g;

} elseif (!empty($_GET['range_days'])) {
	$days = intval($_GET['range_days']);
	$date_from = gmdate('Y-m-d', strtotime("-$days days"));

	$where_clauses[] = "click_date >= %s";
	$params[] = $date_from;
}

$orderby_param = isset($_GET['orderby']) ? sanitize_text_field(wp_unslash($_GET['orderby'])) : '';
$order_param   = isset($_GET['order']) ? sanitize_text_field(wp_unslash($_GET['order'])) : '';
// phpcs:enable WordPress.Security.NonceVerification.Recommended

$where_sql = '';
if ( ! empty( $where_clauses ) ) {
	$where_sql = "WHERE " . implode( ' AND ', $where_clauses );
}


// حذف آمار قدیمی اگر دکمه کلیک شده بود
if (isset($_GET['delete_old_clicks']) && current_user_can('edit_published_posts')) {
	check_admin_referer('jaycoto_delete_old_clicks_action', '_jaycoto_delete_nonce');

	$six_months_ago = gmdate('Y-m-d', strtotime('-6 months'));
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	$deleted = $wpdb->query(
		$wpdb->prepare("DELETE FROM {$wpdb->prefix}jay_jaycoto_clicks WHERE click_date < %s", $six_months_ago)
	);

	echo '<div class="notice notice-success"><p>' . esc_html($deleted) . ' ردیف قدیمی حذف شد.</p></div>';
	wp_cache_flush_group('jaycoto_clicks');
}

$per_page = 10;
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$paged = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$offset = ($paged - 1) * $per_page;

// ساخت کلید کش بر اساس فیلترها و مرتب‌سازی
$cache_key_params = array_merge($params, [
	'orderby' => $orderby_param,
	'order'   => $order_param,
]);
$cache_key = 'jaycoto_click_stats_' . md5(wp_json_encode($cache_key_params));
$cache_group = 'jaycoto_clicks';
$results = wp_cache_get($cache_key, $cache_group);

if (false === $results) {
	$sql = "SELECT * FROM {$table} {$where_sql} ORDER BY click_date DESC, click_count DESC";

	if (!empty($params)) {
		// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$results = $wpdb->get_results($wpdb->prepare($sql, $params));
	} else {
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
		$results = $wpdb->get_results($sql);
	}
	wp_cache_set($cache_key, $results, $cache_group, HOUR_IN_SECONDS);
}

// مرتب‌سازی نتایج (این بخش خارج از کش انجام می‌شود تا انعطاف‌پذیر باشد)
if ('clicks' === $orderby_param) {
	usort($results, function ($a, $b) {
		return $b->click_count - $a->click_count;
	});
} else {
	usort($results, function ($a, $b) {
		return strcmp($a->anchor_text, $b->anchor_text);
	});
}

// گروه بندی نتایج بر اساس anchor_text
$grouped_results = [];
foreach ($results as $row) {
	$key = $row->anchor_text . '|' . $row->target_url . '|' . $row->source_page . '|' . $row->click_date;
	
	if (!isset($grouped_results[$row->anchor_text])) {
		$grouped_results[$row->anchor_text] = [
			'anchor_text' => $row->anchor_text,
			'click_count' => 0,
			'details'     => []
		];
	}
	
	$grouped_results[$row->anchor_text]['click_count'] += $row->click_count;

	if (!isset($grouped_results[$row->anchor_text]['details'][$key])) {
		$grouped_results[$row->anchor_text]['details'][$key] = [
			'target_url'  => urldecode($row->target_url),
			'source_page' => urldecode($row->source_page),
			'click_date'  => jaycoto_jdate('Y/m/d', strtotime($row->click_date)),
			'click_count' => $row->click_count
		];
	} else {
		$grouped_results[$row->anchor_text]['details'][$key]['click_count'] += $row->click_count;
	}
}

// مرتب‌سازی details بر اساس click_date نزولی
foreach ($grouped_results as &$group) {
	uasort($group['details'], function ($a, $b) {
		return strtotime($b['click_date']) - strtotime($a['click_date']);
	});
}
unset($group);

// مرتب‌سازی نهایی
$order_by = 'clicks' === $orderby_param ? 'click_count' : 'anchor_text';
$order    = 'asc' === strtolower($order_param) ? 'ASC' : 'DESC';

uasort($grouped_results, function ($a, $b) use ($order_by, $order) {
	if ($order_by === 'click_count') {
		return $order === 'ASC' ? $a['click_count'] - $b['click_count'] : $b['click_count'] - $a['click_count'];
	} else {
		return $order === 'ASC' ? strcmp($a['anchor_text'], $b['anchor_text']) : strcmp($b['anchor_text'], $a['anchor_text']);
	}
});

$total_rows = count($grouped_results);
$total_pages = ceil($total_rows / $per_page);

$paged_results = array_slice($grouped_results, $offset, $per_page, true);

?>

<div class="wrap">
	<h1>📊 آمار کلیک‌ها</h1>

	<form method="get" style="margin-bottom:20px; display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
		<input type="hidden" name="page" value="jaycoto_click_stats">
		<label>فیلتر تاریخ (شمسی):</label>
		<input type="text" name="click_date" id="click-date-input" class="persian-date" value="<?php echo esc_attr($date_filter); ?>" placeholder="مثلاً 1403/03/01" autocomplete="off">
		<button class="button">فیلتر</button>
		<?php if ($date_filter): ?>
			<a href="<?php echo esc_url(admin_url('admin.php?page=jaycoto_click_stats')); ?>" class="button">ریست</a>
		<?php endif; ?>

		<?php
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$active_range = isset($_GET['range_days']) ? intval($_GET['range_days']) : 0;
		?>
		<button type="button" class="button button-secondary quick-range <?php echo ($active_range === 1) ? 'active' : ''; ?>" data-days="1">🕐 ۲۴ ساعت</button>
		<button type="button" class="button button-secondary quick-range <?php echo ($active_range === 7) ? 'active' : ''; ?>" data-days="7">🗓 ۷ روز</button>
		<button type="button" class="button button-secondary quick-range <?php echo ($active_range === 28) ? 'active' : ''; ?>" data-days="28">📅 ۲۸ روز</button>
		<button type="button" class="button button-secondary quick-range <?php echo ($active_range === 90) ? 'active' : ''; ?>" data-days="90">🗓 ۳ ماه</button>
	</form>

	<?php
	$delete_url = wp_nonce_url(
		admin_url('admin.php?page=jaycoto_click_stats&delete_old_clicks=1'),
		'jaycoto_delete_old_clicks_action',
		'_jaycoto_delete_nonce'
	);
	?>
	<p style="margin-top: 10px;">
		<a href="<?php echo esc_url($delete_url); ?>" class="button button-secondary" onclick="return confirm('آیا مطمئن هستید؟ این کار قابل بازگشت نیست.')">🧹 حذف آمار قدیمی‌تر از ۶ ماه</a>
	</p>

	<?php if (!empty($paged_results)): ?>
		<p style="margin:10px 0; font-weight:bold;">🔢 تعداد رکوردهای یافت‌شده: <?php echo esc_html($total_rows); ?></p>

		<table class="widefat striped" id="jaycoto-clicks-table">
			<thead>
				<tr>
					<th>#</th>
					<th>📌 متن لینک</th>
					<th id="jaycoto-sort-clicks" style="cursor: pointer; color: #0073aa;" title="مرتب‌سازی تعداد کلیک">🔢 تعداد کلیک</th>
					<th>جزئیات</th>
				</tr>
			</thead>
			<tbody>
				<?php $row_number = ($paged - 1) * $per_page + 1; ?>
				<?php foreach ($paged_results as $anchor_text => $data): ?>
					<tr>
						<td><?php echo esc_html($row_number++); ?></td>
						<td><?php echo esc_html($data['anchor_text']); ?></td>
						<td><?php echo esc_html($data['click_count']); ?></td>
						<td>
							<?php
							$filter_query = '';
							if (!empty($date_filter)) {
								$filter_query = '&click_date=' . urlencode($date_filter);
							// phpcs:ignore WordPress.Security.NonceVerification.Recommended
							} elseif (!empty($_GET['range_days'])) {
								// phpcs:ignore WordPress.Security.NonceVerification.Recommended
								$filter_query = '&range_days=' . intval($_GET['range_days']);
							}
							?>
							<a href="<?php echo esc_url(admin_url('admin.php?page=jaycoto-click-details&anchor_text=' . urlencode($anchor_text) . $filter_query)); ?>" class="button">مشاهده</a>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<?php if ($total_pages > 1): ?>
			<div style="margin-top: 20px; text-align:center;display: flex;justify-content: center;align-items: center;gap: 5px;">
				<?php
				$base_url = remove_query_arg('paged');
				$range = 2;

				if ($paged > 1) {
					echo '<a class="button" href="' . esc_url(add_query_arg('paged', $paged - 1, $base_url)) . '">◀ قبلی</a>';
				}

				for ($i = max(1, $paged - $range); $i <= min($total_pages, $paged + $range); $i++) {
					$class = ($i == $paged) ? 'button button-primary' : 'button';
					echo '<a class="' . esc_attr($class) . '" href="' . esc_url(add_query_arg('paged', $i, $base_url)) . '">' . esc_html($i) . '</a>';
				}

				if ($paged < $total_pages) {
					echo '<a class="button" href="' . esc_url(add_query_arg('paged', $paged + 1, $base_url)) . '">بعدی ▶</a>';
				}
				?>
			</div>
		<?php endif; ?>
	<?php else: ?>
		<p>هیچ کلیکی یافت نشد.</p>
	<?php endif; ?>
</div>