# Javascript Disposable Email Blocker

**Contributors:** tombaio \
**Donate link:** https://tomba.io/ \
**Tags:** comments, spam, form, javascript,email form validation \
**Requires at least:** 3.0.1 \
**Tested up to:** 6.4 \
**Stable tag:** 1.0.0 \
**Requires PHP:** 7.1 \
**License:** GPLv2 or later \
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html

This plugin ensures your forms accept only legitimate email addresses using JavaScript, enhancing your site's security and user experience.

## Description

Elevate the security and reliability of your online forms with this indispensable, fully customizable plugin. It plays a pivotal role in minimizing spam, improving user interactions, and safeguarding your website's data integrity.

The plugin is also fully customizable.
The plugin serves as a critical tool in reducing spam, improving user experience, and maintaining the integrity of your website's data.

### Supported Plugins

The [Javascript Disposable Email Blocker](https://github.com/tomba-io/disposable-email-blocker) by tomba.io plugin supports a rich set of popular form-based plugins. 

* Elementor Form
* WooCommerce
* Fluent Form
* Gravity Forms
* MailChimp
* Ninja Forms
* Profile Builder
* Formidable forms
* Ultimate Member registration form
* Mailster Form
* Users Ultra registration form
* JetPack comments and a contact form
* Theme My Login
* Contact Form
* WP-Members
* Paid Memberships Pro
* MailPoet
* WP Forms
* Visual Form Builder
* Any WordPress registrations & contact forms   
* WS Form 
* Form Maker by 10Web

### Key Features

* Protect all HTML Forms.
* Detect invalid emails.
* Detect invalid Domains.
* Detect and Block disposable emails.
* We crawl the disposable email domains daily to keep safe from fake uses.
* Detect and Block webmail emails.
* Custom Error Message

### How to use

- First install the Javascript Disposable Email Blocker plugin
- Enjoy!


### FURTHER READING

Read more about Tomba Email Finder

* [Domain Search](https://tomba.io/domain-search) (Search emails are based on the website You give one domain name and it returns all the email addresses found on the internet.)
* [Email Finder](https://tomba.io/email-finder) (This API endpoint generates or retrieves the most likely email address from a domain name, a first name and a last name..)
* [Author Finder](https://tomba.io/author-finder) (Instantly discover the email addresses of article authors.)
* [Enrichment](https://tomba.io/author-finder) (The Enrichment lets you find the current job title, company, location and social profiles of the person behind the email.)
* [Linkedin Finder](https://tomba.io/author-finder) (The Linkedin lets you find the current job title, company, location and social profiles of the person behind the linkedin URL.)
* [Email Verifier](https://tomba.io/email-verifier) (checks the deliverability of a given email address, verifies if it has been found in our database, and returns their sources.)

### Feedback

- Liked that plugin? Hate it? Want a new feature? [Send me some feedback](mailto:support@tomba.io 'Send feedback')


* For installation help click on Installation Tab

## Installation

### Installation using WordPress dashboard

1. Select **Plugins -> Add New**.
2. Search for "Javascript Disposable Email Blocker by tomba.io".
3. Click on *Install Now* to install the plugin.
4. Click on *Activate* button to activate the plugin.
5. Configure the plugin settings.

### Manual Installation

1. Upload the plugin files to the `/wp-content/plugins/javascript-disposable-email-blocker` directory.
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Configure the plugin settings.

## Frequently Asked Questions

### Is Javascript Disposable Email Blocker free?

Yes, Javascript Disposable Email Blocker is a free .

### How does this plugin work?

The Javascript Disposable Email Blocker listens to the email address capture flow for all major forms.

### Can I change Javascript Disposable Email Blocker settings?

Yes, you can change Javascript Disposable Email Blocker settings from the right sidebar.

### How to block webmail emails?

When you open settings in the list of options you can find the block webmail settings.

### Where can I report bugs?

Creating a new issue on GitHub [https://github.com/tomba-io/javascript-disposable-email-blocker/issues](https://github.com/tomba-io/javascript-disposable-email-blocker/issues)

## Screenshots

### 1. Javascript Disposable Email Blocker on comment

![Javascript Disposable Email Blocker on comment](/assets/screenshot-1.png)

### 2. Javascript Disposable Email Blocker on register page

![Javascript Disposable Email Blocker on register page](/assets/screenshot-2.png)

### 3. Javascript Disposable Email Blocker Block webmail accepting only professional email address.

![Javascript Disposable Email Blocker Block webmail accepting only professional email address.](/assets/screenshot-3.png)

### 4. Javascript Disposable Email Blocker Settings

![Javascript Disposable Email Blocker Settings](/assets/screenshot-4.png)


## Changelog

### 1.0.0

* Initial release

## Upgrade Notice

### 1.0.0

* Initial release
