<?php

namespace Janey\SDK;

/**
 * Class Janey
 * 
 * @property Actions\Analyses $analyses
 * 
 * @package Janey\SDK
 */
final class Janey
{
    const API_VERSION = '1';
    
    private $accessToken;
    private $clientName = 'sdk';
    private $clientVersion = '1.0.0';
    private $site = '';
    
    protected $client;

    /**
     * Janey constructor.
     * @param $accessToken
     * @param $site
     * @param string $clientName
     * @param string $clientVersion
     * @param string $baseURI
     */
    public function __construct($accessToken, $site, $clientName = '', $clientVersion = '', $baseURI = '')
    {
        $this->accessToken = $accessToken;
        
        if (empty($baseURI)) {
            $baseURI = 'https://api-dev.janey.ai/';
        }
        
        if (!empty($clientName)) {
            $this->clientName = $clientName;
        }
        
        if (!empty($clientVersion)) {
            $this->clientVersion = $clientVersion;
        }
        
        $this->site = $site;

        $baseURI = rtrim($baseURI, '/') . '/v';
        
        $this->client = new Client([
            'base_uri' => $baseURI . self::API_VERSION . '/',
            'headers' => [
                'Authorization' => "Bearer {$accessToken}"
            ],
            'clientDetails' => [
                'site' => $this->site,
                'name' => $this->clientName,
                'version' => $this->clientVersion
            ]
        ]);
    }

    public function __get($action) 
    {
        /** @var \Janey\SDK\Actions\Action $class */
        $class = '\\Janey\\SDK\\Actions\\' . ucfirst($action);
        if (class_exists($class)) {
            return $class::getInstance($this->client);
        }
    }
}