<?php
namespace Janey\SDK;

class Client extends \GuzzleHttp\Client {
    private $clientDetails;
    
    public function __construct(array $config = [])
    {
        $this->clientDetails = $config['clientDetails'];
        unset($config['clientDetails']);
        
        parent::__construct($config);
    }
    
    public function post($uri, array $options = [])
    {
        if (!empty($options['json'])) {
            $options['json']['site'] = $this->clientDetails['site'];
            $options['json']['client'] = $this->clientDetails['name'];
            $options['json']['clientVersion'] = $this->clientDetails['version'];
        }
        
        return parent::post($uri, $options);
    }
}