<?php
namespace Janey\SDK\Actions;

final class Analyses extends Action {

    /**
     * @param string $content Content that should be analysed for tags
     * @param string $resourceId Identifier of the resource that's beeing analysed
     * @param float|null $threshold Only tag with higher relevance will be returned
     * @param int|null $limit Number of tags to return
     * @param string $url URL where the content comes from
     * @param bool|null $advanced Use advanced analysis
     * @param string|null $language Language of the content
     * @param int|null $units Maximum number of text units to analyse
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function tags($content, $resourceId, $threshold = null, $limit = null, $url = '', $advanced = null, $language = null, $units = null)
    {
        $data = [
            'content' => $content,
            'url' => $url,
            'resourceId' => $resourceId
        ];

        if ($threshold !== null) {
            $data['threshold'] = floatval($threshold);
        }

        if ($limit !== null) {
            $data['limit'] = intval($limit);
        }

        if ($advanced !== null) {
            $data['advanced'] = ($advanced == 'true');
        }

        if ($language !== null) {
            $data['language'] = $language;
        }

        if ($units !== null) {
            $data['units'] = intval($units);
        }

        return $this->client->post('analyses/tags', [
            'json' => $data
        ]);
    }

    /**
     * @param string $search Comma-separated search terms
     * @param string $resourceId Identifier of the resource that's beeing analysed
     * @param string $url URL where the content comes from
     * @param int $page Index of page to return
     * @param int $per_page Number of pictures to return per page
     * @param string|null $orientation 'landscape'|'portrait'|'squarish'|null
     * @param string|null $collections Comma-separated collections to filter by|null
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function pictures($search, $resourceId, $url = '', $page = 1, $per_page = 3, $orientation = null, $collections = null)
    {
        $data = [
            'search' => $search,
            'page' => $page,
            'per_page' => $per_page,
            'orientation' => $orientation,
            'collections' => $collections,
            'url' => $url,
            'resourceId' => $resourceId,
        ];

        return $this->client->post('analyses/pictures', [
            'json' => $data
        ]);
    }
}
