<?php

namespace Janey\SDK\Actions;

use GuzzleHttp\Client;

abstract class Action
{
    /**
     * @var Client
     */
    protected $client;
    
    /** @var Action */
    protected static $instance = null;

    /**
     * Analyses constructor.
     * @param Client $client
     */
    private function __construct(Client $client)
    {
        $this->client = $client;
    }
    
    public static function getInstance(Client $client)
    {
        if (!isset(static::$instance)) {
            static::$instance = new static($client);
        }

        return static::$instance;
    }
}